# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel


class ParseAsyncRequestFile(UncheckedBaseModel):
    """
    A file object containing either a URL or a fileId.
    """

    file_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="fileName")] = pydantic.Field(
        default=None
    )
    """
    The name of the file. If not set, the file name is taken from the url.
    """

    file_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="fileUrl")] = pydantic.Field(
        default=None
    )
    """
    A URL to download the file. For production use cases, we recommend using presigned URLs with a 5-15 minute expiration time. One of `fileUrl` or `fileId` must be provided.
    """

    file_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="fileId")] = pydantic.Field(
        default=None
    )
    """
    If you already have an Extend file id (for instance from running a workflow or a previous [file upload](https://docs.extend.ai/2025-04-21/developers/api-reference/file-endpoints/upload-file)) then you can use that file id when running the parse endpoint so that it leverage any cached data that might be available. The file id will start with "file_". One of `fileUrl` or `fileId` must be provided.
    
    Example: `"file_xK9mLPqRtN3vS8wF5hB2cQ"`
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
