# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .parse_config_advanced_options import ParseConfigAdvancedOptions
from .parse_config_block_options import ParseConfigBlockOptions
from .parse_config_chunking_strategy import ParseConfigChunkingStrategy
from .parse_config_target import ParseConfigTarget


class ParseConfig(UncheckedBaseModel):
    """
    Configuration options for the parsing process.
    """

    target: typing.Optional[ParseConfigTarget] = pydantic.Field(default=None)
    """
    The target format for the parsed content.
    
    Supported values:
    
    * `markdown`: True markdown with logical reading order (headings, lists, tables, checkboxes). Best default for LLMs/RAG and enables section-based chunking.
    * `spatial`: Layout/position-preserving text that uses markdown elements for block types but is not strictly markdown due to whitespace/tabs used to maintain placement. Only page-based chunking is supported.
    
    Guidance:
    
    * Prefer `markdown` for most documents, multi-column reading order, and retrieval use cases
    * Prefer `spatial` for messy/scanned/handwritten or skewed documents, when you need near 1:1 layout fidelity, or for BOL-like logistics docs
    
    See “Markdown vs Spatial” in the Parse guide for details: /2025-04-21/developers/guides/parse#markdown-vs-spatial
    """

    chunking_strategy: typing_extensions.Annotated[
        typing.Optional[ParseConfigChunkingStrategy], FieldMetadata(alias="chunkingStrategy")
    ] = pydantic.Field(default=None)
    """
    Strategy for dividing the document into chunks.
    """

    block_options: typing_extensions.Annotated[
        typing.Optional[ParseConfigBlockOptions], FieldMetadata(alias="blockOptions")
    ] = pydantic.Field(default=None)
    """
    Options for controlling how different block types are processed.
    """

    advanced_options: typing_extensions.Annotated[
        typing.Optional[ParseConfigAdvancedOptions], FieldMetadata(alias="advancedOptions")
    ] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
