# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .page_ranges import PageRanges


class ParseConfigAdvancedOptions(UncheckedBaseModel):
    page_rotation_enabled: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="pageRotationEnabled")
    ] = pydantic.Field(default=None)
    """
    Whether to automatically detect and correct page rotation.
    """

    agentic_ocr_enabled: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="agenticOcrEnabled")
    ] = pydantic.Field(default=None)
    """
    Whether to enable agentic OCR corrections using VLM-based review and correction of OCR errors for messy handwriting and poorly scanned text.
    """

    page_ranges: typing_extensions.Annotated[typing.Optional[PageRanges], FieldMetadata(alias="pageRanges")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
