# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .parse_config_block_options_figures import ParseConfigBlockOptionsFigures
from .parse_config_block_options_tables import ParseConfigBlockOptionsTables
from .parse_config_block_options_text import ParseConfigBlockOptionsText


class ParseConfigBlockOptions(UncheckedBaseModel):
    """
    Options for controlling how different block types are processed.
    """

    figures: typing.Optional[ParseConfigBlockOptionsFigures] = pydantic.Field(default=None)
    """
    Options for figure blocks.
    """

    tables: typing.Optional[ParseConfigBlockOptionsTables] = pydantic.Field(default=None)
    """
    Options for table blocks.
    """

    text: typing.Optional[ParseConfigBlockOptionsText] = pydantic.Field(default=None)
    """
    Options for text blocks.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
