# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .parse_config_block_options_tables_target_format import ParseConfigBlockOptionsTablesTargetFormat


class ParseConfigBlockOptionsTables(UncheckedBaseModel):
    """
    Options for table blocks.
    """

    enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to include tables in the output.
    """

    target_format: typing_extensions.Annotated[
        typing.Optional[ParseConfigBlockOptionsTablesTargetFormat], FieldMetadata(alias="targetFormat")
    ] = pydantic.Field(default=None)
    """
    The target format for the table blocks. Supported values:
    * `markdown`: Convert table to Markdown format
    * `html`: Convert table to HTML format
    """

    table_header_continuation_enabled: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="tableHeaderContinuationEnabled")
    ] = pydantic.Field(default=None)
    """
    Whether to automatically copy table headers to headerless tables on subsequent pages when they have matching column counts. Useful for multi-page tables.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
