# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .parse_config_chunking_strategy_options import ParseConfigChunkingStrategyOptions
from .parse_config_chunking_strategy_type import ParseConfigChunkingStrategyType


class ParseConfigChunkingStrategy(UncheckedBaseModel):
    """
    Strategy for dividing the document into chunks.
    """

    type: typing.Optional[ParseConfigChunkingStrategyType] = pydantic.Field(default=None)
    """
    The type of chunking strategy. Supported values:
    
    * `page`: Chunk document by pages.
    * `document`: Entire document is a single chunk. Essentially no chunking.
    * `section`: Split by logical sections. Not supported for target=spatial.
    """

    options: typing.Optional[ParseConfigChunkingStrategyOptions] = pydantic.Field(default=None)
    """
    Additional options for the chunking strategy.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
