# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .chunk import Chunk
from .parse_config import ParseConfig
from .parser_run_credits import ParserRunCredits
from .parser_run_metrics import ParserRunMetrics
from .parser_run_status_enum import ParserRunStatusEnum


class ParserRun(UncheckedBaseModel):
    """
    Full parser run object with complete parsing results
    """

    id: str = pydantic.Field()
    """
    A unique identifier for the parser run. Will always start with `"parser_run_"`
    
    Example: `"parser_run_xK9mLPqRtN3vS8wF5hB2cQ"`
    """

    file_id: typing_extensions.Annotated[str, FieldMetadata(alias="fileId")] = pydantic.Field()
    """
    The identifier of the file that was parsed. This can be used as a parameter to other Extend endpoints, such as processor runs.
    """

    chunks: typing.List[Chunk] = pydantic.Field()
    """
    An array of chunks that were parsed from the file.
    """

    status: ParserRunStatusEnum = pydantic.Field()
    """
    The status of the parser run:
    * `"PROCESSED"` - The file was successfully processed
    * `"FAILED"` - The processing failed (see failureReason for details)
    """

    failure_reason: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="failureReason")] = (
        pydantic.Field(default=None)
    )
    """
    The reason for failure if status is "FAILED".
    """

    metrics: ParserRunMetrics = pydantic.Field()
    """
    Metrics about the parsing process.
    """

    config: ParseConfig = pydantic.Field()
    """
    The configuration used for the parsing process, including any default values that were applied.
    """

    usage: typing.Optional[ParserRunCredits] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
