# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .parser_run_status_status import ParserRunStatusStatus


class ParserRunStatus(UncheckedBaseModel):
    """
    Minimal parser run status object without parser results.
    """

    id: str = pydantic.Field()
    """
    A unique identifier for the parser run. Will always start with `"parser_run_"`
    
    Example: `"parser_run_xK9mLPqRtN3vS8wF5hB2cQ"`
    """

    status: ParserRunStatusStatus = pydantic.Field()
    """
    The status of the parser run.
    """

    failure_reason: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="failureReason")] = (
        pydantic.Field(default=None)
    )
    """
    The reason for failure if status is "FAILED".
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
