# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .processor_type import ProcessorType
from .processor_version import ProcessorVersion


class Processor(UncheckedBaseModel):
    object: str = pydantic.Field()
    """
    The type of response. In this case, it will always be `"document_processor"`.
    """

    id: str = pydantic.Field()
    """
    The ID of the processor.
    
    Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`
    """

    name: str = pydantic.Field()
    """
    The name of the processor.
    
    Example: `"Invoice Processor"`
    """

    type: ProcessorType
    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")] = pydantic.Field()
    """
    The time (in UTC) at which the processor was created. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T15:30:00Z"`
    """

    updated_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="updatedAt")] = pydantic.Field()
    """
    The time (in UTC) at which the processor was last updated. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T16:45:00Z"`
    """

    draft_version: typing_extensions.Annotated[ProcessorVersion, FieldMetadata(alias="draftVersion")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .extraction_field import ExtractionField  # noqa: E402, F401, I001

update_forward_refs(Processor)
