# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .document_processor_run_credits import DocumentProcessorRunCredits
from .extraction_output_edits import ExtractionOutputEdits
from .file import File
from .json_object import JsonObject
from .processor_output import ProcessorOutput
from .processor_run_config import ProcessorRunConfig
from .processor_run_merged_processors_item import ProcessorRunMergedProcessorsItem
from .processor_run_type import ProcessorRunType
from .processor_status import ProcessorStatus


class ProcessorRun(UncheckedBaseModel):
    object: str = pydantic.Field()
    """
    The type of response. In this case, it will always be `"document_processor_run"`.
    """

    id: str = pydantic.Field()
    """
    The unique identifier for this processor run.
    
    Example: `"dpr_Xj8mK2pL9nR4vT7qY5wZ"`
    """

    processor_id: typing_extensions.Annotated[str, FieldMetadata(alias="processorId")] = pydantic.Field()
    """
    The ID of the processor used for this run.
    
    Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`
    """

    processor_version_id: typing_extensions.Annotated[str, FieldMetadata(alias="processorVersionId")] = pydantic.Field()
    """
    The ID of the specific processor version used.
    """

    processor_name: typing_extensions.Annotated[str, FieldMetadata(alias="processorName")] = pydantic.Field()
    """
    The name of the processor.
    
    Example: `"Invoice Processor"`
    """

    status: ProcessorStatus
    output: ProcessorOutput = pydantic.Field()
    """
    The final output, either reviewed or initial.
    
    Conforms to the shape of output types and depends on the processor type and configuration shape.
    """

    failure_reason: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="failureReason")] = (
        pydantic.Field(default=None)
    )
    """
    If the run failed, indicates the reason for failure.
    """

    failure_message: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="failureMessage")] = (
        pydantic.Field(default=None)
    )
    """
    If the run failed, provides a detailed message about the failure.
    """

    metadata: typing.Optional[JsonObject] = pydantic.Field(default=None)
    """
    Any metadata that was provided when creating the processor run.
    """

    reviewed: bool = pydantic.Field()
    """
    Indicates whether the run has been reviewed.
    """

    edited: bool = pydantic.Field()
    """
    Indicates whether the run results have been edited.
    """

    edits: typing.Dict[str, ExtractionOutputEdits]
    type: ProcessorRunType = pydantic.Field()
    """
    The type of processor:
    * `"CLASSIFY"` - Classifies documents into categories
    * `"EXTRACT"` - Extracts structured data from documents
    * `"SPLITTER"` - Splits documents into multiple parts
    """

    config: ProcessorRunConfig = pydantic.Field()
    """
    The configuration used for this processor run. The type of configuration will match the processor type.
    """

    initial_output: typing_extensions.Annotated[
        typing.Optional[ProcessorOutput], FieldMetadata(alias="initialOutput")
    ] = pydantic.Field(default=None)
    """
    The initial output from the processor run. The type of output will match the processor type.
    """

    reviewed_output: typing_extensions.Annotated[
        typing.Optional[ProcessorOutput], FieldMetadata(alias="reviewedOutput")
    ] = pydantic.Field(default=None)
    """
    The output after review, if any.
    """

    files: typing.List[File] = pydantic.Field()
    """
    Details of the processed files.
    
    If this was a file generated from a splitter processor, this will be the sub file.
    
    See the File object for more details.
    """

    merged_processors: typing_extensions.Annotated[
        typing.List[ProcessorRunMergedProcessorsItem], FieldMetadata(alias="mergedProcessors")
    ] = pydantic.Field()
    """
    An array of processors that were merged to create this output. Will be an empty array unless this output was the result of a MergeExtraction step in a workflow.
    """

    url: str = pydantic.Field()
    """
    The URL to view the processor run.
    """

    usage: typing.Optional[DocumentProcessorRunCredits] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .extraction_field import ExtractionField  # noqa: E402, F401, I001

update_forward_refs(ProcessorRun)
