# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .document_processor_run_credits import DocumentProcessorRunCredits
from .processor_run_summary_type import ProcessorRunSummaryType
from .processor_status import ProcessorStatus


class ProcessorRunSummary(UncheckedBaseModel):
    id: str = pydantic.Field()
    """
    The ID of the processor run.
    
    Example: `"dpr_Zk9mNP12Qw4-yTv8BdR3H"`
    """

    status: ProcessorStatus
    processor_id: typing_extensions.Annotated[str, FieldMetadata(alias="processorId")] = pydantic.Field()
    """
    The ID of the processor that was run. Will always start with "dp_".
    
    Example: `"dp_BMdfq_yWM3sT-ZzvCnA3f"`
    """

    processor_name: typing_extensions.Annotated[str, FieldMetadata(alias="processorName")] = pydantic.Field()
    """
    The name of the processor that was run.
    
    Example: `"Invoice Extractor"`
    """

    processor_version_id: typing_extensions.Annotated[str, FieldMetadata(alias="processorVersionId")] = pydantic.Field()
    """
    The ID of the processor version that was run. Will always start with "dpv_".
    
    Example: `"dpv_Zk9mNP12Qw4-yTv8BdR3H"`
    """

    type: typing.Optional[ProcessorRunSummaryType] = pydantic.Field(default=None)
    """
    The type of processor that was run:
    * `"EXTRACT"` - Extraction processor
    * `"SPLITTER"` - Splitting processor
    * `"CLASSIFY"` - Classification processor
    """

    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")] = pydantic.Field()
    """
    The time (in UTC) at which the processor run was created. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T15:29:55Z"`
    """

    updated_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="updatedAt")] = pydantic.Field()
    """
    The time (in UTC) at which the processor run was last updated. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T16:45:00Z"`
    """

    usage: typing.Optional[DocumentProcessorRunCredits] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
