# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .processor_type import ProcessorType
from .processor_version_config import ProcessorVersionConfig


class ProcessorVersion(UncheckedBaseModel):
    object: str = pydantic.Field()
    """
    The type of the object. In this case, it will always be `"document_processor_version"`.
    """

    id: str = pydantic.Field()
    """
    The unique identifier for this version of the document processor.
    
    Example: `"dpv_xK9mLPqRtN3vS8wF5hB2cQ"`
    """

    processor_id: typing_extensions.Annotated[str, FieldMetadata(alias="processorId")] = pydantic.Field()
    """
    The ID of the parent document processor.
    
    Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`
    """

    processor_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="processorName")] = (
        pydantic.Field(default=None)
    )
    """
    The name of the parent document processor.
    
    Example: `"Invoice Processor"`
    """

    processor_type: typing_extensions.Annotated[ProcessorType, FieldMetadata(alias="processorType")]
    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    An optional description of this version of the document processor.
    
    Example: `"Updated extraction fields for new invoice format"`
    """

    version: str = pydantic.Field()
    """
    The version number or identifier for this specific version of the document processor. The draft version will have version="draft".
    
    Examples: `"1.0"`, `"2.1"`, `"draft"`
    """

    config: ProcessorVersionConfig = pydantic.Field()
    """
    The configuration settings for this version of the document processor. The structure of this object will vary depending on the processor type.
    
    See the configuration section in the "Guides" tab, for yout specific processor type, for more details on the configuration settings.
    """

    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")] = pydantic.Field()
    """
    The time (in UTC) at which this version of the document processor was created. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T15:30:00Z"`
    """

    updated_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="updatedAt")] = pydantic.Field()
    """
    The time (in UTC) at which this version of the document processor was last updated. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T16:45:00Z"`
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .extraction_field import ExtractionField  # noqa: E402, F401, I001

update_forward_refs(ProcessorVersion)
