# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .page_ranges import PageRanges
from .splitter_advanced_options_split_method import SplitterAdvancedOptionsSplitMethod


class SplitterAdvancedOptions(UncheckedBaseModel):
    split_identifier_rules: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="splitIdentifierRules")
    ] = pydantic.Field(default=None)
    """
    Custom rules for identifying split points.
    """

    split_method: typing_extensions.Annotated[
        typing.Optional[SplitterAdvancedOptionsSplitMethod], FieldMetadata(alias="splitMethod")
    ] = pydantic.Field(default=None)
    """
    The method to use for splitting documents. `high_precision` is more accurate but slower, while `low_latency` is faster but less precise.
    """

    split_excel_documents_by_sheet_enabled: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="splitExcelDocumentsBySheetEnabled")
    ] = pydantic.Field(default=None)
    """
    For Excel documents, split by worksheet.
    """

    fixed_page_limit: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="fixedPageLimit")] = (
        pydantic.Field(default=None)
    )
    """
    Limit processing to a specific number of pages from the beginning of the document. See [Page Ranges](/product/page-ranges).
    """

    page_ranges: typing_extensions.Annotated[typing.Optional[PageRanges], FieldMetadata(alias="pageRanges")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
