# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .classification import Classification
from .parse_config import ParseConfig
from .splitter_advanced_options import SplitterAdvancedOptions
from .splitter_config_base_processor import SplitterConfigBaseProcessor


class SplitterConfig(UncheckedBaseModel):
    base_processor: typing_extensions.Annotated[
        typing.Optional[SplitterConfigBaseProcessor], FieldMetadata(alias="baseProcessor")
    ] = pydantic.Field(default=None)
    """
    The base processor to use. For splitters, this can currently only be `"splitting_performance"` or `"splitting_light"`. See [Splitting Changelog](/changelog/splitting/splitting-performance) for more details.
    """

    base_version: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="baseVersion")] = (
        pydantic.Field(default=None)
    )
    """
    The version of the `"splitting_performance"` or `"splitting_light"` processor to use. If this is provided, the `baseProcessor` must also be provided. See [Splitting Changelog](/changelog/splitting/splitting-performance) for more details.
    """

    split_classifications: typing_extensions.Annotated[
        typing.List[Classification], FieldMetadata(alias="splitClassifications")
    ] = pydantic.Field()
    """
    Array of classifications that define the possible types of document sections.
    """

    split_rules: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="splitRules")] = pydantic.Field(
        default=None
    )
    """
    Custom rules to guide the document splitting process in natural language.
    """

    advanced_options: typing_extensions.Annotated[
        typing.Optional[SplitterAdvancedOptions], FieldMetadata(alias="advancedOptions")
    ] = pydantic.Field(default=None)
    """
    Advanced configuration options.
    """

    parser: typing.Optional[ParseConfig] = pydantic.Field(default=None)
    """
    Configuration options for the parsing process.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
