# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from .base_metrics import BaseMetrics


class SplitterMetrics(BaseMetrics):
    """
    Metrics specific to splitter processors
    """

    type: typing.Optional[typing.Literal["SPLITTER"]] = pydantic.Field(default=None)
    """
    The type of metrics. Will always be `"SPLITTER"` for splitter processors.
    """

    precision_perc: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="precisionPerc")] = (
        pydantic.Field(default=None)
    )
    """
    Number of predicted subdocuments that are in the expected set of subdocuments divided by total number of predicted subdocuments.
    """

    recall_perc: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="recallPerc")] = (
        pydantic.Field(default=None)
    )
    """
    Number of expected subdocuments that are in the predicted set of subdocuments divided by total number of expected subdocuments.
    """

    num_expected_docs: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="numExpectedDocs")] = (
        pydantic.Field(default=None)
    )
    """
    The number of expected documents.
    """

    num_predicted_docs: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="numPredictedDocs")] = (
        pydantic.Field(default=None)
    )
    """
    The number of predicted documents.
    """

    num_correct_docs: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="numCorrectDocs")] = (
        pydantic.Field(default=None)
    )
    """
    The number of correctly predicted documents.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
