# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel


class SplitterOutputSplitsItem(UncheckedBaseModel):
    type: str = pydantic.Field()
    """
    The type of the split document (set in the processor config), corresponds to the classificationId
    """

    observation: str = pydantic.Field()
    """
    Explanation of the results
    """

    identifier: str = pydantic.Field()
    """
    Identifier for the split document (e.g. invoice number)
    """

    start_page: typing_extensions.Annotated[int, FieldMetadata(alias="startPage")] = pydantic.Field()
    """
    The start page of the split document
    """

    end_page: typing_extensions.Annotated[int, FieldMetadata(alias="endPage")] = pydantic.Field()
    """
    The end page of the split document
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional name for the split
    """

    classification_id: typing_extensions.Annotated[str, FieldMetadata(alias="classificationId")] = pydantic.Field()
    """
    ID of the classification type (set in the processor config)
    """

    id: str = pydantic.Field()
    """
    Unique ID for this split
    """

    file_id: typing_extensions.Annotated[str, FieldMetadata(alias="fileId")] = pydantic.Field()
    """
    File ID associated with this split
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
