# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .step_run_output_rules_item_failure_reason import StepRunOutputRulesItemFailureReason


class StepRunOutputRulesItem(UncheckedBaseModel):
    name: str = pydantic.Field()
    """
    The name of the validation rule.
    """

    valid: bool = pydantic.Field()
    """
    Indicates whether this validation rule passed or not. This field will be `true` only if the formula evaluates to `true`. If the rule's formula is array valued, then this field will only be `true` if the formula evaluates to `true` for every item in the array.
    """

    valid_array: typing_extensions.Annotated[typing.Optional[typing.List[str]], FieldMetadata(alias="validArray")] = (
        pydantic.Field(default=None)
    )
    """
    Only present if the validation rule's formula is array valued. This field contains the formula's evaluated result for every item in the array.
    """

    failure_reason: typing_extensions.Annotated[
        typing.Optional[StepRunOutputRulesItemFailureReason], FieldMetadata(alias="failureReason")
    ] = pydantic.Field(default=None)
    """
    If the validation rule is not valid, then this describes why the rule failed.
    * `"RULE_FAILED"` - The formula evaluated to `false` or `null`
    * `"PARSE_ERROR"` - The formula could not be parsed
    * `"VALUE_ERROR"` - An error occurred while evaluating the formula
    """

    error: typing.Optional[str] = pydantic.Field(default=None)
    """
    If the `failureReason` is `PARSE_ERROR` or `VALUE_ERROR`, then this field contains the error's details.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
