# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel


class TableDetails(UncheckedBaseModel):
    """
    Details for table blocks
    """

    type: typing.Literal["table_details"] = pydantic.Field(default="table_details")
    """
    Indicates this is a table details object
    """

    row_count: typing_extensions.Annotated[int, FieldMetadata(alias="rowCount")] = pydantic.Field()
    """
    The number of rows in the table
    """

    column_count: typing_extensions.Annotated[int, FieldMetadata(alias="columnCount")] = pydantic.Field()
    """
    The number of columns in the table
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
