# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .processor import Processor
from .webhook_event_processor_event_type import WebhookEventProcessorEventType


class WebhookEventProcessor(UncheckedBaseModel):
    """
    Webhook event for processor related events
    """

    event_type: typing_extensions.Annotated[
        typing.Optional[WebhookEventProcessorEventType], FieldMetadata(alias="eventType")
    ] = None
    payload: typing.Optional[Processor] = None
    event_id: typing_extensions.Annotated[str, FieldMetadata(alias="eventId")] = pydantic.Field()
    """
    Unique identifier for the event
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .extraction_field import ExtractionField  # noqa: E402, F401, I001

update_forward_refs(WebhookEventProcessor)
