# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class Workflow(UncheckedBaseModel):
    object: str = pydantic.Field()
    """
    The type of response. In this case, it will always be `"workflow"`.
    """

    id: str = pydantic.Field()
    """
    The ID of the workflow.
    
    Example: `"workflow_BMlfq_yWM3sT-ZzvCnA3f"`
    """

    version: str = pydantic.Field()
    """
    The version of the workflow.
    
    Examples: `"3"`, `"draft"`
    """

    name: str = pydantic.Field()
    """
    The name of the workflow.
    
    Example: `"Invoice Processing"`
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
