# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .provided_processor_output import ProvidedProcessorOutput


class WorkflowRunFileInputOutputsItem(UncheckedBaseModel):
    processor_id: typing_extensions.Annotated[str, FieldMetadata(alias="processorId")] = pydantic.Field()
    """
    The ID of the processor that the output is associated with.
    Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`
    """

    output: ProvidedProcessorOutput = pydantic.Field()
    """
    The output that is being overridden. The structure will depend on the processor type. More details can be found on the "output type" page for the corresponding processor, in the guides section.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
