# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .workflow_run_credits import WorkflowRunCredits
from .workflow_status import WorkflowStatus


class WorkflowRunSummary(UncheckedBaseModel):
    id: str = pydantic.Field()
    """
    The ID of the workflow run.
    
    Example: `"workflow_run_Zk9mNP12Qw4-yTv8BdR3H"`
    """

    status: WorkflowStatus
    initial_run_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="initialRunAt")] = (
        pydantic.Field(default=None)
    )
    """
    The time (in UTC) at which the workflow was initially created. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T15:30:00Z"`
    """

    reviewed_by_user: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="reviewedByUser")] = (
        pydantic.Field(default=None)
    )
    """
    The user of the person who reviewed the workflow run. Will not be included if the workflow run has not been reviewed.
    
    Example: `"jane.doe@example.com"`
    """

    reviewed_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="reviewedAt")] = (
        pydantic.Field(default=None)
    )
    """
    The time (in UTC) at which the workflow run was reviewed. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T16:45:00Z"`
    """

    start_time: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="startTime")] = (
        pydantic.Field(default=None)
    )
    """
    The start time (in UTC) that the workflow actually started executing. This occurs after the `initialRunAt` time. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T15:30:00Z"`
    """

    end_time: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="endTime")] = (
        pydantic.Field(default=None)
    )
    """
    The end time (in UTC) that the workflow finished. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T15:35:00Z"`
    """

    workflow_id: typing_extensions.Annotated[str, FieldMetadata(alias="workflowId")] = pydantic.Field()
    """
    The ID of the workflow that was run. Will always start with "workflow".
    
    Example: `"workflow_BMdfq_yWM3sT-ZzvCnA3f"`
    """

    workflow_name: typing_extensions.Annotated[str, FieldMetadata(alias="workflowName")] = pydantic.Field()
    """
    The name of the workflow that was run.
    
    Example: `"Invoice Processing"`
    """

    workflow_version_id: typing_extensions.Annotated[str, FieldMetadata(alias="workflowVersionId")] = pydantic.Field()
    """
    The ID of the workflow version that was run. Will always start with "workflow_version".
    
    Example: `"workflow_version_Zk9mNP12Qw4-yTv8BdR3H"`
    """

    batch_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="batchId")] = pydantic.Field(
        default=None
    )
    """
    The batch ID of the WorkflowRun. If that WorkflowRun was created from a batch of files, all runs in that batch will have the same batch ID.
    
    Example: `"batch_7Ws31-F5"`
    """

    rejection_note: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="rejectionNote")] = (
        pydantic.Field(default=None)
    )
    """
    The note that was added when the workflow run was rejected.
    
    Example: `"Invalid invoice format"`
    """

    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")] = pydantic.Field()
    """
    The time (in UTC) at which the workflow run was created. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T15:29:55Z"`
    """

    updated_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="updatedAt")] = pydantic.Field()
    """
    The time (in UTC) at which the workflow run was last updated. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T16:45:00Z"`
    """

    usage: typing.Optional[WorkflowRunCredits] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
