# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawWorkflowClient, RawWorkflowClient
from .types.workflow_create_response import WorkflowCreateResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WorkflowClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWorkflowClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWorkflowClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWorkflowClient
        """
        return self._raw_client

    def create(self, *, name: str, request_options: typing.Optional[RequestOptions] = None) -> WorkflowCreateResponse:
        """
        Create a new workflow in Extend. Workflows are sequences of steps that process files and data in a specific order to achieve a desired outcome.

        This endpoint will create a new workflow in Extend, which can then be configured and deployed. Typically, workflows are created from our UI, however this endpoint can be used to create workflows programmatically. Configuration of the flow still needs to be done in the dashboard.

        Parameters
        ----------
        name : str
            The name of the workflow

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowCreateResponse
            Successfully created workflow

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.workflow.create(name='Invoice Processing', )
        """
        _response = self._raw_client.create(name=name, request_options=request_options)
        return _response.data


class AsyncWorkflowClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWorkflowClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWorkflowClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWorkflowClient
        """
        return self._raw_client

    async def create(
        self, *, name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowCreateResponse:
        """
        Create a new workflow in Extend. Workflows are sequences of steps that process files and data in a specific order to achieve a desired outcome.

        This endpoint will create a new workflow in Extend, which can then be configured and deployed. Typically, workflows are created from our UI, however this endpoint can be used to create workflows programmatically. Configuration of the flow still needs to be done in the dashboard.

        Parameters
        ----------
        name : str
            The name of the workflow

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowCreateResponse
            Successfully created workflow

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.workflow.create(name='Invoice Processing', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(name=name, request_options=request_options)
        return _response.data
