# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.json_object import JsonObject
from ..types.max_page_size import MaxPageSize
from ..types.next_page_token import NextPageToken
from ..types.sort_by_enum import SortByEnum
from ..types.sort_dir_enum import SortDirEnum
from ..types.workflow_run_file_input import WorkflowRunFileInput
from ..types.workflow_status import WorkflowStatus
from .raw_client import AsyncRawWorkflowRunClient, RawWorkflowRunClient
from .types.workflow_run_cancel_response import WorkflowRunCancelResponse
from .types.workflow_run_create_response import WorkflowRunCreateResponse
from .types.workflow_run_delete_response import WorkflowRunDeleteResponse
from .types.workflow_run_get_response import WorkflowRunGetResponse
from .types.workflow_run_list_response import WorkflowRunListResponse
from .types.workflow_run_update_response import WorkflowRunUpdateResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WorkflowRunClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWorkflowRunClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWorkflowRunClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWorkflowRunClient
        """
        return self._raw_client

    def list(
        self,
        *,
        status: typing.Optional[WorkflowStatus] = None,
        workflow_id: typing.Optional[str] = None,
        batch_id: typing.Optional[str] = None,
        file_name_contains: typing.Optional[str] = None,
        sort_by: typing.Optional[SortByEnum] = None,
        sort_dir: typing.Optional[SortDirEnum] = None,
        next_page_token: typing.Optional[NextPageToken] = None,
        max_page_size: typing.Optional[MaxPageSize] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowRunListResponse:
        """
        List runs of a Workflow. Workflows are sequences of steps that process files and data in a specific order to achieve a desired outcome. A WorkflowRun represents a single execution of a workflow against a file.

        Parameters
        ----------
        status : typing.Optional[WorkflowStatus]
            Filters workflow runs by their status. If not provided, no filter is applied.

             The status of a workflow run:
             * `"PENDING"` - The workflow run has not started yet
             * `"PROCESSING"` - The workflow run is in progress
             * `"NEEDS_REVIEW"` - The workflow run requires manual review
             * `"REJECTED"` - The workflow run was rejected during manual review
             * `"PROCESSED"` - The workflow run completed successfully
             * `"FAILED"` - The workflow run encountered an error
             * `"CANCELLED"` - The workflow run was cancelled
             * `"CANCELLING"` - The workflow run is being cancelled

        workflow_id : typing.Optional[str]
            Filters workflow runs by the workflow ID. If not provided, runs for all workflows are returned.

            Example: `"workflow_BMdfq_yWM3sT-ZzvCnA3f"`

        batch_id : typing.Optional[str]
            Filters workflow runs by the batch ID. This is useful for fetching all runs for a given batch created via the [Batch Run Workflow](/developers/api-reference/workflow-endpoints/batch-run-workflow) endpoint.

            Example: `"batch_7Ws31-F5"`

        file_name_contains : typing.Optional[str]
            Filters workflow runs by the name of the file. Only returns workflow runs where the file name contains this string.

            Example: `"invoice"`

        sort_by : typing.Optional[SortByEnum]
            Sorts the workflow runs by the given field.

        sort_dir : typing.Optional[SortDirEnum]
            Sorts the workflow runs in ascending or descending order. Ascending order means the earliest workflow run is returned first.

        next_page_token : typing.Optional[NextPageToken]

        max_page_size : typing.Optional[MaxPageSize]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowRunListResponse
            You will get a list of summaries for each workflow run. These are shortened versions of the full WorkflowRun object.

            To get the full object, use the [Get WorkflowRun](/developers/api-reference/workflow-endpoints/get-workflow-run) endpoint.

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.workflow_run.list(status="PENDING", workflow_id='workflowId', batch_id='batchId', file_name_contains='fileNameContains', sort_by="updatedAt", sort_dir="asc", next_page_token='xK9mLPqRtN3vS8wF5hB2cQ==:zWvUxYjM4nKpL7aDgE9HbTcR2mAyX3/Q+CNkfBSw1dZ=', max_page_size=1, )
        """
        _response = self._raw_client.list(
            status=status,
            workflow_id=workflow_id,
            batch_id=batch_id,
            file_name_contains=file_name_contains,
            sort_by=sort_by,
            sort_dir=sort_dir,
            next_page_token=next_page_token,
            max_page_size=max_page_size,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        workflow_id: str,
        files: typing.Optional[typing.Sequence[WorkflowRunFileInput]] = OMIT,
        raw_texts: typing.Optional[typing.Sequence[str]] = OMIT,
        version: typing.Optional[str] = OMIT,
        priority: typing.Optional[int] = OMIT,
        metadata: typing.Optional[JsonObject] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowRunCreateResponse:
        """
        Run a Workflow with files. A Workflow is a sequence of steps that process files and data in a specific order to achieve a desired outcome. A WorkflowRun will be created for each file processed. A WorkflowRun represents a single execution of a workflow against a file.

        Parameters
        ----------
        workflow_id : str
            The ID of the workflow to run.

            Example: `"workflow_BMdfq_yWM3sT-ZzvCnA3f"`

        files : typing.Optional[typing.Sequence[WorkflowRunFileInput]]
            An array of files to process through the workflow. Either the `files` array or `rawTexts` array must be provided. Supported file types can be found [here](/product/general/supported-file-types). There is a limit if 50 files that can be processed at once using this endpoint. If you wish to process more at a time, consider using the [Batch Run Workflow](/developers/api-reference/workflow-endpoints/batch-run-workflow) endpoint.

        raw_texts : typing.Optional[typing.Sequence[str]]
            An array of raw strings. Can be used in place of files when passing raw data. The raw data will be converted to `.txt` files and run through the workflow. If the data follows a specific format, it is recommended to use the files parameter instead. Either `files` or `rawTexts` must be provided.

        version : typing.Optional[str]
            An optional version of the workflow that files will be run through. This number can be found when viewing the workflow on the Extend platform. When a version number is not supplied, the most recent published version of the workflow will be used. If no published versions exist, the draft version will be used. To run the `"draft"` version of a workflow, use `"draft"` as the version.

            Examples:
            - `"3"` - Run version 3 of the workflow
            - `"draft"` - Run the draft version of the workflow

        priority : typing.Optional[int]
            An optional value used to determine the relative order of WorkflowRuns when rate limiting is in effect. Lower values will be prioritized before higher values.

        metadata : typing.Optional[JsonObject]
            A optional metadata object that can be assigned to a specific WorkflowRun to help identify it. It will be returned in the response and webhooks. You can place any arbitrary `key : value` pairs in this object.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowRunCreateResponse
            Successfully created workflow runs

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.workflow_run.create(workflow_id='workflow_id_here', )
        """
        _response = self._raw_client.create(
            workflow_id=workflow_id,
            files=files,
            raw_texts=raw_texts,
            version=version,
            priority=priority,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    def get(
        self, workflow_run_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowRunGetResponse:
        """
        Once a workflow has been run, you can check the status and output of a specific WorkflowRun.

        Parameters
        ----------
        workflow_run_id : str
            The ID of the WorkflowRun that was outputted after a Workflow was run through the API.

            Example: `"workflow_run_8k9m-xyzAB_Pqrst-Nvw4"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowRunGetResponse
            Successfully retrieved workflow run

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.workflow_run.get(workflow_run_id='workflow_run_id_here', )
        """
        _response = self._raw_client.get(workflow_run_id, request_options=request_options)
        return _response.data

    def update(
        self,
        workflow_run_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        metadata: typing.Optional[JsonObject] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowRunUpdateResponse:
        """
        You can update the name and metadata of an in progress WorkflowRun at any time using this endpoint.

        Parameters
        ----------
        workflow_run_id : str
            The ID of the WorkflowRun. This ID will start with "workflow_run". This ID can be found in the API response when creating a Workflow Run, or in the "history" tab of a workflow on the Extend platform.

            Example: `"workflow_run_8k9m-xyzAB_Pqrst-Nvw4"`

        name : typing.Optional[str]
            An optional name that can be assigned to a specific WorkflowRun

        metadata : typing.Optional[JsonObject]
            A metadata object that can be assigned to a specific WorkflowRun. If metadata already exists on this WorkflowRun, the newly incoming metadata will be merged with the existing metadata, with the incoming metadata taking field precedence.

            You can include any arbitrary `key : value` pairs in this object.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowRunUpdateResponse
            Successfully updated workflow run

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.workflow_run.update(workflow_run_id='workflow_run_id_here', )
        """
        _response = self._raw_client.update(
            workflow_run_id, name=name, metadata=metadata, request_options=request_options
        )
        return _response.data

    def delete(
        self, workflow_run_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowRunDeleteResponse:
        """
        Delete a workflow run and all associated data from Extend. This operation is permanent and cannot be undone.

        This endpoint can be used if you'd like to manage data retention on your own rather than automated data retention policies. Or make one-off deletions for your downstream customers.

        Parameters
        ----------
        workflow_run_id : str
            The ID of the workflow run to delete.

            Example: `"workflow_run_xKm9pNv3qWsY_jL2tR5Dh"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowRunDeleteResponse
            Successfully deleted workflow run

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.workflow_run.delete(workflow_run_id='workflow_run_id_here', )
        """
        _response = self._raw_client.delete(workflow_run_id, request_options=request_options)
        return _response.data

    def cancel(
        self, workflow_run_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowRunCancelResponse:
        """
        Cancel a running workflow run by its ID. This endpoint allows you to stop a workflow run that is currently in progress.

        Note: Only workflow runs with a status of `PROCESSING` or `PENDING` can be cancelled. Workflow runs that are completed, failed, in review, rejected, or already cancelled cannot be cancelled.

        Parameters
        ----------
        workflow_run_id : str
            The ID of the workflow run to cancel.

            Example: `"workflow_run_xKm9pNv3qWsY_jL2tR5Dh"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowRunCancelResponse
            Successfully cancelled workflow run

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.workflow_run.cancel(workflow_run_id='workflow_run_id_here', )
        """
        _response = self._raw_client.cancel(workflow_run_id, request_options=request_options)
        return _response.data


class AsyncWorkflowRunClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWorkflowRunClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWorkflowRunClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWorkflowRunClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        status: typing.Optional[WorkflowStatus] = None,
        workflow_id: typing.Optional[str] = None,
        batch_id: typing.Optional[str] = None,
        file_name_contains: typing.Optional[str] = None,
        sort_by: typing.Optional[SortByEnum] = None,
        sort_dir: typing.Optional[SortDirEnum] = None,
        next_page_token: typing.Optional[NextPageToken] = None,
        max_page_size: typing.Optional[MaxPageSize] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowRunListResponse:
        """
        List runs of a Workflow. Workflows are sequences of steps that process files and data in a specific order to achieve a desired outcome. A WorkflowRun represents a single execution of a workflow against a file.

        Parameters
        ----------
        status : typing.Optional[WorkflowStatus]
            Filters workflow runs by their status. If not provided, no filter is applied.

             The status of a workflow run:
             * `"PENDING"` - The workflow run has not started yet
             * `"PROCESSING"` - The workflow run is in progress
             * `"NEEDS_REVIEW"` - The workflow run requires manual review
             * `"REJECTED"` - The workflow run was rejected during manual review
             * `"PROCESSED"` - The workflow run completed successfully
             * `"FAILED"` - The workflow run encountered an error
             * `"CANCELLED"` - The workflow run was cancelled
             * `"CANCELLING"` - The workflow run is being cancelled

        workflow_id : typing.Optional[str]
            Filters workflow runs by the workflow ID. If not provided, runs for all workflows are returned.

            Example: `"workflow_BMdfq_yWM3sT-ZzvCnA3f"`

        batch_id : typing.Optional[str]
            Filters workflow runs by the batch ID. This is useful for fetching all runs for a given batch created via the [Batch Run Workflow](/developers/api-reference/workflow-endpoints/batch-run-workflow) endpoint.

            Example: `"batch_7Ws31-F5"`

        file_name_contains : typing.Optional[str]
            Filters workflow runs by the name of the file. Only returns workflow runs where the file name contains this string.

            Example: `"invoice"`

        sort_by : typing.Optional[SortByEnum]
            Sorts the workflow runs by the given field.

        sort_dir : typing.Optional[SortDirEnum]
            Sorts the workflow runs in ascending or descending order. Ascending order means the earliest workflow run is returned first.

        next_page_token : typing.Optional[NextPageToken]

        max_page_size : typing.Optional[MaxPageSize]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowRunListResponse
            You will get a list of summaries for each workflow run. These are shortened versions of the full WorkflowRun object.

            To get the full object, use the [Get WorkflowRun](/developers/api-reference/workflow-endpoints/get-workflow-run) endpoint.

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.workflow_run.list(status="PENDING", workflow_id='workflowId', batch_id='batchId', file_name_contains='fileNameContains', sort_by="updatedAt", sort_dir="asc", next_page_token='xK9mLPqRtN3vS8wF5hB2cQ==:zWvUxYjM4nKpL7aDgE9HbTcR2mAyX3/Q+CNkfBSw1dZ=', max_page_size=1, )
        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            status=status,
            workflow_id=workflow_id,
            batch_id=batch_id,
            file_name_contains=file_name_contains,
            sort_by=sort_by,
            sort_dir=sort_dir,
            next_page_token=next_page_token,
            max_page_size=max_page_size,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        workflow_id: str,
        files: typing.Optional[typing.Sequence[WorkflowRunFileInput]] = OMIT,
        raw_texts: typing.Optional[typing.Sequence[str]] = OMIT,
        version: typing.Optional[str] = OMIT,
        priority: typing.Optional[int] = OMIT,
        metadata: typing.Optional[JsonObject] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowRunCreateResponse:
        """
        Run a Workflow with files. A Workflow is a sequence of steps that process files and data in a specific order to achieve a desired outcome. A WorkflowRun will be created for each file processed. A WorkflowRun represents a single execution of a workflow against a file.

        Parameters
        ----------
        workflow_id : str
            The ID of the workflow to run.

            Example: `"workflow_BMdfq_yWM3sT-ZzvCnA3f"`

        files : typing.Optional[typing.Sequence[WorkflowRunFileInput]]
            An array of files to process through the workflow. Either the `files` array or `rawTexts` array must be provided. Supported file types can be found [here](/product/general/supported-file-types). There is a limit if 50 files that can be processed at once using this endpoint. If you wish to process more at a time, consider using the [Batch Run Workflow](/developers/api-reference/workflow-endpoints/batch-run-workflow) endpoint.

        raw_texts : typing.Optional[typing.Sequence[str]]
            An array of raw strings. Can be used in place of files when passing raw data. The raw data will be converted to `.txt` files and run through the workflow. If the data follows a specific format, it is recommended to use the files parameter instead. Either `files` or `rawTexts` must be provided.

        version : typing.Optional[str]
            An optional version of the workflow that files will be run through. This number can be found when viewing the workflow on the Extend platform. When a version number is not supplied, the most recent published version of the workflow will be used. If no published versions exist, the draft version will be used. To run the `"draft"` version of a workflow, use `"draft"` as the version.

            Examples:
            - `"3"` - Run version 3 of the workflow
            - `"draft"` - Run the draft version of the workflow

        priority : typing.Optional[int]
            An optional value used to determine the relative order of WorkflowRuns when rate limiting is in effect. Lower values will be prioritized before higher values.

        metadata : typing.Optional[JsonObject]
            A optional metadata object that can be assigned to a specific WorkflowRun to help identify it. It will be returned in the response and webhooks. You can place any arbitrary `key : value` pairs in this object.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowRunCreateResponse
            Successfully created workflow runs

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.workflow_run.create(workflow_id='workflow_id_here', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            workflow_id=workflow_id,
            files=files,
            raw_texts=raw_texts,
            version=version,
            priority=priority,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, workflow_run_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowRunGetResponse:
        """
        Once a workflow has been run, you can check the status and output of a specific WorkflowRun.

        Parameters
        ----------
        workflow_run_id : str
            The ID of the WorkflowRun that was outputted after a Workflow was run through the API.

            Example: `"workflow_run_8k9m-xyzAB_Pqrst-Nvw4"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowRunGetResponse
            Successfully retrieved workflow run

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.workflow_run.get(workflow_run_id='workflow_run_id_here', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(workflow_run_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        workflow_run_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        metadata: typing.Optional[JsonObject] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowRunUpdateResponse:
        """
        You can update the name and metadata of an in progress WorkflowRun at any time using this endpoint.

        Parameters
        ----------
        workflow_run_id : str
            The ID of the WorkflowRun. This ID will start with "workflow_run". This ID can be found in the API response when creating a Workflow Run, or in the "history" tab of a workflow on the Extend platform.

            Example: `"workflow_run_8k9m-xyzAB_Pqrst-Nvw4"`

        name : typing.Optional[str]
            An optional name that can be assigned to a specific WorkflowRun

        metadata : typing.Optional[JsonObject]
            A metadata object that can be assigned to a specific WorkflowRun. If metadata already exists on this WorkflowRun, the newly incoming metadata will be merged with the existing metadata, with the incoming metadata taking field precedence.

            You can include any arbitrary `key : value` pairs in this object.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowRunUpdateResponse
            Successfully updated workflow run

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.workflow_run.update(workflow_run_id='workflow_run_id_here', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            workflow_run_id, name=name, metadata=metadata, request_options=request_options
        )
        return _response.data

    async def delete(
        self, workflow_run_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowRunDeleteResponse:
        """
        Delete a workflow run and all associated data from Extend. This operation is permanent and cannot be undone.

        This endpoint can be used if you'd like to manage data retention on your own rather than automated data retention policies. Or make one-off deletions for your downstream customers.

        Parameters
        ----------
        workflow_run_id : str
            The ID of the workflow run to delete.

            Example: `"workflow_run_xKm9pNv3qWsY_jL2tR5Dh"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowRunDeleteResponse
            Successfully deleted workflow run

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.workflow_run.delete(workflow_run_id='workflow_run_id_here', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete(workflow_run_id, request_options=request_options)
        return _response.data

    async def cancel(
        self, workflow_run_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowRunCancelResponse:
        """
        Cancel a running workflow run by its ID. This endpoint allows you to stop a workflow run that is currently in progress.

        Note: Only workflow runs with a status of `PROCESSING` or `PENDING` can be cancelled. Workflow runs that are completed, failed, in review, rejected, or already cancelled cannot be cancelled.

        Parameters
        ----------
        workflow_run_id : str
            The ID of the workflow run to cancel.

            Example: `"workflow_run_xKm9pNv3qWsY_jL2tR5Dh"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowRunCancelResponse
            Successfully cancelled workflow run

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.workflow_run.cancel(workflow_run_id='workflow_run_id_here', )
        asyncio.run(main())
        """
        _response = await self._raw_client.cancel(workflow_run_id, request_options=request_options)
        return _response.data
