# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.provided_processor_output import ProvidedProcessorOutput
from .raw_client import AsyncRawWorkflowRunOutputClient, RawWorkflowRunOutputClient
from .types.workflow_run_output_update_response import WorkflowRunOutputUpdateResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WorkflowRunOutputClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWorkflowRunOutputClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWorkflowRunOutputClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWorkflowRunOutputClient
        """
        return self._raw_client

    def update(
        self,
        workflow_run_id: str,
        output_id: str,
        *,
        reviewed_output: ProvidedProcessorOutput,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowRunOutputUpdateResponse:
        """
        Use this endpoint to submit corrected outputs for a WorkflowRun for future processor evaluation and tuning in Extend.

        If you are using our Human-in-the-loop workflow review, then we already will be collecting your operator submitted corrections. However, if you are receiving data via the API without human review, there could be incorrect outputs that you would like to correct for future usage in evaluation and tuning within the Extend platform. This endpoint allows you to submit corrected outputs for a WorkflowRun, by providing the correct output for a given output ID.

        The output ID, would be found in a given entry within the outputs arrays of a Workflow Run payload. The ID would look something like `dpr_gwkZZNRrPgkjcq0y-***`.

        Parameters
        ----------
        workflow_run_id : str

        output_id : str

        reviewed_output : ProvidedProcessorOutput
            The corrected output of the processor when run against the file.

            This should conform to the output type schema of the given processor.

            If this is an extraction result, you can include all fields, or just the ones that were corrected, our system will handle merges/dedupes. However, if you do include a field, we assume the value included in the final reviewed value.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowRunOutputUpdateResponse
            Successfully corrected workflow run output

        Examples
        --------
        from extend_ai import Extend
        from extend_ai import ProvidedJsonOutput
        client = Extend(token="YOUR_TOKEN", )
        client.workflow_run_output.update(workflow_run_id='workflow_run_id_here', output_id='output_id_here', reviewed_output=ProvidedJsonOutput(value={'key': 'value'
        }, ), )
        """
        _response = self._raw_client.update(
            workflow_run_id, output_id, reviewed_output=reviewed_output, request_options=request_options
        )
        return _response.data


class AsyncWorkflowRunOutputClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWorkflowRunOutputClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWorkflowRunOutputClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWorkflowRunOutputClient
        """
        return self._raw_client

    async def update(
        self,
        workflow_run_id: str,
        output_id: str,
        *,
        reviewed_output: ProvidedProcessorOutput,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowRunOutputUpdateResponse:
        """
        Use this endpoint to submit corrected outputs for a WorkflowRun for future processor evaluation and tuning in Extend.

        If you are using our Human-in-the-loop workflow review, then we already will be collecting your operator submitted corrections. However, if you are receiving data via the API without human review, there could be incorrect outputs that you would like to correct for future usage in evaluation and tuning within the Extend platform. This endpoint allows you to submit corrected outputs for a WorkflowRun, by providing the correct output for a given output ID.

        The output ID, would be found in a given entry within the outputs arrays of a Workflow Run payload. The ID would look something like `dpr_gwkZZNRrPgkjcq0y-***`.

        Parameters
        ----------
        workflow_run_id : str

        output_id : str

        reviewed_output : ProvidedProcessorOutput
            The corrected output of the processor when run against the file.

            This should conform to the output type schema of the given processor.

            If this is an extraction result, you can include all fields, or just the ones that were corrected, our system will handle merges/dedupes. However, if you do include a field, we assume the value included in the final reviewed value.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowRunOutputUpdateResponse
            Successfully corrected workflow run output

        Examples
        --------
        from extend_ai import AsyncExtend
        from extend_ai import ProvidedJsonOutput
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.workflow_run_output.update(workflow_run_id='workflow_run_id_here', output_id='output_id_here', reviewed_output=ProvidedJsonOutput(value={'key': 'value'
            }, ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            workflow_run_id, output_id, reviewed_output=reviewed_output, request_options=request_options
        )
        return _response.data
