from __future__ import absolute_import

from datetime import date, datetime  # noqa: F401
from typing import List

from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib import util
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.base_model_ import Model
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.edge_cloud_zone import (
    EdgeCloudZone,
)


class DeployApp(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, app_id: str, app_zones: List[EdgeCloudZone]):  # noqa: E501
        """EdgeCloudZone - a model defined in Swagger

        :param appId: The appId of this DeployApp.  # noqa: E501
        :type appId: Deploy App Id
        :param edge_cloud_zone_name: The edge_cloud_zone_name of this EdgeCloudZone.  # noqa: E501
        :type edge_cloud_zone_name: EdgeCloudZoneName

        """
        self.swagger_types = {"app_id": str, "app_zones": List}

        self.attribute_map = {"app_id": "appId", "app_zones": "appZones"}
        self._app_id = app_id
        self._app_zones = app_zones

    @classmethod
    def from_dict(cls, dikt) -> "DeployApp":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The EdgeCloudZone of this EdgeCloudZone.  # noqa: E501
        :rtype: EdgeCloudZone
        """
        return util.deserialize_model(dikt, cls)

    @property
    def app_id(self) -> str:
        """Gets the edge_cloud_zone_id of this EdgeCloudZone.


        :return: The edge_cloud_zone_id of this EdgeCloudZone.
        :rtype: EdgeCloudZoneId
        """
        return self._app_id

    @app_id.setter
    def app_id(self, app_id: str):
        """Sets the edge_cloud_zone_id of this EdgeCloudZone.


        :param edge_cloud_zone_id: The edge_cloud_zone_id of this EdgeCloudZone.
        :type edge_cloud_zone_id: EdgeCloudZoneId
        """

        self._app_id = app_id

    @property
    def app_zones(self) -> List[EdgeCloudZone]:
        """Gets the edge_cloud_zone_name of this EdgeCloudZone.


        :return: The edge_cloud_zone_name of this EdgeCloudZone.
        :rtype: EdgeCloudZoneName
        """
        return self._app_zones

    @app_zones.setter
    def app_zones(self, app_zones: List[EdgeCloudZone]):
        """Sets the edge_cloud_zone_name of this EdgeCloudZone.


        :param edge_cloud_zone_name: The edge_cloud_zone_name of this EdgeCloudZone.
        :type edge_cloud_zone_name: EdgeCloudZoneName
        """

        self._app_zones = app_zones
