#  ██████   ██████  ███           █████                        ████
# ░░██████ ██████  ░░░           ░░███                        ░░███
#  ░███░█████░███  ████   █████  ███████   ████████   ██████   ░███
#  ░███░░███ ░███ ░░███  ███░░  ░░░███░   ░░███░░███ ░░░░░███  ░███
#  ░███ ░░░  ░███  ░███ ░░█████   ░███     ░███ ░░░   ███████  ░███
#  ░███      ░███  ░███  ░░░░███  ░███ ███ ░███      ███░░███  ░███
#  █████     █████ █████ ██████   ░░█████  █████    ░░████████ █████
# ░░░░░     ░░░░░ ░░░░░ ░░░░░░     ░░░░░  ░░░░░      ░░░░░░░░ ░░░░░
MISTRAL_MODELS = {
    "mistral-medium": {
        "id": "mistral-medium",
        "name": "mistral-medium-latest",
        "api_base": "https://api.mistral.ai/v1",
        "api_key_env_var": "MISTRAL_API_KEY",
        "supports_json": True,
        "api_spec": "mistral",
        "input_cost": 0.4,
        "output_cost": 2.0,
    },
    "mistral-large": {
        "id": "mistral-large",
        "name": "mistral-large-latest",
        "api_base": "https://api.mistral.ai/v1",
        "api_key_env_var": "MISTRAL_API_KEY",
        "supports_json": True,
        "api_spec": "mistral",
        "input_cost": 2.0,
        "output_cost": 6.0,
    },
    "pixtral-large": {
        "id": "pixtral-large",
        "name": "pixtral-large-latest",
        "api_base": "https://api.mistral.ai/v1",
        "api_key_env_var": "MISTRAL_API_KEY",
        "supports_json": True,
        "api_spec": "mistral",
        "input_cost": 2.0,
        "output_cost": 6.0,
    },
    "mistral-small": {
        "id": "mistral-small",
        "name": "mistral-small-latest",
        "api_base": "https://api.mistral.ai/v1",
        "api_key_env_var": "MISTRAL_API_KEY",
        "supports_json": True,
        "api_spec": "mistral",
        "input_cost": 0.1,
        "output_cost": 0.3,
    },
    "devstral-small": {
        "id": "devstral-small",
        "name": "devstral-small-2505",
        "api_base": "https://api.mistral.ai/v1",
        "api_key_env_var": "MISTRAL_API_KEY",
        "supports_json": True,
        "api_spec": "mistral",
        "input_cost": 0.1,
        "output_cost": 0.3,
    },
    "codestral": {
        "id": "codestral",
        "name": "codestral-latest",
        "api_base": "https://api.mistral.ai/v1",
        "api_key_env_var": "MISTRAL_API_KEY",
        "supports_json": True,
        "api_spec": "mistral",
        "input_cost": 0.2,
        "output_cost": 0.6,
    },
    "pixtral-12b": {
        "id": "pixtral-12b",
        "name": "pixtral-12b",
        "api_base": "https://api.mistral.ai/v1",
        "api_key_env_var": "MISTRAL_API_KEY",
        "supports_json": True,
        "api_spec": "mistral",
        "input_cost": 0.1,
        "output_cost": 0.3,
    },
    "mistral-nemo": {
        "id": "mistral-nemo",
        "name": "open-mistral-nemo",
        "api_base": "https://api.mistral.ai/v1",
        "api_key_env_var": "MISTRAL_API_KEY",
        "supports_json": True,
        "api_spec": "mistral",
        "input_cost": 0.1,
        "output_cost": 0.3,
    },
    "ministral-8b": {
        "id": "ministral-8b",
        "name": "ministral-8b-latest",
        "api_base": "https://api.mistral.ai/v1",
        "api_key_env_var": "MISTRAL_API_KEY",
        "supports_json": True,
        "api_spec": "mistral",
        "input_cost": 0.7,
        "output_cost": 0.7,
    },
    "mixtral-8x22b": {
        "id": "mixtral-8x22b",
        "name": "open-mixtral-8x22b",
        "api_base": "https://api.mistral.ai/v1",
        "api_key_env_var": "MISTRAL_API_KEY",
        "supports_json": True,
        "api_spec": "mistral",
        "input_cost": 2.0,
        "output_cost": 6.0,
    },
}
