"""Provides plugin functionality for adding sampler plugins.

Samplers are used by the optimization process to generate perturbed variable
vectors. This module allows for the extension of `ropt` with custom samplers.

**Core Concepts:**

* **Plugin Interface:** Sampler plugins must inherit from the
  [`SamplerPlugin`][ropt.plugins.sampler.base.SamplerPlugin] base class.
  This class acts as a factory, defining a `create` method to instantiate
  sampler objects.
* **Sampler Implementation:** The actual sampling logic resides in classes
  that inherit from the [`Sampler`][ropt.plugins.sampler.base.Sampler]
  abstract base class. These classes are initialized with the optimization
  configuration ([`EnOptConfig`][ropt.config.enopt.EnOptConfig]), the index
  of the specific sampler configuration to use (`sampler_index`), an optional
  variable mask (`mask`), and a random number generator (`rng`). Samples are
  generated by calling the sampler's `generate_samples` method.
* **Discovery:** The [`PluginManager`][ropt.plugins.PluginManager] discovers
  available `SamplerPlugin` implementations (typically via entry points) and
  uses them to create `Sampler` instances as needed during plan execution.

**Built-in Sampler Plugins:**

By default, the [`SciPySampler`][ropt.plugins.sampler.scipy.SciPySampler] sampler
is installed, which provides several sampling methods based on the `scipy.stats`
and `scipy.stats.qmc` packages.
"""
