from adam.commands.command import Command
from adam.repl_state import ReplState
from adam.utils import log
from adam.utils_net import get_my_host

class ShowHost(Command):
    COMMAND = 'show host'

    # the singleton pattern
    def __new__(cls, *args, **kwargs):
        if not hasattr(cls, 'instance'): cls.instance = super(ShowHost, cls).__new__(cls)

        return cls.instance

    def __init__(self, successor: Command=None):
        super().__init__(successor)

    def command(self):
        return ShowHost.COMMAND

    def run(self, cmd: str, state: ReplState):
        if not(args := self.args(cmd)):
            return super().run(cmd, state)

        log(get_my_host())

        return state

    def completion(self, state: ReplState):
        return super().completion(state)

    def help(self, _: ReplState):
        return f'{ShowHost.COMMAND}\t show host'