"""
Deep Research Examples - Progressive Tutorial Series

This directory contains numbered examples that teach you how to use
the deep research system, following KayGraph best practices.

## Learning Path

1. **01_basic_research.py** - Start here
   - Simple research workflow
   - Core concepts: nodes, graphs, shared state
   - How to run a basic query

2. **02_multi_aspect_research.py** - Comprehensive coverage
   - Multi-aspect workflow
   - Aspect prioritization
   - Agent allocation
   - Cross-aspect synthesis

3. **03_comparative_analysis.py** - Side-by-side comparison
   - Comparative workflow
   - Entity extraction
   - Comparison matrix
   - Winner selection

4. **04_web_search_integration.py** - Real APIs
   - Brave Search API
   - Brave AI Grounding
   - Jina AI Search
   - Production-ready search

5. **05_interactive_clarification.py** - Human-in-the-loop
   - HITL pattern
   - Clarifying questions
   - User interaction
   - Query refinement

6. **06_workflow_composition.py** - Advanced architecture
   - Node reusability
   - Workflow composition
   - Building custom workflows
   - The KayGraph way

## For AI Agents Learning This

Each example is designed to teach ONE concept clearly:
- Copy-paste ready code
- Extensive comments explaining "why"
- Progressive complexity
- Reusable patterns

Study in order: 01 → 02 → 03 → 04 → 05 → 06

Then build your own workbooks following these patterns!
"""

__all__ = [
    # Examples are imported individually, not as a module
]
