# KayGraph Workbooks Index

Complete index of all **71 implemented workbooks** organized by category and difficulty level.

## 🎯 Quick Start Learning Paths

### Fundamentals Path (2-3 hours)
**For beginners new to KayGraph**
1. **kaygraph-hello-world** → Your first nodes and graph
2. **kaygraph-workflow** → Multi-node workflows  
3. **kaygraph-batch** → Processing lists of items
4. **kaygraph-async-basics** → Async programming concepts

### AI Applications Path (4-5 hours)
**For developers building AI apps**
1. **kaygraph-chat** → Basic LLM integration
2. **kaygraph-thinking** → Chain-of-thought reasoning
3. **kaygraph-agent** → Autonomous agents with tools
4. **kaygraph-rag** → Retrieval-augmented generation
5. **kaygraph-multi-agent** → Coordinating multiple agents

### Production Systems Path (6-8 hours)
**For engineers deploying to production**
1. **kaygraph-fault-tolerant-workflow** → Error handling patterns
2. **kaygraph-validated-pipeline** → Input/output validation
3. **kaygraph-production-ready-api** → FastAPI integration
4. **kaygraph-realtime-monitoring** → Observability and metrics
5. **kaygraph-distributed-tracing** → OpenTelemetry integration

## 📚 All 71 Workbooks by Category

### Core Foundations (11 workbooks)
**Essential concepts and basic patterns**

| Workbook | Difficulty | Description |
|----------|------------|-------------|
| kaygraph-hello-world | Beginner | Simplest KayGraph application with basic nodes |
| kaygraph-workflow | Intermediate | Multi-stage content creation pipeline |
| kaygraph-workflow-basic | Beginner | Basic workflow patterns and task orchestration |
| kaygraph-batch | Intermediate | Sequential batch processing with progress tracking |
| kaygraph-batch-node | Intermediate | Core BatchNode functionality patterns |
| kaygraph-batch-flow | Intermediate | Multiple batch nodes in sequence |
| kaygraph-parallel-batch | Advanced | High-performance parallel processing with metrics |
| kaygraph-nested-batch | Advanced | Hierarchical batch processing (School→Class→Student) |
| kaygraph-async-basics | Intermediate | Comprehensive async tutorial with examples |
| kaygraph-distributed-mapreduce | Expert | Large-scale distributed processing framework |
| kaygraph-basic-communication | Intermediate | Node communication patterns |

### AI & Agent Systems (15 workbooks)
**LLM integration and autonomous agents**

| Workbook | Difficulty | Description |
|----------|------------|-------------|
| kaygraph-agent | Advanced | Autonomous research agent with web search |
| kaygraph-agent-control | Advanced | Agent control patterns and state management |
| kaygraph-agent-feedback | Advanced | Feedback loops in agent systems |
| kaygraph-agent-intelligence | Advanced | Intelligence patterns for autonomous agents |
| kaygraph-agent-memory | Advanced | Memory-enabled agents with persistent context |
| kaygraph-agent-recovery | Advanced | Error recovery and resilience patterns |
| kaygraph-agent-tools | Advanced | Tool integration for agent capabilities |
| kaygraph-agent-validation | Advanced | Validation patterns for agent outputs |
| kaygraph-multi-agent | Expert | Coordinated multi-agent system with supervisor |
| kaygraph-thinking | Advanced | Chain-of-thought reasoning with self-evaluation |
| kaygraph-think-act-reflect | Advanced | TAR cognitive architecture implementation |
| kaygraph-reasoning | Advanced | Multiple reasoning strategies with confidence |
| kaygraph-a2a-communication | Advanced | Agent-to-agent communication protocols |
| kaygraph-task-engineer | Expert | Advanced task engineering and analysis |
| kaygraph-code-generator | Expert | AI-powered code generation with validation |

### Chat & Conversation (4 workbooks)
**Interactive chat applications**

| Workbook | Difficulty | Description |
|----------|------------|-------------|
| kaygraph-chat | Intermediate | Interactive chatbot with conversation history |
| kaygraph-chat-memory | Advanced | Persistent chat with user profiles |
| kaygraph-chat-guardrail | Advanced | Safe AI chat with content filtering |
| kaygraph-voice-chat | Expert | Voice-enabled chat interface |

### Memory Systems (3 workbooks)
**Persistent and collaborative memory**

| Workbook | Difficulty | Description |
|----------|------------|-------------|
| kaygraph-memory-persistent | Advanced | Long-term memory across sessions with SQLite |
| kaygraph-memory-contextual | Advanced | Context-aware memory with temporal relationships |
| kaygraph-memory-collaborative | Advanced | Shared team memory with permissions (25KB implementation) |

### Workflow Patterns (9 workbooks)
**Advanced workflow orchestration**

| Workbook | Difficulty | Description |
|----------|------------|-------------|
| kaygraph-workflow-structured | Advanced | Type-safe data pipelines with validation |
| kaygraph-workflow-tools | Advanced | Advanced tool integration with parallel execution |
| kaygraph-workflow-retrieval | Advanced | RAG workflows with knowledge base |
| kaygraph-workflow-handoffs | Intermediate | Agent handoff patterns and transitions |
| kaygraph-workflow-orchestrator | Advanced | Complex workflow orchestration |
| kaygraph-workflow-parallelization | Advanced | Parallel workflow execution patterns |
| kaygraph-workflow-prompt-chaining | Intermediate | Chaining prompts across stages |
| kaygraph-workflow-routing | Advanced | Dynamic routing and branching |
| kaygraph-rag | Advanced | Complete RAG pipeline with indexing |

### Production & Monitoring (10 workbooks)
**Enterprise-grade patterns**

| Workbook | Difficulty | Description |
|----------|------------|-------------|
| kaygraph-production-ready-api | Expert | Enterprise FastAPI with circuit breakers (12KB) |
| kaygraph-fault-tolerant-workflow | Expert | Advanced error handling and resilience (14.5KB) |
| kaygraph-supervisor | Advanced | Managing unreliable workers with retry logic |
| kaygraph-validated-pipeline | Advanced | Strict input/output validation pipeline |
| kaygraph-metrics-dashboard | Advanced | Production metrics collection and display |
| kaygraph-realtime-monitoring | Expert | Live monitoring with WebSocket dashboard |
| kaygraph-distributed-tracing | Expert | OpenTelemetry with Jaeger integration (13KB) |
| kaygraph-resource-management | Advanced | Resource cleanup and management patterns |
| kaygraph-fastapi-background | Advanced | Background task processing with queues |
| kaygraph-fastapi-websocket | Advanced | WebSocket integration for real-time updates |

### Structured Data & Output (5 workbooks)
**Type-safe data handling**

| Workbook | Difficulty | Description |
|----------|------------|-------------|
| kaygraph-structured-output | Intermediate | Extract structured data from text |
| kaygraph-structured-output-advanced | Advanced | Production structured generation (17KB) |
| kaygraph-streaming-llm | Advanced | Real-time LLM streaming with validation |
| kaygraph-majority-vote | Advanced | Multi-LLM consensus mechanisms |
| kaygraph-text2sql | Advanced | Natural language to SQL conversion |

### Tool Integrations (5 workbooks)
**External service integrations**

| Workbook | Difficulty | Description |
|----------|------------|-------------|
| kaygraph-tool-search | Intermediate | Web search integration |
| kaygraph-tool-database | Intermediate | Database operations |
| kaygraph-tool-crawler | Advanced | Web scraping and content analysis |
| kaygraph-tool-embeddings | Intermediate | Vector operations and semantic search |
| kaygraph-tool-pdf-vision | Advanced | PDF processing with vision |

### UI & Visualization (4 workbooks)
**User interfaces and debugging**

| Workbook | Difficulty | Description |
|----------|------------|-------------|
| kaygraph-gradio | Intermediate | Interactive AI interfaces |
| kaygraph-streamlit-fsm | Advanced | Finite state machines with Streamlit |
| kaygraph-visualization | Intermediate | Graph debugging and visualization |
| kaygraph-human-in-the-loop | Advanced | Human approval workflows |

### External Integrations (4 workbooks)
**Third-party service connections**

| Workbook | Difficulty | Description |
|----------|------------|-------------|
| kaygraph-google-calendar | Advanced | Google Calendar API integration |
| kaygraph-sql-scheduler | Advanced | Database workflow scheduling |
| kaygraph-mcp | Expert | Model Context Protocol integration |
| kaygraph-web-search | Advanced | Multi-provider web search (12KB) |

## 📊 Implementation Statistics

### File Size Analysis (Main Implementations)
- **Largest**: kaygraph-memory-collaborative (25,167 bytes)
- **Average**: ~11KB per workbook
- **Smallest**: kaygraph-hello-world (2,045 bytes)

### Documentation Coverage
- **All 70 workbooks** have README.md files
- **Average README size**: 4.3KB
- **All include**: Installation, examples, architecture

### Difficulty Distribution
- **Beginner** (2 workbooks): Basic concepts, minimal prerequisites
- **Intermediate** (17 workbooks): Requires KayGraph fundamentals
- **Advanced** (43 workbooks): Complex patterns, production features
- **Expert** (8 workbooks): Enterprise patterns, distributed systems

## 🚀 Quick Start Commands

```bash
# Install KayGraph
pip install kaygraph

# Clone workbooks
git clone https://github.com/kaygraph/kaygraph
cd kaygraph/workbooks

# Run your first workbook
cd kaygraph-hello-world
python main.py

# For AI workbooks with Ollama (recommended for local development)
# Install Ollama from https://ollama.ai
ollama pull llama3.2:3b
cd kaygraph-chat
python main.py
```

## 📖 Common Structure

Each workbook follows a consistent structure:
- **README.md** - Overview, features, examples
- **main.py** - Entry point with runnable examples (avg 11KB)
- **nodes.py** - Node implementations (when separated)
- **models.py** - Data models (for complex workbooks)
- **utils/** - Helper functions (call_llm.py, etc.)
- **requirements.txt** - Dependencies (usually just kaygraph)

## 🔧 LLM Configuration

Most AI workbooks support Ollama with OpenAI-compatible endpoints:
```python
# In utils/call_llm.py
url = "http://localhost:11434/v1/chat/completions"
model = "llama3.2:3b"
```

Alternative providers can be configured by modifying `utils/call_llm.py`.

## 🎯 Learning Recommendations

### For Beginners
1. Start with **kaygraph-hello-world** to understand nodes
2. Move to **kaygraph-workflow** for multi-node patterns
3. Try **kaygraph-batch** for data processing
4. Explore **kaygraph-chat** for LLM integration

### For AI Developers
1. Study **kaygraph-agent** for autonomous systems
2. Explore **kaygraph-rag** for retrieval patterns
3. Try **kaygraph-multi-agent** for complex coordination
4. Examine memory workbooks for persistence

### For Production Engineers
1. Master **kaygraph-fault-tolerant-workflow** for resilience
2. Implement **kaygraph-production-ready-api** for APIs
3. Use **kaygraph-distributed-tracing** for observability
4. Apply **kaygraph-validated-pipeline** for data quality

## 🛠️ Key Capabilities Demonstrated

### Core Patterns
- Node lifecycle (prep, exec, post)
- Graph construction and routing
- Shared state management
- Action-based conditional execution

### Advanced Features
- Async/await patterns (AsyncNode, AsyncGraph)
- Parallel batch processing (ParallelBatchNode)
- Circuit breakers and fault tolerance
- Distributed tracing with OpenTelemetry
- Real-time monitoring and metrics
- Multi-agent coordination
- Memory persistence and retrieval

### Production Patterns
- Request validation and sanitization
- Health checks and readiness probes
- Graceful degradation strategies
- Resource cleanup and management
- Background task processing
- WebSocket real-time updates

## 📝 Notes

- All workbooks are tested with Python 3.8+
- Most support Ollama for local LLM development
- No external API keys required for basic functionality
- Production workbooks include enterprise patterns
- Average implementation size of 11KB indicates substantial, working code
- Documentation averages 4KB per workbook

---

Happy building with KayGraph! 🚀