from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.get_job_response_200_type_0_raw_flow_failure_module import GetJobResponse200Type0RawFlowFailureModule
    from ..models.get_job_response_200_type_0_raw_flow_flow_env import GetJobResponse200Type0RawFlowFlowEnv
    from ..models.get_job_response_200_type_0_raw_flow_modules_item import GetJobResponse200Type0RawFlowModulesItem
    from ..models.get_job_response_200_type_0_raw_flow_notes_item import GetJobResponse200Type0RawFlowNotesItem
    from ..models.get_job_response_200_type_0_raw_flow_preprocessor_module import (
        GetJobResponse200Type0RawFlowPreprocessorModule,
    )


T = TypeVar("T", bound="GetJobResponse200Type0RawFlow")


@_attrs_define
class GetJobResponse200Type0RawFlow:
    """
    Attributes:
        modules (List['GetJobResponse200Type0RawFlowModulesItem']):
        failure_module (Union[Unset, GetJobResponse200Type0RawFlowFailureModule]):
        preprocessor_module (Union[Unset, GetJobResponse200Type0RawFlowPreprocessorModule]):
        same_worker (Union[Unset, bool]):
        concurrent_limit (Union[Unset, float]):
        concurrency_key (Union[Unset, str]):
        concurrency_time_window_s (Union[Unset, float]):
        debounce_delay_s (Union[Unset, float]):
        debounce_key (Union[Unset, str]):
        skip_expr (Union[Unset, str]):
        cache_ttl (Union[Unset, float]):
        flow_env (Union[Unset, GetJobResponse200Type0RawFlowFlowEnv]):
        priority (Union[Unset, float]):
        early_return (Union[Unset, str]):
        chat_input_enabled (Union[Unset, bool]): Whether this flow accepts chat-style input
        notes (Union[Unset, List['GetJobResponse200Type0RawFlowNotesItem']]): Sticky notes attached to the flow
    """

    modules: List["GetJobResponse200Type0RawFlowModulesItem"]
    failure_module: Union[Unset, "GetJobResponse200Type0RawFlowFailureModule"] = UNSET
    preprocessor_module: Union[Unset, "GetJobResponse200Type0RawFlowPreprocessorModule"] = UNSET
    same_worker: Union[Unset, bool] = UNSET
    concurrent_limit: Union[Unset, float] = UNSET
    concurrency_key: Union[Unset, str] = UNSET
    concurrency_time_window_s: Union[Unset, float] = UNSET
    debounce_delay_s: Union[Unset, float] = UNSET
    debounce_key: Union[Unset, str] = UNSET
    skip_expr: Union[Unset, str] = UNSET
    cache_ttl: Union[Unset, float] = UNSET
    flow_env: Union[Unset, "GetJobResponse200Type0RawFlowFlowEnv"] = UNSET
    priority: Union[Unset, float] = UNSET
    early_return: Union[Unset, str] = UNSET
    chat_input_enabled: Union[Unset, bool] = UNSET
    notes: Union[Unset, List["GetJobResponse200Type0RawFlowNotesItem"]] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        modules = []
        for modules_item_data in self.modules:
            modules_item = modules_item_data.to_dict()

            modules.append(modules_item)

        failure_module: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.failure_module, Unset):
            failure_module = self.failure_module.to_dict()

        preprocessor_module: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.preprocessor_module, Unset):
            preprocessor_module = self.preprocessor_module.to_dict()

        same_worker = self.same_worker
        concurrent_limit = self.concurrent_limit
        concurrency_key = self.concurrency_key
        concurrency_time_window_s = self.concurrency_time_window_s
        debounce_delay_s = self.debounce_delay_s
        debounce_key = self.debounce_key
        skip_expr = self.skip_expr
        cache_ttl = self.cache_ttl
        flow_env: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.flow_env, Unset):
            flow_env = self.flow_env.to_dict()

        priority = self.priority
        early_return = self.early_return
        chat_input_enabled = self.chat_input_enabled
        notes: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.notes, Unset):
            notes = []
            for notes_item_data in self.notes:
                notes_item = notes_item_data.to_dict()

                notes.append(notes_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "modules": modules,
            }
        )
        if failure_module is not UNSET:
            field_dict["failure_module"] = failure_module
        if preprocessor_module is not UNSET:
            field_dict["preprocessor_module"] = preprocessor_module
        if same_worker is not UNSET:
            field_dict["same_worker"] = same_worker
        if concurrent_limit is not UNSET:
            field_dict["concurrent_limit"] = concurrent_limit
        if concurrency_key is not UNSET:
            field_dict["concurrency_key"] = concurrency_key
        if concurrency_time_window_s is not UNSET:
            field_dict["concurrency_time_window_s"] = concurrency_time_window_s
        if debounce_delay_s is not UNSET:
            field_dict["debounce_delay_s"] = debounce_delay_s
        if debounce_key is not UNSET:
            field_dict["debounce_key"] = debounce_key
        if skip_expr is not UNSET:
            field_dict["skip_expr"] = skip_expr
        if cache_ttl is not UNSET:
            field_dict["cache_ttl"] = cache_ttl
        if flow_env is not UNSET:
            field_dict["flow_env"] = flow_env
        if priority is not UNSET:
            field_dict["priority"] = priority
        if early_return is not UNSET:
            field_dict["early_return"] = early_return
        if chat_input_enabled is not UNSET:
            field_dict["chat_input_enabled"] = chat_input_enabled
        if notes is not UNSET:
            field_dict["notes"] = notes

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.get_job_response_200_type_0_raw_flow_failure_module import (
            GetJobResponse200Type0RawFlowFailureModule,
        )
        from ..models.get_job_response_200_type_0_raw_flow_flow_env import GetJobResponse200Type0RawFlowFlowEnv
        from ..models.get_job_response_200_type_0_raw_flow_modules_item import GetJobResponse200Type0RawFlowModulesItem
        from ..models.get_job_response_200_type_0_raw_flow_notes_item import GetJobResponse200Type0RawFlowNotesItem
        from ..models.get_job_response_200_type_0_raw_flow_preprocessor_module import (
            GetJobResponse200Type0RawFlowPreprocessorModule,
        )

        d = src_dict.copy()
        modules = []
        _modules = d.pop("modules")
        for modules_item_data in _modules:
            modules_item = GetJobResponse200Type0RawFlowModulesItem.from_dict(modules_item_data)

            modules.append(modules_item)

        _failure_module = d.pop("failure_module", UNSET)
        failure_module: Union[Unset, GetJobResponse200Type0RawFlowFailureModule]
        if isinstance(_failure_module, Unset):
            failure_module = UNSET
        else:
            failure_module = GetJobResponse200Type0RawFlowFailureModule.from_dict(_failure_module)

        _preprocessor_module = d.pop("preprocessor_module", UNSET)
        preprocessor_module: Union[Unset, GetJobResponse200Type0RawFlowPreprocessorModule]
        if isinstance(_preprocessor_module, Unset):
            preprocessor_module = UNSET
        else:
            preprocessor_module = GetJobResponse200Type0RawFlowPreprocessorModule.from_dict(_preprocessor_module)

        same_worker = d.pop("same_worker", UNSET)

        concurrent_limit = d.pop("concurrent_limit", UNSET)

        concurrency_key = d.pop("concurrency_key", UNSET)

        concurrency_time_window_s = d.pop("concurrency_time_window_s", UNSET)

        debounce_delay_s = d.pop("debounce_delay_s", UNSET)

        debounce_key = d.pop("debounce_key", UNSET)

        skip_expr = d.pop("skip_expr", UNSET)

        cache_ttl = d.pop("cache_ttl", UNSET)

        _flow_env = d.pop("flow_env", UNSET)
        flow_env: Union[Unset, GetJobResponse200Type0RawFlowFlowEnv]
        if isinstance(_flow_env, Unset):
            flow_env = UNSET
        else:
            flow_env = GetJobResponse200Type0RawFlowFlowEnv.from_dict(_flow_env)

        priority = d.pop("priority", UNSET)

        early_return = d.pop("early_return", UNSET)

        chat_input_enabled = d.pop("chat_input_enabled", UNSET)

        notes = []
        _notes = d.pop("notes", UNSET)
        for notes_item_data in _notes or []:
            notes_item = GetJobResponse200Type0RawFlowNotesItem.from_dict(notes_item_data)

            notes.append(notes_item)

        get_job_response_200_type_0_raw_flow = cls(
            modules=modules,
            failure_module=failure_module,
            preprocessor_module=preprocessor_module,
            same_worker=same_worker,
            concurrent_limit=concurrent_limit,
            concurrency_key=concurrency_key,
            concurrency_time_window_s=concurrency_time_window_s,
            debounce_delay_s=debounce_delay_s,
            debounce_key=debounce_key,
            skip_expr=skip_expr,
            cache_ttl=cache_ttl,
            flow_env=flow_env,
            priority=priority,
            early_return=early_return,
            chat_input_enabled=chat_input_enabled,
            notes=notes,
        )

        get_job_response_200_type_0_raw_flow.additional_properties = d
        return get_job_response_200_type_0_raw_flow

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
