/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseErrorHandler;
import android.database.SQLException;
import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteQuery;
import android.database.sqlite.SQLiteRawStatement;
import android.database.sqlite.SQLiteStatement;
import android.database.sqlite.SQLiteTransactionListener;
import android.os.CancellationSignal;
import android.util.Pair;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;

public final class SQLiteDatabase
extends SQLiteClosable {
    public static final int CONFLICT_ABORT = 2;
    public static final int CONFLICT_FAIL = 3;
    public static final int CONFLICT_IGNORE = 4;
    public static final int CONFLICT_NONE = 0;
    public static final int CONFLICT_REPLACE = 5;
    public static final int CONFLICT_ROLLBACK = 1;
    public static final int CREATE_IF_NECESSARY = 0x10000000;
    public static final int ENABLE_WRITE_AHEAD_LOGGING = 0x20000000;
    public static final String JOURNAL_MODE_DELETE = "DELETE";
    public static final String JOURNAL_MODE_MEMORY = "MEMORY";
    public static final String JOURNAL_MODE_OFF = "OFF";
    public static final String JOURNAL_MODE_PERSIST = "PERSIST";
    public static final String JOURNAL_MODE_TRUNCATE = "TRUNCATE";
    public static final String JOURNAL_MODE_WAL = "WAL";
    public static final int MAX_SQL_CACHE_SIZE = 100;
    public static final int NO_LOCALIZED_COLLATORS = 16;
    public static final int OPEN_READONLY = 1;
    public static final int OPEN_READWRITE = 0;
    public static final int SQLITE_MAX_LIKE_PATTERN_LENGTH = 50000;
    public static final String SYNC_MODE_EXTRA = "EXTRA";
    public static final String SYNC_MODE_FULL = "FULL";
    public static final String SYNC_MODE_NORMAL = "NORMAL";
    public static final String SYNC_MODE_OFF = "OFF";

    SQLiteDatabase() {
        throw new RuntimeException("Stub!");
    }

    protected void finalize() throws Throwable {
        throw new RuntimeException("Stub!");
    }

    @Override
    protected void onAllReferencesReleased() {
        throw new RuntimeException("Stub!");
    }

    public static int releaseMemory() {
        throw new RuntimeException("Stub!");
    }

    @Deprecated
    public void setLockingEnabled(boolean lockingEnabled) {
        throw new RuntimeException("Stub!");
    }

    public void beginTransaction() {
        throw new RuntimeException("Stub!");
    }

    public void beginTransactionNonExclusive() {
        throw new RuntimeException("Stub!");
    }

    public void beginTransactionReadOnly() {
        throw new RuntimeException("Stub!");
    }

    public void beginTransactionWithListener(@Nullable SQLiteTransactionListener transactionListener) {
        throw new RuntimeException("Stub!");
    }

    public void beginTransactionWithListenerNonExclusive(@Nullable SQLiteTransactionListener transactionListener) {
        throw new RuntimeException("Stub!");
    }

    public void beginTransactionWithListenerReadOnly(@Nullable SQLiteTransactionListener transactionListener) {
        throw new RuntimeException("Stub!");
    }

    public void endTransaction() {
        throw new RuntimeException("Stub!");
    }

    public void setTransactionSuccessful() {
        throw new RuntimeException("Stub!");
    }

    public boolean inTransaction() {
        throw new RuntimeException("Stub!");
    }

    public boolean isDbLockedByCurrentThread() {
        throw new RuntimeException("Stub!");
    }

    @Deprecated
    public boolean isDbLockedByOtherThreads() {
        throw new RuntimeException("Stub!");
    }

    @Deprecated
    public boolean yieldIfContended() {
        throw new RuntimeException("Stub!");
    }

    public boolean yieldIfContendedSafely() {
        throw new RuntimeException("Stub!");
    }

    public boolean yieldIfContendedSafely(long sleepAfterYieldDelay) {
        throw new RuntimeException("Stub!");
    }

    @Deprecated
    public Map<String, String> getSyncedTables() {
        throw new RuntimeException("Stub!");
    }

    public static SQLiteDatabase openDatabase(@NonNull String path, @Nullable CursorFactory factory, int flags) {
        throw new RuntimeException("Stub!");
    }

    public static SQLiteDatabase openDatabase(@NonNull File path, @NonNull OpenParams openParams) {
        throw new RuntimeException("Stub!");
    }

    public static SQLiteDatabase openDatabase(@NonNull String path, @Nullable CursorFactory factory, int flags, @Nullable DatabaseErrorHandler errorHandler) {
        throw new RuntimeException("Stub!");
    }

    public static SQLiteDatabase openOrCreateDatabase(@NonNull File file, @Nullable CursorFactory factory) {
        throw new RuntimeException("Stub!");
    }

    public static SQLiteDatabase openOrCreateDatabase(@NonNull String path, @Nullable CursorFactory factory) {
        throw new RuntimeException("Stub!");
    }

    public static SQLiteDatabase openOrCreateDatabase(@NonNull String path, @Nullable CursorFactory factory, @Nullable DatabaseErrorHandler errorHandler) {
        throw new RuntimeException("Stub!");
    }

    public static boolean deleteDatabase(@NonNull File file) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public static SQLiteDatabase create(@Nullable CursorFactory factory) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public static SQLiteDatabase createInMemory(@NonNull OpenParams openParams) {
        throw new RuntimeException("Stub!");
    }

    public void setCustomScalarFunction(@NonNull String functionName, @NonNull UnaryOperator<String> scalarFunction) throws SQLiteException {
        throw new RuntimeException("Stub!");
    }

    public void setCustomAggregateFunction(@NonNull String functionName, @NonNull BinaryOperator<String> aggregateFunction) throws SQLiteException {
        throw new RuntimeException("Stub!");
    }

    public void execPerConnectionSQL(@NonNull String sql, @Nullable Object[] bindArgs) throws SQLException {
        throw new RuntimeException("Stub!");
    }

    public int getVersion() {
        throw new RuntimeException("Stub!");
    }

    public void setVersion(int version) {
        throw new RuntimeException("Stub!");
    }

    public long getMaximumSize() {
        throw new RuntimeException("Stub!");
    }

    public long setMaximumSize(long numBytes) {
        throw new RuntimeException("Stub!");
    }

    public long getPageSize() {
        throw new RuntimeException("Stub!");
    }

    public void setPageSize(long numBytes) {
        throw new RuntimeException("Stub!");
    }

    @Deprecated
    public void markTableSyncable(String table, String deletedTable) {
        throw new RuntimeException("Stub!");
    }

    @Deprecated
    public void markTableSyncable(String table, String foreignKey, String updateTable) {
        throw new RuntimeException("Stub!");
    }

    public static String findEditTable(String tables) {
        throw new RuntimeException("Stub!");
    }

    public SQLiteStatement compileStatement(String sql) throws SQLException {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public Cursor query(boolean distinct, @NonNull String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public Cursor query(boolean distinct, @NonNull String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit, @Nullable CancellationSignal cancellationSignal) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public Cursor queryWithFactory(@Nullable CursorFactory cursorFactory, boolean distinct, @NonNull String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public Cursor queryWithFactory(@Nullable CursorFactory cursorFactory, boolean distinct, @NonNull String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit, @Nullable CancellationSignal cancellationSignal) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public Cursor query(@NonNull String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public Cursor query(@NonNull String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public Cursor rawQuery(@NonNull String sql, @Nullable String[] selectionArgs) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public Cursor rawQuery(@NonNull String sql, @Nullable String[] selectionArgs, @Nullable CancellationSignal cancellationSignal) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public Cursor rawQueryWithFactory(@Nullable CursorFactory cursorFactory, @NonNull String sql, @Nullable String[] selectionArgs, @NonNull String editTable) {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public Cursor rawQueryWithFactory(@Nullable CursorFactory cursorFactory, @NonNull String sql, @Nullable String[] selectionArgs, @NonNull String editTable, @Nullable CancellationSignal cancellationSignal) {
        throw new RuntimeException("Stub!");
    }

    public long insert(@NonNull String table, @Nullable String nullColumnHack, @Nullable ContentValues values) {
        throw new RuntimeException("Stub!");
    }

    public long insertOrThrow(@NonNull String table, @Nullable String nullColumnHack, @Nullable ContentValues values) throws SQLException {
        throw new RuntimeException("Stub!");
    }

    public long replace(@NonNull String table, @Nullable String nullColumnHack, @Nullable ContentValues initialValues) {
        throw new RuntimeException("Stub!");
    }

    public long replaceOrThrow(@NonNull String table, @Nullable String nullColumnHack, @Nullable ContentValues initialValues) throws SQLException {
        throw new RuntimeException("Stub!");
    }

    public long insertWithOnConflict(@NonNull String table, @Nullable String nullColumnHack, @Nullable ContentValues initialValues, int conflictAlgorithm) {
        throw new RuntimeException("Stub!");
    }

    public int delete(@NonNull String table, @Nullable String whereClause, @Nullable String[] whereArgs) {
        throw new RuntimeException("Stub!");
    }

    public int update(@NonNull String table, @Nullable ContentValues values, @Nullable String whereClause, @Nullable String[] whereArgs) {
        throw new RuntimeException("Stub!");
    }

    public int updateWithOnConflict(@NonNull String table, @Nullable ContentValues values, @Nullable String whereClause, @Nullable String[] whereArgs, int conflictAlgorithm) {
        throw new RuntimeException("Stub!");
    }

    public void execSQL(String sql) throws SQLException {
        throw new RuntimeException("Stub!");
    }

    public void execSQL(@NonNull String sql, @NonNull Object[] bindArgs) throws SQLException {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public SQLiteRawStatement createRawStatement(@NonNull String sql) {
        throw new RuntimeException("Stub!");
    }

    public long getLastInsertRowId() {
        throw new RuntimeException("Stub!");
    }

    public long getLastChangedRowCount() {
        throw new RuntimeException("Stub!");
    }

    public long getTotalChangedRowCount() {
        throw new RuntimeException("Stub!");
    }

    public void validateSql(@NonNull String sql, @Nullable CancellationSignal cancellationSignal) {
        throw new RuntimeException("Stub!");
    }

    public boolean isReadOnly() {
        throw new RuntimeException("Stub!");
    }

    public boolean isOpen() {
        throw new RuntimeException("Stub!");
    }

    public boolean needUpgrade(int newVersion) {
        throw new RuntimeException("Stub!");
    }

    public String getPath() {
        throw new RuntimeException("Stub!");
    }

    public void setLocale(Locale locale) {
        throw new RuntimeException("Stub!");
    }

    public void setMaxSqlCacheSize(int cacheSize) {
        throw new RuntimeException("Stub!");
    }

    public void setForeignKeyConstraintsEnabled(boolean enable) {
        throw new RuntimeException("Stub!");
    }

    public boolean enableWriteAheadLogging() {
        throw new RuntimeException("Stub!");
    }

    public void disableWriteAheadLogging() {
        throw new RuntimeException("Stub!");
    }

    public boolean isWriteAheadLoggingEnabled() {
        throw new RuntimeException("Stub!");
    }

    public List<Pair<String, String>> getAttachedDbs() {
        throw new RuntimeException("Stub!");
    }

    public boolean isDatabaseIntegrityOk() {
        throw new RuntimeException("Stub!");
    }

    public String toString() {
        throw new RuntimeException("Stub!");
    }

    public static final class OpenParams {
        OpenParams() {
            throw new RuntimeException("Stub!");
        }

        public int getLookasideSlotSize() {
            throw new RuntimeException("Stub!");
        }

        public int getLookasideSlotCount() {
            throw new RuntimeException("Stub!");
        }

        public int getOpenFlags() {
            throw new RuntimeException("Stub!");
        }

        @Nullable
        public CursorFactory getCursorFactory() {
            throw new RuntimeException("Stub!");
        }

        @Nullable
        public DatabaseErrorHandler getErrorHandler() {
            throw new RuntimeException("Stub!");
        }

        public long getIdleConnectionTimeout() {
            throw new RuntimeException("Stub!");
        }

        @Nullable
        public String getJournalMode() {
            throw new RuntimeException("Stub!");
        }

        @Nullable
        public String getSynchronousMode() {
            throw new RuntimeException("Stub!");
        }

        public static final class Builder {
            public Builder() {
                throw new RuntimeException("Stub!");
            }

            public Builder(OpenParams params) {
                throw new RuntimeException("Stub!");
            }

            public Builder setLookasideConfig(int slotSize, int slotCount) {
                throw new RuntimeException("Stub!");
            }

            @NonNull
            public Builder setOpenFlags(int openFlags) {
                throw new RuntimeException("Stub!");
            }

            @NonNull
            public Builder addOpenFlags(int openFlags) {
                throw new RuntimeException("Stub!");
            }

            @NonNull
            public Builder removeOpenFlags(int openFlags) {
                throw new RuntimeException("Stub!");
            }

            @NonNull
            public Builder setCursorFactory(@Nullable CursorFactory cursorFactory) {
                throw new RuntimeException("Stub!");
            }

            @NonNull
            public Builder setErrorHandler(@Nullable DatabaseErrorHandler errorHandler) {
                throw new RuntimeException("Stub!");
            }

            @Deprecated
            @NonNull
            public Builder setIdleConnectionTimeout(long idleConnectionTimeoutMs) {
                throw new RuntimeException("Stub!");
            }

            @NonNull
            public Builder setJournalMode(@NonNull String journalMode) {
                throw new RuntimeException("Stub!");
            }

            @NonNull
            public Builder setSynchronousMode(@NonNull String syncMode) {
                throw new RuntimeException("Stub!");
            }

            @NonNull
            public OpenParams build() {
                throw new RuntimeException("Stub!");
            }
        }
    }

    public static interface CursorFactory {
        public Cursor newCursor(SQLiteDatabase var1, SQLiteCursorDriver var2, String var3, SQLiteQuery var4);
    }
}

