# kxy-codew

**kxy-codew** is a lightweight Python profiling tool that makes it easy to measure the performance of your entire application or specific functions. Results are centralized on [https://kxy.codew.es](https://kxy.codew.es), where you get a detailed performance report via a sharable link.

## Features

- Profile your entire Python application with a single call.
- Decorator to profile any function on every call.
- Get performance reports with one-click access.
- Simple to integrate with your code.

---

## Installation

```python

pip install kxy-codew

```


## Usage

1. Sign up at [https://kxy.codew.es](https://kxy.codew.es), create an App, and then and get your API token.

### Profile the entire application

```python
from src.kxy_codew import set_token, performance


set_token("NcPi_dCJ78VjxmZ4M..............")
performance.init_kxy()

# Your application code here
```

When the program ends, it will print a link to the profiling report like:

```bash
Profile report available at: https://7176.codew.es/profile_g2dot/3884a9eb-c74c-4aac-8443-4536629d82c4
```


### Profile a specific function
```python

from src.kxy_codew import set_token, performance

set_token("NcPi_dCJ78VjxmZ4M..............")

@performance.profile
def busy_wait(duration):
    x = 0
    for i in range(duration * 10000000):
        x = duration * 100 - 20 / 12
        x += 1
    return x

busy_wait(10)
busy_wait(30)
busy_wait(100)
```

After every execution of the decorated function, a detailed profiling record is added to the panel on https://kxy.codew.es
