# Clinical Study Report (CSR) Template
## ICH-E3 Format

---

# TITLE PAGE

**Study Title:** [Full descriptive title including compound, indication, phase]

**Protocol Number:** [Sponsor protocol number]  
**Protocol Version:** [Final protocol version and date]

**Sponsor:** [Company name and address]  
**Compound/Drug Name:** [Generic and proprietary names, compound code]  
**Indication:** [Therapeutic area and specific indication studied]

**Study Phase:** [I / II / III / IV]  
**Study Type:** [Interventional / Observational]

**Report Date:** [MM/DD/YYYY]  
**Report Version:** [Version number]

**Medical Expert:** [Name, MD, Title]  
**Biostatistician:** [Name, PhD, Title]

**Confidentiality Statement:**
"This document contains confidential information belonging to [Sponsor]. It may not be reproduced or distributed without permission."

---

# SYNOPSIS

**Title:** [Abbreviated title]

**Protocol Number:** [Number]  
**Study Phase:** [Phase]  
**Study Period:** [Start date - End date]

## Study Objectives

**Primary Objective:**
[State primary objective clearly and concisely]

**Secondary Objectives:**
- [Secondary objective 1]
- [Secondary objective 2]

## Methodology

**Study Design:**
[Randomized, double-blind, placebo-controlled, parallel-group, etc.]

**Study Population:**
- Target population: [Patient population]
- Key inclusion criteria: [Main criteria]
- Key exclusion criteria: [Main criteria]

**Sample Size:**
- Planned: [N participants]
- Randomized: [N participants]
- Completed: [N participants]

**Treatment:**
- Treatment A: [Drug name, dose, route, frequency]
- Treatment B: [Comparator/placebo]
- Treatment duration: [Weeks/months]
- Follow-up duration: [Weeks/months]

**Endpoints:**

Primary:
- [Primary endpoint definition and timepoint]

Secondary:
- [Secondary endpoint 1]
- [Secondary endpoint 2]

**Statistical Methods:**
[Brief description of analysis approach, significance level, handling of multiplicity]

## Results

**Participant Disposition:**
- Screened: [N]
- Randomized: [N Treatment A, N Treatment B]
- Completed: [N Treatment A, N Treatment B]
- Discontinued: [N overall, % - main reasons]

**Demographics and Baseline:**
[Summary of key baseline characteristics, comparability across groups]

**Efficacy Results:**

Primary Endpoint:
- [Result for Treatment A vs B, effect size, 95% CI, p-value]

Secondary Endpoints:
- [Results for each secondary endpoint]

**Safety Results:**
- Any AE: [% Treatment A vs B]
- Treatment-related AE: [% Treatment A vs B]
- Serious AE: [% Treatment A vs B]
- Discontinuations due to AE: [% Treatment A vs B]
- Deaths: [N Treatment A vs B]
- Common AEs (≥5%): [List with percentages]

## Conclusions

[Overall conclusions regarding efficacy and safety, benefit-risk assessment]

---

# TABLE OF CONTENTS

[Detailed table of contents with page numbers]

---

# LIST OF ABBREVIATIONS

| Abbreviation | Definition |
|--------------|------------|
| AE | Adverse Event |
| ANCOVA | Analysis of Covariance |
| CI | Confidence Interval |
| CSR | Clinical Study Report |
| FAS | Full Analysis Set |
| GCP | Good Clinical Practice |
| ICF | Informed Consent Form |
| ITT | Intent-to-Treat |
| PP | Per-Protocol |
| SAE | Serious Adverse Event |
| SD | Standard Deviation |
| [Add study-specific abbreviations] | |

---

# ETHICS (Section 2)

## 2.1 Independent Ethics Committee (IEC) or Institutional Review Board (IRB)

[List of all IECs/IRBs that approved the study]

| Site Number | Institution | IRB/IEC Name | Approval Date |
|-------------|------------|--------------|---------------|
| 001 | [Institution] | [IRB name] | [MM/DD/YYYY] |

## 2.2 Ethical Conduct of the Study

This study was conducted in accordance with:
- ICH Good Clinical Practice (GCP) E6(R2)
- Declaration of Helsinki (current version)
- Applicable regulatory requirements
- Sponsor Standard Operating Procedures

## 2.3 Patient Information and Consent

Informed consent was obtained from all participants before any study-specific procedures. The informed consent process included:
- Written information about study purpose, procedures, risks, and benefits
- Opportunity to ask questions
- Voluntary participation with right to withdraw
- Signatures of participant and person obtaining consent
- Copy provided to participant

---

# INVESTIGATORS AND STUDY ADMINISTRATIVE STRUCTURE (Section 3)

## 3.1 Investigators and Study Centers

[Table listing all investigators, sites, and enrollment]

| Site No. | Investigator | Institution | City, Country | Subjects Enrolled |
|----------|--------------|-------------|---------------|-------------------|
| 001 | [Name, MD] | [Institution] | [City, Country] | [N] |

**Coordinating Investigator:** [Name, if applicable]

## 3.2 Study Administrative Structure

**Sponsor:**
- Medical Monitor: [Name, credentials]
- Project Manager: [Name]
- Biostatistician: [Name, credentials]

**Contract Research Organization (CRO):** [Name, if applicable]
- [Responsibilities]

## 3.3 Responsibilities of Parties Involved

[Description of sponsor, investigator, CRO, DSMB responsibilities]

---

# INTRODUCTION (Section 4)

## 4.1 Background

[Detailed background on disease/condition, unmet medical need, treatment landscape]

## 4.2 Nonclinical Studies

[Summary of relevant preclinical pharmacology, toxicology, and safety findings]

## 4.3 Previous Clinical Studies

[Summary of prior clinical experience with investigational product]

## 4.4 Study Rationale and Objectives

[Justification for conducting this study, specific objectives]

---

# STUDY OBJECTIVES AND PLAN (Section 5)

## 5.1 Objectives and Endpoints

**Primary Objective:**
[Objective statement]

**Primary Endpoint:**
[Detailed endpoint definition, measurement method, timepoint]

**Secondary Objectives:**
1. [Objective]
2. [Objective]

**Secondary Endpoints:**
1. [Endpoint definition]
2. [Endpoint definition]

## 5.2 Study Design

[Detailed description of study design with diagram if helpful]

**Design Type:** [Parallel, crossover, factorial, etc.]
**Blinding:** [Double-blind, open-label, etc.]
**Randomization:** [1:1, 2:1, stratified, etc.]
**Duration:** [Treatment period, follow-up period]

**Study Schema:**
[Flow diagram showing screening, randomization, treatment periods, follow-up]

## 5.3 Study Population

**Key Inclusion Criteria:**
1. [Criterion]
2. [Criterion]

**Key Exclusion Criteria:**
1. [Criterion]
2. [Criterion]

## 5.4 Treatments

**Investigational Product:**
- Name: [Generic, trade, code]
- Formulation: [Tablet, capsule, injection]
- Dose: [Dose and regimen]
- Route: [PO, IV, SC, etc.]
- Packaging and labeling: [Description]

**Comparator:**
[Similar details for comparator or placebo]

**Concomitant Medications:**
[Permitted and prohibited medications]

## 5.5 Sample Size Determination

**Target Sample Size:** [N per group, N total]

**Justification:**
- Assumed effect size: [Value]
- Variability (SD): [Value]
- Type I error (α): [0.05]
- Power (1-β): [80% or 90%]
- Expected dropout rate: [%]
- Two-sided test

## 5.6 Statistical Analysis Plan

**Analysis Populations:**
- Full Analysis Set (FAS): [Definition]
- Per-Protocol Set (PPS): [Definition]
- Safety Analysis Set: [Definition]

**Statistical Methods:**
- Primary endpoint: [Method - e.g., ANCOVA with baseline as covariate]
- Secondary endpoints: [Methods]
- Handling of missing data: [Approach]
- Multiplicity adjustment: [Method if applicable]
- Interim analyses: [If planned]

**Significance Level:** α = 0.05 (two-sided)

---

# STUDY PATIENTS (Section 6)

## 6.1 Disposition of Patients

**Participant Flow (CONSORT Diagram):**

[Include detailed CONSORT diagram showing screening through analysis]

**Summary Table:**

| Category | Treatment A | Treatment B | Total |
|----------|-------------|-------------|-------|
| Screened | N | N | N |
| Screen failures | N (%) | N (%) | N (%) |
| Randomized | N | N | N |
| Received treatment | N (%) | N (%) | N (%) |
| Completed | N (%) | N (%) | N (%) |
| Discontinued | N (%) | N (%) | N (%) |
| - Adverse event | N (%) | N (%) | N (%) |
| - Lack of efficacy | N (%) | N (%) | N (%) |
| - Lost to follow-up | N (%) | N (%) | N (%) |
| - Withdrawal of consent | N (%) | N (%) | N (%) |
| - Other | N (%) | N (%) | N (%) |

## 6.2 Protocol Deviations

**Major Protocol Deviations:**
[Summary of major deviations, impact on data, subjects affected]

**Important Protocol Deviations by Category:**

| Deviation Type | Treatment A | Treatment B | Total |
|----------------|-------------|-------------|-------|
| Inclusion/exclusion criteria | N (%) | N (%) | N (%) |
| Dosing errors | N (%) | N (%) | N (%) |
| Prohibited medications | N (%) | N (%) | N (%) |
| Missed visits | N (%) | N (%) | N (%) |

---

(Continues with sections 7-14 following ICH-E3 structure...)

---

**Note:** This is an abbreviated template. A complete CSR following ICH-E3 is typically 50-300 pages with extensive appendices. Key sections to complete:
- Section 7: Efficacy Evaluation
- Section 8: Safety Evaluation
- Section 9: Discussion and Overall Conclusions
- Section 10: Tables, Figures, and Graphs
- Section 11: References
- Section 12-14: Appendices (Protocol, CRFs, Investigator list, etc.)


