# Scientific Writing Principles

## Overview

Effective scientific writing requires mastering fundamental principles that ensure clarity, precision, and impact. Unlike creative or narrative writing, scientific writing prioritizes accuracy, conciseness, and objectivity. This guide covers the core principles that distinguish good scientific writing from poor writing and provides practical strategies for improvement.

## The Three Pillars of Scientific Writing

### 1. Clarity

**Definition:** Writing that is immediately understandable to the intended audience without ambiguity or confusion.

**Why it matters:** Science is complex enough without unclear writing adding confusion. Readers should focus on understanding the science, not deciphering the prose.

#### Strategies for Clarity

**Use precise, unambiguous language:**
```
Poor: "The drug seemed to help quite a few patients."
Better: "The drug reduced symptoms in 68% (32/47) of patients."
```

**Define technical terms at first use:**
```
"We measured brain-derived neurotrophic factor (BDNF), a protein involved in
neuronal survival and plasticity."
```

**Maintain logical flow within and between paragraphs:**
- Each paragraph should have one main idea
- Topic sentence introduces the paragraph's focus
- Supporting sentences develop that focus
- Transition sentences connect paragraphs

**Use active voice when it improves clarity:**
```
Passive (less clear): "The samples were analyzed by the researchers."
Active (clearer): "Researchers analyzed the samples."
```

However, passive voice is acceptable and often preferred in Methods when the action is more important than the actor:
```
"Blood samples were collected at baseline and after 6 weeks."
```

**Break up long, complex sentences:**
```
Poor: "The results of our study, which involved 200 participants recruited from
three hospitals and followed for 12 months with assessments every 4 weeks using
validated questionnaires, showed significant improvements in the intervention
group."

Better: "Our study involved 200 participants recruited from three hospitals.
Participants were followed for 12 months with assessments every 4 weeks using
validated questionnaires. The intervention group showed significant improvements."
```

**Use specific verbs:**
```
Weak: "The study looked at depression in adolescents."
Stronger: "The study examined factors contributing to depression in adolescents."
```

#### Common Clarity Problems

**Ambiguous pronouns:**
```
Poor: "Group A received the drug and Group B received placebo. They showed
improvement."
(Who is "they"?)

Better: "Group A received the drug and Group B received placebo. The drug-treated
group showed improvement."
```

**Misplaced modifiers:**
```
Poor: "We measured blood pressure in patients using an automated monitor."
(Are the patients using the monitor, or are we?)

Better: "Using an automated monitor, we measured blood pressure in patients."
```

**Unclear referents:**
```
Poor: "The increase in expression was accompanied by decreased proliferation, which
was unexpected."
(What was unexpected—the decrease, the accompaniment, or both?)

Better: "The increase in expression was accompanied by decreased proliferation.
This inverse relationship was unexpected."
```

### 2. Conciseness

**Definition:** Expressing ideas in the fewest words necessary without sacrificing clarity or completeness.

**Why it matters:** Concise writing respects readers' time. Every unnecessary word is a missed opportunity for clarity and impact. As the principle states: "We value concise writing because we value time."

#### Strategies for Conciseness

**Eliminate redundant words and phrases:**

| Wordy | Concise |
|-------|---------|
| "due to the fact that" | "because" |
| "in order to" | "to" |
| "it is important to note that" | [delete] |
| "a total of 50 participants" | "50 participants" |
| "completely eliminate" | "eliminate" |
| "has been shown to be" | "is" |
| "in the event that" | "if" |
| "at the present time" | "now" or "currently" |
| "conduct an investigation into" | "investigate" |
| "give consideration to" | "consider" |

**Avoid throat-clearing phrases:**
```
Wordy: "It is interesting to note that the results of our study demonstrate that..."
Concise: "Our results demonstrate that..." or "The results show that..."
```

**Use strong verbs instead of noun+verb combinations:**

| Wordy | Concise |
|-------|---------|
| "make a decision" | "decide" |
| "perform an analysis" | "analyze" |
| "conduct a study" | "study" or "studied" |
| "make an assessment" | "assess" |
| "provide information about" | "inform" |

**Eliminate unnecessary intensifiers:**
```
Wordy: "The results were very significant."
Concise: "The results were significant." (p-value conveys the degree)
```

**Avoid repeating information unnecessarily:**
```
Redundant: "The results showed that participants in the intervention group, who
received the treatment intervention, had better outcomes."
Concise: "The intervention group had better outcomes."
```

**Favor shorter constructions:**
```
Wordy: "In spite of the fact that the sample size was small..."
Concise: "Although the sample size was small..."
```

#### Acceptable Length vs. Unnecessary Length

**Not all long sentences are bad:**
```
This detailed sentence is fine: "We analyzed blood samples using liquid
chromatography-tandem mass spectrometry (LC-MS/MS) with a Waters Acquity UPLC
system coupled to a Xevo TQ-S mass spectrometer (Waters Corporation, Milford, MA)."

Why? Because each element is necessary information.
```

**The key question:** Can any word be removed without losing meaning or precision? If yes, remove it.

### 3. Accuracy

**Definition:** Precise, correct representation of data, methods, and interpretations.

**Why it matters:** Scientific credibility depends on accuracy. Inaccurate reporting undermines the entire scientific enterprise.

#### Strategies for Accuracy

**Report exact values with appropriate precision:**
```
Poor: "The mean was about 25."
Better: "The mean was 24.7 ± 3.2 (SD)."
```

**Match precision to measurement capability:**
```
Inappropriate: "Mean age was 45.237 years" (implies false precision)
Appropriate: "Mean age was 45.2 years"
```

**Use consistent terminology throughout:**
```
Inconsistent: Introduction calls it "cognitive function," Methods call it "mental
performance," Results call it "intellectual ability."

Consistent: Use "cognitive function" throughout, or define explicitly: "cognitive
function (also termed mental performance)"
```

**Distinguish observations from interpretations:**
```
Observation: "Mean blood pressure decreased from 145 to 132 mmHg (p=0.003)."
Interpretation: "This suggests the intervention effectively lowers blood pressure."
```

**Be specific about uncertainty:**
```
Vague: "There may be some error in these measurements."
Specific: "Measurements have a standard error of ±2.5 mmHg based on instrument
specifications."
```

**Use correct statistical language:**
```
Incorrect: "The correlation was highly significant (p=0.03)."
Correct: "The correlation was statistically significant (p=0.03)."
(p=0.03 is not "highly" significant; that's reserved for p<0.001)
```

**Verify all numbers:**
- Check that numbers in text match tables/figures
- Verify that n values sum correctly
- Confirm percentages are correctly calculated
- Double-check all statistics

#### Common Accuracy Problems

**Overgeneralization:**
```
Poor: "Exercise prevents depression."
Better: "In our sample, participants randomized to the exercise intervention showed
fewer depressive symptoms than controls (mean difference 3.2 points on the BDI-II,
95% CI: 1.5-4.9, p<0.001)."
```

**Unwarranted causal claims:**
```
Poor (from observational study): "Vitamin D supplementation reduces cancer risk."
Better: "Vitamin D levels were inversely associated with cancer incidence in this
cohort (HR=0.82, 95% CI: 0.71-0.95)."
```

**Imprecise numerical descriptions:**
```
Vague: "Many participants dropped out."
Precise: "15/50 (30%) participants withdrew before study completion."
```

## Additional Key Principles

### 4. Objectivity

**Definition:** Presenting information impartially without bias, exaggeration, or unsupported opinion.

**Strategies:**

**Present results without bias:**
```
Biased: "As expected, our superior method performed better."
Objective: "Method A showed higher accuracy than Method B (87% vs. 76%, p=0.02)."
```

**Acknowledge conflicting evidence:**
```
"Our findings contrast with Smith et al. (2022), who reported no significant effect.
This discrepancy may result from differences in intervention intensity or population
characteristics."
```

**Avoid emotional or evaluative language:**
```
Subjective: "The results were disappointing and concerning."
Objective: "The intervention did not significantly reduce symptoms (p=0.42)."
```

**Distinguish fact from speculation:**
```
"The observed decrease in cell viability was accompanied by increased caspase-3
activity, suggesting that apoptosis may be the primary mechanism of cell death."
(Uses "suggesting" and "may be" to indicate interpretation)
```

### 5. Consistency

**Maintain consistency throughout the manuscript:**

**Terminology:**
- Use the same term for the same concept (not synonyms for variety)
- Define abbreviations at first use and use consistently thereafter
- Use standard nomenclature for genes, proteins, chemicals

**Notation:**
- Statistical notation (p-value format, CI presentation)
- Units of measurement
- Number formatting (decimal places)

**Tense:**
- Past tense for your specific study actions
- Present tense for established facts
- See detailed tense guide in IMRAD structure reference

**Style:**
- Follow journal guidelines consistently
- Citation format
- Heading capitalization
- Number vs. word for numerals

### 6. Logical Organization

**Create a clear "red thread" through the manuscript:**

**Paragraph structure:**
1. Topic sentence (main idea)
2. Supporting sentences (evidence, explanation)
3. Concluding/transition sentence (link to next idea)

**Section flow:**
- Each section builds logically on the previous
- Questions raised in Introduction are answered in Results
- Findings presented in Results are interpreted in Discussion

**Signposting:**
```
"First, we examined..."
"Next, we investigated..."
"Finally, we assessed..."
```

**Parallelism:**
```
Not parallel: "Aims were to (1) measure blood pressure, (2) assessment of
cognitive function, and (3) we wanted to evaluate mood."

Parallel: "Aims were to (1) measure blood pressure, (2) assess cognitive
function, and (3) evaluate mood."
```

## Verb Tense in Scientific Writing

### General Guidelines

**Present tense** for:
- Established facts and general truths
  - "DNA is composed of nucleotides."
- Conclusions you are drawing
  - "These findings suggest that..."
- Referring to figures and tables
  - "Figure 1 shows the distribution..."

**Past tense** for:
- Specific findings from completed research (yours and others')
  - "Smith et al. (2022) found that..."
  - "We observed a significant decrease..."
- Methods you performed
  - "Participants completed questionnaires at baseline."

**Present perfect** for:
- Recent developments with current relevance
  - "Recent studies have demonstrated..."
- Research area background
  - "Several approaches have been proposed..."

### Section-Specific Tense

| Section | Primary Tense | Examples |
|---------|---------------|----------|
| **Abstract - Background** | Present or present perfect | "Depression affects millions" / "Research has shown..." |
| **Abstract - Methods** | Past | "We recruited 100 participants" |
| **Abstract - Results** | Past | "The intervention reduced symptoms" |
| **Abstract - Conclusions** | Present | "These findings suggest..." |
| **Introduction - Background** | Present (facts), present perfect (research) | "Exercise is beneficial" / "Studies have shown..." |
| **Introduction - Gap** | Present or present perfect | "However, little is known..." |
| **Introduction - This study** | Past or present | "We investigated..." / "This study investigates..." |
| **Methods** | Past | "We collected samples..." |
| **Results** | Past | "Mean age was 45 years" |
| **Discussion - Your findings** | Past | "We found that..." |
| **Discussion - Interpretation** | Present | "This suggests..." |
| **Discussion - Prior work** | Past or present | "Smith found..." / "Previous work demonstrates..." |

## Common Writing Pitfalls

### 1. Jargon Overload

**Problem:** Excessive use of technical terms without definition

**Example:**
```
Poor: "We utilized qRT-PCR to quantify mRNA expression via SYBR-Green-based
fluorescence detection following cDNA synthesis from total RNA using oligo-dT primers."

Better: "We quantified mRNA expression using quantitative reverse transcription PCR
(qRT-PCR). Total RNA was reverse transcribed to complementary DNA (cDNA) using
oligo-dT primers, then amplified with SYBR Green fluorescent detection."
```

### 2. Nominalization

**Problem:** Turning verbs into nouns, making writing heavy and indirect

**Examples:**

| Nominalized | Direct |
|-------------|--------|
| "give consideration to" | "consider" |
| "make an assumption" | "assume" |
| "perform an investigation" | "investigate" |
| "conduct an examination" | "examine" |
| "achieve a reduction" | "reduce" |

### 3. Hedging Excessively or Insufficiently

**Excessive hedging** (sounds uncertain):
```
"It could perhaps be possible that the intervention might possibly have some effect
on symptoms under certain conditions."
```

**Insufficient hedging** (overstates conclusions):
```
"The intervention cures depression."
```

**Appropriate hedging:**
```
"The intervention significantly reduced depressive symptoms in this sample,
suggesting it may be effective for treating mild to moderate depression."
```

**Hedging words to use appropriately:**
- Suggests, indicates, implies (not proves, demonstrates for correlational data)
- May, might, could (possibilities)
- Appears to, seems to (observations needing confirmation)
- Likely, probably, possibly (degrees of certainty)

### 4. Anthropomorphism

**Problem:** Attributing human characteristics to non-human entities

**Examples:**

| Anthropomorphic | Scientific |
|----------------|-----------|
| "The study wanted to examine..." | "We aimed to examine..." or "The study examined..." |
| "The data suggest they want..." | "The data suggest that..." |
| "This paper will prove..." | "This paper demonstrates..." |
| "Table 1 tells us..." | "Table 1 shows..." |

### 5. Abbreviation Abuse

**Problems:**
- Too many abbreviations burden the reader
- Abbreviating terms used only once or twice
- Not defining abbreviations at first use

**Guidelines:**
- Only abbreviate terms used ≥3-4 times
- Define at first use in abstract (if used in abstract)
- Define at first use in main text
- Don't abbreviate in title
- Limit to 3-4 new abbreviations per paper when possible
- Use standard abbreviations (DNA, RNA, HIV, etc.) without definition

**Example:**
```
Poor: "We measured Brain-Derived Neurotrophic Factor (BDNF) at baseline. BDNF
levels were elevated."
(Only used twice, abbreviation unnecessary)

Better: "We measured brain-derived neurotrophic factor at baseline. Levels were
elevated."
```

## Specific Sentence-Level Issues

### Dangling Modifiers

**Problem:**
```
"After incubating for 2 hours, we measured absorbance."
(The sentence suggests "we" were incubated)

Better: "After incubating samples for 2 hours, we measured absorbance."
Or: "After 2-hour incubation, we measured absorbance."
```

### Misplaced Commas

**Common errors:**

**Between subject and verb:**
```
Wrong: "The participants in the intervention group, showed improvement."
Right: "The participants in the intervention group showed improvement."
```

**In compound predicates:**
```
Wrong: "We measured blood pressure, and recorded symptoms."
Right: "We measured blood pressure and recorded symptoms."
(No comma before "and" when it doesn't join independent clauses)
```

### Pronoun Agreement

```
Wrong: "Each participant completed their questionnaire."
Right: "Each participant completed his or her questionnaire."
Or better: "Participants completed their questionnaires."
```

### Subject-Verb Agreement

```
Wrong: "The group of participants were heterogeneous."
Right: "The group of participants was heterogeneous."
(Subject is "group" [singular], not "participants")

But: "The participants were heterogeneous." (Plural subject)
```

## Word Choice

### Commonly Confused Words in Scientific Writing

| Often Misused | Correct Usage |
|---------------|---------------|
| **affect / effect** | Affect (verb): influence; Effect (noun): result; Effect (verb): bring about |
| **among / between** | Among: three or more; Between: two |
| **continual / continuous** | Continual: repeated; Continuous: uninterrupted |
| **data is / data are** | Data are (plural); datum is (singular) |
| **fewer / less** | Fewer: countable items; Less: continuous quantities |
| **i.e. / e.g.** | i.e. (that is): restatement; e.g. (for example): examples |
| **imply / infer** | Imply: suggest; Infer: deduce |
| **parameter / variable** | Parameter: population value; Variable: measured characteristic |
| **principal / principle** | Principal: main; Principle: rule or concept |
| **significant** | Reserve for statistical significance, not importance |
| **that / which** | That: restrictive clause; Which: nonrestrictive clause |

### Words to Avoid or Use Carefully

**Avoid informal language:**
- "a lot of" → "many" or "substantial"
- "got" → "obtained" or "became"
- "showed up" → "appeared" or "was evident"

**Avoid vague quantifiers:**
- "some" → specify how many
- "often" → specify frequency
- "recently" → specify timeframe

**Avoid unnecessary modifiers:**
- "very significant" → "significant" (p-value shows degree)
- "quite large" → "large" or specify size
- "rather interesting" → delete or explain why

## Numbers and Units

### When to Use Numerals vs. Words

**Use numerals for:**
- All numbers ≥10
- Numbers with units (5 mg, 3 mL)
- Statistical values (p=0.03, t=2.14)
- Ages, dates, times
- Scores and scales
- Percentages (15%)

**Use words for:**
- Numbers <10 when not connected to units (five participants)
- Numbers beginning a sentence (spell out or restructure)

**Examples:**
```
"Five participants withdrew" OR "There were 5 withdrawals"
(NOT: "5 participants withdrew")

"We tested 15 samples at 3 time points"
"Mean age was 45 years"
```

### Units and Formatting

**Guidelines:**
- Space between number and unit (5 mg, not 5mg)
- No period after units (mg not mg.)
- Use SI units unless field convention differs
- Be consistent in decimal places
- Use commas for thousands in text (12,500 not 12500)

**Ranges:**
- Use en-dash (–) for ranges: 15–20 mg
- Include unit only after second number: 15–20 mg (not 15 mg–20 mg)

## Paragraph Structure

### Ideal Paragraph Length

**Guidelines:**
- 3-7 sentences typically
- One main idea per paragraph
- Too short (<2 sentences): may indicate idea needs development or combining
- Too long (>10 sentences): may need splitting

### Paragraph Coherence

**Techniques:**

**1. Topic sentence:**
```
"Exercise training improves cardiovascular function through multiple mechanisms.
[Following sentences explain these mechanisms]"
```

**2. Transitional phrases:**
- First, second, third, finally
- Furthermore, moreover, in addition
- However, nevertheless, conversely
- Therefore, thus, consequently
- For example, specifically, particularly

**3. Repetition of key terms:**
```
"...this mechanism of action. This mechanism may explain..."
(Not: "...this mechanism. This process may explain...")
```

**4. Parallel structure:**
```
"Group A received the drug. Group B received placebo. Group C received no treatment."
(Not: "Group A received the drug. Placebo was given to Group B. No treatment was
provided to the third group.")
```

## Revision Checklist

### Content Level

- [ ] Does every sentence add value?
- [ ] Are claims supported by data?
- [ ] Is the logic clear and sound?
- [ ] Are interpretations warranted by results?

### Paragraph Level

- [ ] Does each paragraph have one main idea?
- [ ] Are paragraphs in logical order?
- [ ] Are transitions smooth?
- [ ] Is there a clear "red thread"?

### Sentence Level

- [ ] Are sentences clear and concise?
- [ ] Is sentence structure varied?
- [ ] Are there no dangling modifiers?
- [ ] Do subjects and verbs agree?

### Word Level

- [ ] Is word choice precise?
- [ ] Are technical terms defined?
- [ ] Is terminology consistent?
- [ ] Are abbreviations necessary and defined?
- [ ] Are numbers formatted correctly?

### Grammar and Mechanics

- [ ] Is verb tense correct and consistent?
- [ ] Are commas used correctly?
- [ ] Do pronouns agree with antecedents?
- [ ] Is punctuation correct?
- [ ] Is spelling correct (including technical terms)?

## Tools for Improving Writing

### Grammar and Style Checkers

- **Grammarly**: Grammar, style, clarity
- **ProWritingAid**: In-depth writing analysis
- **Hemingway Editor**: Readability, simplification
- **LanguageTool**: Open-source grammar checker

**Caution:** These tools don't understand scientific writing conventions. Use them as a starting point, not final arbiter.

### Readability Metrics

**Flesch Reading Ease:**
- 60-70: acceptable for scientific papers
- <60: may be too complex

**Caution:** Don't sacrifice precision for readability scores designed for general audiences.

### Peer Review

**Most valuable tool:**
- Ask colleagues to read and provide feedback
- Identify unclear passages
- Check logical flow
- Verify interpretations are warranted

## Additional Resources

### Books on Scientific Writing

- *The Elements of Style* by Strunk & White (classic on clear writing)
- *On Writing Well* by William Zinsser
- *Scientific Writing: A Reader and Writer's Guide* by Jean-Luc Lebrun
- *How to Write a Scientific Paper* by George M. Whitesides
- *Style: Lessons in Clarity and Grace* by Joseph Williams

### Online Resources

- **Academic Phrasebank** (University of Manchester): Common academic phrases
- **Purdue OWL**: Grammar, punctuation, style
- **Nature Masterclasses**: Scientific writing courses
- **WritingCenters**: Many universities provide free online resources

### University Writing Centers

Most research universities offer:
- Individual consultations
- Workshops on scientific writing
- Online resources and handouts
- Support for non-native English speakers

## Venue-Specific Writing Styles

### Four Major Writing Style Categories

1. **Broad-audience accessible** (Nature, Science, PNAS)
2. **Clinical-professional** (NEJM, Lancet, JAMA)
3. **Technical-specialist** (field-specific journals)
4. **ML conference** (NeurIPS, ICML, ICLR, CVPR)

### Writing Style Comparison

| Aspect | Nature/Science | Medical | Specialized | ML Conference |
|--------|---------------|---------|-------------|---------------|
| **Sentence length** | 15-20 words | 12-18 words | 18-25 words | 12-20 words |
| **Vocabulary** | Minimal jargon | Clinical terms | Field-specific | Technical + math |
| **Tone** | Engaging, significant | Conservative | Formal | Direct, contribution-focused |
| **Key phrases** | "Here we show" | "We conducted" | "To elucidate" | "We propose", "Our contributions" |

**ML Conference Style:**

**Characteristics:**
- Direct, technical language with mathematical notation
- Contribution-focused (numbered lists common)
- Assumes ML expertise (CNNs, transformers, SGD, etc.)
- Emphasizes novelty and performance gains
- Pseudocode and equations expected

**Example opening (NeurIPS style):**
```
Vision transformers have achieved state-of-the-art performance on image classification,
but their quadratic complexity limits applicability to high-resolution images. We propose
Efficient-ViT, which reduces complexity to O(n log n) while maintaining accuracy. Our
contributions are: (1) a novel sparse attention mechanism, (2) theoretical analysis
showing preserved expressive power, and (3) empirical validation on ImageNet showing
15% speedup with comparable accuracy.
```
- Problem stated with technical context
- Solution previewed
- Numbered contributions
- Quantitative claims

### Key Writing Differences

| Aspect | Nature/Science | Medical | Specialized | ML Conference |
|--------|---------------|---------|-------------|---------------|
| **Paragraph length** | 3-5 sentences | 5-7 sentences | 6-10 sentences | 4-6 sentences |
| **Math/equations** | Minimize | Rare | Moderate | Essential |
| **Active voice** | Preferred | Mixed | Passive OK | Preferred |
| **Hedging** | Moderate | Conservative | Detailed | Minimal (claim gains) |
| **Figure integration** | Tight | Systematic | Detailed | Dense, in-page |

### Evaluation Focus by Venue

| Venue | Key Evaluation Criteria |
|-------|------------------------|
| **Nature/Science** | Accessible to non-specialists? Broad significance clear? Compelling story? |
| **Medical** | Clinical relevance apparent? Professional tone? Methods adequate? |
| **Specialized** | Technical precision? Field expertise shown? Methods detailed? |
| **ML conferences** | Clear contributions? Claims supported by experiments? Reproducible? |

**Common rejection reasons:**
- Poor writing quality/unclear prose
- Inappropriate style for venue
- Overstated claims
- Methods insufficient for reproduction
- Missing key details (baselines, ablations for ML; statistics for journals)

### Quick Style Adaptation Guide

| From → To | Key Changes |
|-----------|-------------|
| **Journal → ML conference** | Add numbered contributions; include equations/pseudocode; emphasize quantitative gains; condense prose |
| **ML conference → Journal** | Remove contribution numbering; expand motivation; separate Results/Discussion; reduce equations in main text |
| **Specialist → Broad** | Simplify language; emphasize broad implications; explain technical concepts; add context for non-experts |
| **Broad → Specialist** | Add technical detail; use field terminology freely; expand mechanistic discussion; cite field literature |
| **Basic science → Clinical** | Add patient/clinical context; use clinical language; emphasize outcomes/implications; cite clinical evidence |

### Pre-Submission Style Checklist

**All venues:**
- [ ] Writing style matches 3-5 recent papers from venue
- [ ] Sentence length appropriate
- [ ] Technical vocabulary level correct
- [ ] Tone consistent with venue
- [ ] No overstated claims

**ML conferences add:**
- [ ] Contributions clearly numbered in intro
- [ ] Mathematical notation correct and consistent
- [ ] Pseudocode/algorithms included where appropriate
- [ ] Claims quantified (e.g., "15% faster", "2.3% accuracy gain")
- [ ] Limitations acknowledged

## Final Thoughts

Effective scientific writing is a skill developed through practice. Key principles:

1. **Clarity** trumps complexity
2. **Conciseness** respects readers' time
3. **Accuracy** builds credibility
4. **Objectivity** maintains scientific integrity
5. **Consistency** aids comprehension
6. **Logical organization** guides readers
7. **Journal-specific adaptation** maximizes publication success

**Remember:** The goal is not to impress readers with vocabulary or complexity, but to communicate your science clearly and precisely so readers can understand, evaluate, and build upon your work. Adapt your writing style to match your target journal's expectations and audience.
