import { Construct, IConstruct } from 'constructs';
import { ApiObject } from './api-object';
export interface ChartProps {
    /**
     * The default namespace for all objects defined in this chart (directly or
     * indirectly). This namespace will only apply to objects that don't have a
     * `namespace` explicitly defined for them.
     *
     * @default - no namespace is synthesized (usually this implies "default")
     */
    readonly namespace?: string;
    /**
     * Labels to apply to all resources in this chart.
     *
     * @default - no common labels
     */
    readonly labels?: {
        [name: string]: string;
    };
}
export declare class Chart extends Construct {
    /**
     * Return whether the given object is a Chart.
     *
     * We do attribute detection since we can't reliably use 'instanceof'.
     */
    static isChart(x: any): x is Chart;
    /**
     * Finds the chart in which a node is defined.
     * @param c a construct node
     */
    static of(c: IConstruct): Chart;
    /**
     * The default namespace for all objects in this chart.
     */
    readonly namespace?: string;
    /**
     * Chart-level labels.
     */
    private readonly _labels?;
    constructor(scope: Construct, id: string, props?: ChartProps);
    /**
     * Labels applied to all resources in this chart.
     *
     * This is an immutable copy.
     */
    get labels(): {
        [name: string]: string;
    };
    /**
     * Generates a app-unique name for an object given it's construct node path.
     *
     * Different resource types may have different constraints on names
     * (`metadata.name`). The previous version of the name generator was
     * compatible with DNS_SUBDOMAIN but not with DNS_LABEL.
     *
     * For example, `Deployment` names must comply with DNS_SUBDOMAIN while
     * `Service` names must comply with DNS_LABEL.
     *
     * Since there is no formal specification for this, the default name
     * generation scheme for kubernetes objects in cdk8s was changed to DNS_LABEL,
     * since it’s the common denominator for all kubernetes resources
     * (supposedly).
     *
     * You can override this method if you wish to customize object names at the
     * chart level.
     *
     * @param apiObject The API object to generate a name for.
     */
    generateObjectName(apiObject: ApiObject): string;
    /**
     * Create a dependency between this Chart and other constructs.
     * These can be other ApiObjects, Charts, or custom.
     *
     * @param dependencies the dependencies to add.
     */
    addDependency(...dependencies: IConstruct[]): void;
    /**
     * Renders this chart to a set of Kubernetes JSON resources.
     * @returns array of resource manifests
     */
    toJson(): any[];
}
