"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Chart = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const app_1 = require("./app");
const names_1 = require("./names");
const CHART_SYMBOL = Symbol.for('cdk8s.Chart');
class Chart extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.namespace = props.namespace;
        this._labels = props.labels ?? {};
        Object.defineProperty(this, CHART_SYMBOL, { value: true });
    }
    /**
     * Return whether the given object is a Chart.
     *
     * We do attribute detection since we can't reliably use 'instanceof'.
     */
    static isChart(x) {
        return x !== null && typeof (x) === 'object' && CHART_SYMBOL in x;
    }
    /**
     * Finds the chart in which a node is defined.
     * @param c a construct node
     */
    static of(c) {
        if (Chart.isChart(c)) {
            return c;
        }
        const parent = constructs_1.Node.of(c).scope;
        if (!parent) {
            throw new Error('cannot find a parent chart (directly or indirectly)');
        }
        return Chart.of(parent);
    }
    /**
     * Labels applied to all resources in this chart.
     *
     * This is an immutable copy.
     */
    get labels() {
        return { ...this._labels };
    }
    /**
     * Generates a app-unique name for an object given it's construct node path.
     *
     * Different resource types may have different constraints on names
     * (`metadata.name`). The previous version of the name generator was
     * compatible with DNS_SUBDOMAIN but not with DNS_LABEL.
     *
     * For example, `Deployment` names must comply with DNS_SUBDOMAIN while
     * `Service` names must comply with DNS_LABEL.
     *
     * Since there is no formal specification for this, the default name
     * generation scheme for kubernetes objects in cdk8s was changed to DNS_LABEL,
     * since it’s the common denominator for all kubernetes resources
     * (supposedly).
     *
     * You can override this method if you wish to customize object names at the
     * chart level.
     *
     * @param apiObject The API object to generate a name for.
     */
    generateObjectName(apiObject) {
        return names_1.Names.toDnsLabel(apiObject);
    }
    /**
     * Create a dependency between this Chart and other constructs.
     * These can be other ApiObjects, Charts, or custom.
     *
     * @param dependencies the dependencies to add.
     */
    addDependency(...dependencies) {
        constructs_1.Node.of(this).addDependency(...dependencies);
    }
    /**
     * Renders this chart to a set of Kubernetes JSON resources.
     * @returns array of resource manifests
     */
    toJson() {
        return app_1.App._synthChart(this);
    }
}
exports.Chart = Chart;
_a = JSII_RTTI_SYMBOL_1;
Chart[_a] = { fqn: "cdk8s.Chart", version: "2.3.61" };
//# sourceMappingURL=data:application/json;base64,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