"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Include = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const api_object_1 = require("./api-object");
const yaml_1 = require("./yaml");
/**
 * Reads a YAML manifest from a file or a URL and defines all resources as API
 * objects within the defined scope.
 *
 * The names (`metadata.name`) of imported resources will be preserved as-is
 * from the manifest.
 */
class Include extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const objects = yaml_1.Yaml.load(props.url);
        let order = 0;
        for (const obj of objects) {
            const objname = obj.metadata?.name ?? `object${order++}`;
            // render an id: name[-kind][-namespace]
            const objid = [objname, obj.kind?.toLowerCase(), obj.metadata?.namespace].filter(x => x).join('-');
            new api_object_1.ApiObject(this, objid, obj);
        }
    }
    /**
     * Returns all the included API objects.
     */
    get apiObjects() {
        return constructs_1.Node.of(this).children.filter(o => o instanceof api_object_1.ApiObject);
    }
}
exports.Include = Include;
_a = JSII_RTTI_SYMBOL_1;
Include[_a] = { fqn: "cdk8s.Include", version: "2.3.61" };
//# sourceMappingURL=data:application/json;base64,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