# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ....core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .observations_view import ObservationsView
from .score_v_1 import ScoreV1
from .trace import Trace


class TraceWithFullDetails(Trace):
    html_path: str = pydantic_v1.Field(alias="htmlPath")
    """
    Path of trace in ABV UI
    """

    latency: float = pydantic_v1.Field()
    """
    Latency of trace in seconds
    """

    total_cost: float = pydantic_v1.Field(alias="totalCost")
    """
    Cost of trace in USD
    """

    observations: typing.List[ObservationsView] = pydantic_v1.Field()
    """
    List of observations
    """

    scores: typing.List[ScoreV1] = pydantic_v1.Field()
    """
    List of scores
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        kwargs_with_defaults_exclude_none: typing.Any = {
            "by_alias": True,
            "exclude_none": True,
            **kwargs,
        }

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset),
            super().dict(**kwargs_with_defaults_exclude_none),
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
