# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import pydantic_v1
from ...core.request_options import RequestOptions
from ..commons.errors.access_denied_error import AccessDeniedError
from ..commons.errors.error import Error
from ..commons.errors.method_not_allowed_error import MethodNotAllowedError
from ..commons.errors.not_found_error import NotFoundError
from ..commons.errors.unauthorized_error import UnauthorizedError
from .types.membership_request import MembershipRequest
from .types.membership_response import MembershipResponse
from .types.memberships_response import MembershipsResponse
from .types.organization_projects_response import OrganizationProjectsResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class OrganizationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_organization_memberships(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MembershipsResponse:
        """
        Get all memberships for the organization associated with the API key (requires organization-scoped API key)

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MembershipsResponse

        Examples
        --------
        from abvdev.client import FernABV

        client = FernABV(
            x_abv_sdk_name="YOUR_X_ABV_SDK_NAME",
            x_abv_sdk_version="YOUR_X_ABV_SDK_VERSION",
            x_abv_public_key="YOUR_X_ABV_PUBLIC_KEY",
            username="YOUR_USERNAME",
            password="YOUR_PASSWORD",
            base_url="https://yourhost.com/path/to/api",
        )
        client.organizations.get_organization_memberships()
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/public/organizations/memberships",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(MembershipsResponse, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise Error(pydantic_v1.parse_obj_as(typing.Any, _response.json()))  # type: ignore
            if _response.status_code == 401:
                raise UnauthorizedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 403:
                raise AccessDeniedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_organization_membership(
        self,
        *,
        request: MembershipRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MembershipResponse:
        """
        Create or update a membership for the organization associated with the API key (requires organization-scoped API key)

        Parameters
        ----------
        request : MembershipRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MembershipResponse

        Examples
        --------
        from abvdev import MembershipRequest, MembershipRole
        from abvdev.client import FernABV

        client = FernABV(
            x_abv_sdk_name="YOUR_X_ABV_SDK_NAME",
            x_abv_sdk_version="YOUR_X_ABV_SDK_VERSION",
            x_abv_public_key="YOUR_X_ABV_PUBLIC_KEY",
            username="YOUR_USERNAME",
            password="YOUR_PASSWORD",
            base_url="https://yourhost.com/path/to/api",
        )
        client.organizations.update_organization_membership(
            request=MembershipRequest(
                user_id="userId",
                role=MembershipRole.OWNER,
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/public/organizations/memberships",
            method="PUT",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(MembershipResponse, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise Error(pydantic_v1.parse_obj_as(typing.Any, _response.json()))  # type: ignore
            if _response.status_code == 401:
                raise UnauthorizedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 403:
                raise AccessDeniedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_project_memberships(
        self,
        project_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MembershipsResponse:
        """
        Get all memberships for a specific project (requires organization-scoped API key)

        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MembershipsResponse

        Examples
        --------
        from abvdev.client import FernABV

        client = FernABV(
            x_abv_sdk_name="YOUR_X_ABV_SDK_NAME",
            x_abv_sdk_version="YOUR_X_ABV_SDK_VERSION",
            x_abv_public_key="YOUR_X_ABV_PUBLIC_KEY",
            username="YOUR_USERNAME",
            password="YOUR_PASSWORD",
            base_url="https://yourhost.com/path/to/api",
        )
        client.organizations.get_project_memberships(
            project_id="projectId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/public/projects/{jsonable_encoder(project_id)}/memberships",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(MembershipsResponse, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise Error(pydantic_v1.parse_obj_as(typing.Any, _response.json()))  # type: ignore
            if _response.status_code == 401:
                raise UnauthorizedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 403:
                raise AccessDeniedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_project_membership(
        self,
        project_id: str,
        *,
        request: MembershipRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MembershipResponse:
        """
        Create or update a membership for a specific project (requires organization-scoped API key). The user must already be a member of the organization.

        Parameters
        ----------
        project_id : str

        request : MembershipRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MembershipResponse

        Examples
        --------
        from abvdev import MembershipRequest, MembershipRole
        from abvdev.client import FernABV

        client = FernABV(
            x_abv_sdk_name="YOUR_X_ABV_SDK_NAME",
            x_abv_sdk_version="YOUR_X_ABV_SDK_VERSION",
            x_abv_public_key="YOUR_X_ABV_PUBLIC_KEY",
            username="YOUR_USERNAME",
            password="YOUR_PASSWORD",
            base_url="https://yourhost.com/path/to/api",
        )
        client.organizations.update_project_membership(
            project_id="projectId",
            request=MembershipRequest(
                user_id="userId",
                role=MembershipRole.OWNER,
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/public/projects/{jsonable_encoder(project_id)}/memberships",
            method="PUT",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(MembershipResponse, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise Error(pydantic_v1.parse_obj_as(typing.Any, _response.json()))  # type: ignore
            if _response.status_code == 401:
                raise UnauthorizedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 403:
                raise AccessDeniedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_organization_projects(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> OrganizationProjectsResponse:
        """
        Get all projects for the organization associated with the API key (requires organization-scoped API key)

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationProjectsResponse

        Examples
        --------
        from abvdev.client import FernABV

        client = FernABV(
            x_abv_sdk_name="YOUR_X_ABV_SDK_NAME",
            x_abv_sdk_version="YOUR_X_ABV_SDK_VERSION",
            x_abv_public_key="YOUR_X_ABV_PUBLIC_KEY",
            username="YOUR_USERNAME",
            password="YOUR_PASSWORD",
            base_url="https://yourhost.com/path/to/api",
        )
        client.organizations.get_organization_projects()
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/public/organizations/projects",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(
                    OrganizationProjectsResponse, _response.json()
                )  # type: ignore
            if _response.status_code == 400:
                raise Error(pydantic_v1.parse_obj_as(typing.Any, _response.json()))  # type: ignore
            if _response.status_code == 401:
                raise UnauthorizedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 403:
                raise AccessDeniedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncOrganizationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_organization_memberships(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MembershipsResponse:
        """
        Get all memberships for the organization associated with the API key (requires organization-scoped API key)

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MembershipsResponse

        Examples
        --------
        import asyncio

        from abvdev.client import AsyncFernABV

        client = AsyncFernABV(
            x_abv_sdk_name="YOUR_X_ABV_SDK_NAME",
            x_abv_sdk_version="YOUR_X_ABV_SDK_VERSION",
            x_abv_public_key="YOUR_X_ABV_PUBLIC_KEY",
            username="YOUR_USERNAME",
            password="YOUR_PASSWORD",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.organizations.get_organization_memberships()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/public/organizations/memberships",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(MembershipsResponse, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise Error(pydantic_v1.parse_obj_as(typing.Any, _response.json()))  # type: ignore
            if _response.status_code == 401:
                raise UnauthorizedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 403:
                raise AccessDeniedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_organization_membership(
        self,
        *,
        request: MembershipRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MembershipResponse:
        """
        Create or update a membership for the organization associated with the API key (requires organization-scoped API key)

        Parameters
        ----------
        request : MembershipRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MembershipResponse

        Examples
        --------
        import asyncio

        from abvdev import MembershipRequest, MembershipRole
        from abvdev.client import AsyncFernABV

        client = AsyncFernABV(
            x_abv_sdk_name="YOUR_X_ABV_SDK_NAME",
            x_abv_sdk_version="YOUR_X_ABV_SDK_VERSION",
            x_abv_public_key="YOUR_X_ABV_PUBLIC_KEY",
            username="YOUR_USERNAME",
            password="YOUR_PASSWORD",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.organizations.update_organization_membership(
                request=MembershipRequest(
                    user_id="userId",
                    role=MembershipRole.OWNER,
                ),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/public/organizations/memberships",
            method="PUT",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(MembershipResponse, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise Error(pydantic_v1.parse_obj_as(typing.Any, _response.json()))  # type: ignore
            if _response.status_code == 401:
                raise UnauthorizedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 403:
                raise AccessDeniedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_project_memberships(
        self,
        project_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MembershipsResponse:
        """
        Get all memberships for a specific project (requires organization-scoped API key)

        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MembershipsResponse

        Examples
        --------
        import asyncio

        from abvdev.client import AsyncFernABV

        client = AsyncFernABV(
            x_abv_sdk_name="YOUR_X_ABV_SDK_NAME",
            x_abv_sdk_version="YOUR_X_ABV_SDK_VERSION",
            x_abv_public_key="YOUR_X_ABV_PUBLIC_KEY",
            username="YOUR_USERNAME",
            password="YOUR_PASSWORD",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.organizations.get_project_memberships(
                project_id="projectId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/public/projects/{jsonable_encoder(project_id)}/memberships",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(MembershipsResponse, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise Error(pydantic_v1.parse_obj_as(typing.Any, _response.json()))  # type: ignore
            if _response.status_code == 401:
                raise UnauthorizedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 403:
                raise AccessDeniedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_project_membership(
        self,
        project_id: str,
        *,
        request: MembershipRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MembershipResponse:
        """
        Create or update a membership for a specific project (requires organization-scoped API key). The user must already be a member of the organization.

        Parameters
        ----------
        project_id : str

        request : MembershipRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MembershipResponse

        Examples
        --------
        import asyncio

        from abvdev import MembershipRequest, MembershipRole
        from abvdev.client import AsyncFernABV

        client = AsyncFernABV(
            x_abv_sdk_name="YOUR_X_ABV_SDK_NAME",
            x_abv_sdk_version="YOUR_X_ABV_SDK_VERSION",
            x_abv_public_key="YOUR_X_ABV_PUBLIC_KEY",
            username="YOUR_USERNAME",
            password="YOUR_PASSWORD",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.organizations.update_project_membership(
                project_id="projectId",
                request=MembershipRequest(
                    user_id="userId",
                    role=MembershipRole.OWNER,
                ),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/public/projects/{jsonable_encoder(project_id)}/memberships",
            method="PUT",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(MembershipResponse, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise Error(pydantic_v1.parse_obj_as(typing.Any, _response.json()))  # type: ignore
            if _response.status_code == 401:
                raise UnauthorizedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 403:
                raise AccessDeniedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_organization_projects(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> OrganizationProjectsResponse:
        """
        Get all projects for the organization associated with the API key (requires organization-scoped API key)

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationProjectsResponse

        Examples
        --------
        import asyncio

        from abvdev.client import AsyncFernABV

        client = AsyncFernABV(
            x_abv_sdk_name="YOUR_X_ABV_SDK_NAME",
            x_abv_sdk_version="YOUR_X_ABV_SDK_VERSION",
            x_abv_public_key="YOUR_X_ABV_PUBLIC_KEY",
            username="YOUR_USERNAME",
            password="YOUR_PASSWORD",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.organizations.get_organization_projects()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/public/organizations/projects",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(
                    OrganizationProjectsResponse, _response.json()
                )  # type: ignore
            if _response.status_code == 400:
                raise Error(pydantic_v1.parse_obj_as(typing.Any, _response.json()))  # type: ignore
            if _response.status_code == 401:
                raise UnauthorizedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 403:
                raise AccessDeniedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(typing.Any, _response.json())
                )  # type: ignore
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
