<div align="center">
  <img src=https://github.com/Quantum-Accelerators/quacc/blob/main/docs/images/quacc_logo_wide.png width="300"><br>
</div>

# `quacc` – The Quantum Accelerator 🦆

[![codecov](https://codecov.io/gh/Quantum-Accelerators/quacc/branch/main/graph/badge.svg?token=OJaOZAH30u&precision=1)](https://codecov.io/gh/Quantum-Accelerators/quacc)
![Python - Version](https://img.shields.io/pypi/pyversions/quacc)
![PyPI - Version](https://img.shields.io/pypi/v/quacc?color=blue&link=https%3A%2F%2Fpypi.org%2Fproject%2Fquacc%2F)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.7720998.svg)](https://doi.org/10.5281/zenodo.7720998)

`quacc` is a flexible platform for computational materials science 💎 and quantum chemistry 🧪 that is built for the big data era 🔥. It is maintained by the [Rosen Research Group](https://rosen.cbe.princeton.edu/) at Princeton University.

- `quacc` makes it possible to easily run pre-made [computational materials science workflows](https://quantum-accelerators.github.io/quacc/user/recipes/recipes_list.html) that can be efficiently dispatched anywhere: locally, HPC, the cloud, or any combination thereof.

- `quacc` gives you the freedom of choice. Through a single, unified interface to several [workflow management solutions](https://quantum-accelerators.github.io/quacc/user/basics/wflow_overview.html), you can use what best suits your unique computing needs.

- `quacc` leverages community resources so we don't reinvent the wheel. It is built around the Atomic Simulation Environment and much of the software infrastructure powering the Materials Project.

## Documentation 📖

<p align="center">
     <a href="https://quantum-accelerators.github.io/quacc/"><b><i>Learn More Here!</i></b></a>
</p>

... or skip to one of the following sections:

- 🔧 [Installation Guide](https://quantum-accelerators.github.io/quacc/install/install.html)
- 🧠 [User Guide](https://quantum-accelerators.github.io/quacc/user/recipes/recipes_intro.html)
- 🤝 [Developer Guide](https://quantum-accelerators.github.io/quacc/dev/contributing.html)

## Citation 📝

If you use `quacc` in your work, please cite it as follows:

- quacc – The Quantum Accelerator, https://doi.org/10.5281/zenodo.7720998.

## License ⚖️

`quacc` is released under a [BSD 3-Clause license](https://github.com/quantum-accelerators/quacc/blob/main/LICENSE.md).
