from android.view import KeyEvent

from toga.keys import Key

KEYEVENT_KEYS = {
    KeyEvent.KEYCODE_ESCAPE: Key.ESCAPE,
    KeyEvent.KEYCODE_F1: Key.F1,
    KeyEvent.KEYCODE_F2: Key.F2,
    KeyEvent.KEYCODE_F3: Key.F3,
    KeyEvent.KEYCODE_F4: Key.F4,
    KeyEvent.KEYCODE_F5: Key.F5,
    KeyEvent.KEYCODE_F6: Key.F6,
    KeyEvent.KEYCODE_F7: Key.F7,
    KeyEvent.KEYCODE_F8: Key.F8,
    KeyEvent.KEYCODE_F9: Key.F9,
    KeyEvent.KEYCODE_F10: Key.F10,
    KeyEvent.KEYCODE_F11: Key.F11,
    KeyEvent.KEYCODE_F12: Key.F12,
    # TODO Find matching key
    # KeyEvent.KEY_quoteleft: Key.BACK_QUOTE,
    KeyEvent.KEYCODE_1: Key._1,
    KeyEvent.KEYCODE_2: Key._2,
    KeyEvent.KEYCODE_3: Key._3,
    KeyEvent.KEYCODE_4: Key._4,
    KeyEvent.KEYCODE_5: Key._5,
    KeyEvent.KEYCODE_6: Key._6,
    KeyEvent.KEYCODE_7: Key._7,
    KeyEvent.KEYCODE_8: Key._8,
    KeyEvent.KEYCODE_9: Key._9,
    KeyEvent.KEYCODE_0: Key._0,
    # TODO Create handling for num row special keys
    # KeyEvent.KEYCODE_MINUS: Key.MINUS,
    # KeyEvent.KEYCODE_EQUALS: Key.EQUAL,
    # KeyEvent.KEYCODE_DEL: Key.BACKSPACE,
    # KeyEvent.KEY_asciitilde: Key.TILDE,
    # KeyEvent.KEY_exclam: Key.EXCLAMATION,
    # KeyEvent.KEYCODE_AT: Key.AT,
    # KeyEvent.KEY_numbersign: Key.HASH,
    # KeyEvent.KEY_dollar: Key.DOLLAR,
    # KeyEvent.KEY_percent: Key.PERCENT,
    # KeyEvent.KEY_asciicircum: Key.CARET,
    # KeyEvent.KEY_ampersand: Key.AMPERSAND,
    # KeyEvent.KEYCODE_STAR: Key.ASTERISK,
    # KeyEvent.KEY_parenleft: Key.OPEN_PARENTHESIS,
    # KeyEvent.KEY_parenright: Key.CLOSE_PARENTHESIS,
    # KeyEvent.KEY_underscore: Key.UNDERSCORE,
    # KeyEvent.KEY_plus: Key.PLUS,
    KeyEvent.KEYCODE_A: Key.A,
    KeyEvent.KEYCODE_B: Key.B,
    KeyEvent.KEYCODE_C: Key.C,
    KeyEvent.KEYCODE_D: Key.D,
    KeyEvent.KEYCODE_E: Key.E,
    KeyEvent.KEYCODE_F: Key.F,
    KeyEvent.KEYCODE_G: Key.G,
    KeyEvent.KEYCODE_H: Key.H,
    KeyEvent.KEYCODE_I: Key.I,
    KeyEvent.KEYCODE_J: Key.J,
    KeyEvent.KEYCODE_K: Key.K,
    KeyEvent.KEYCODE_L: Key.L,
    KeyEvent.KEYCODE_M: Key.M,
    KeyEvent.KEYCODE_N: Key.N,
    KeyEvent.KEYCODE_O: Key.O,
    KeyEvent.KEYCODE_P: Key.P,
    KeyEvent.KEYCODE_Q: Key.Q,
    KeyEvent.KEYCODE_R: Key.R,
    KeyEvent.KEYCODE_S: Key.S,
    KeyEvent.KEYCODE_T: Key.T,
    KeyEvent.KEYCODE_U: Key.U,
    KeyEvent.KEYCODE_V: Key.V,
    KeyEvent.KEYCODE_W: Key.W,
    KeyEvent.KEYCODE_X: Key.X,
    KeyEvent.KEYCODE_Y: Key.Y,
    KeyEvent.KEYCODE_Z: Key.Z,
    KeyEvent.KEYCODE_TAB: Key.TAB,
    # TODO Create handling for num row special keys
    # KeyEvent.KEYCODE_LEFT_BRACKET: Key.OPEN_BRACKET,
    # KeyEvent.KEYCODE_RIGHT_BRACKET: Key.CLOSE_BRACKET,
    # KeyEvent.KEYCODE_BACKSLASH: Key.BACKSLASH,
    # KeyEvent.KEY_braceleft: Key.OPEN_BRACE,
    # KeyEvent.KEY_braceright: Key.CLOSE_BRACE,
    # KeyEvent.KEY_bar: Key.PIPE,
    # KeyEvent.KEY_semicolon: Key.SEMICOLON,
    # KeyEvent.KEY_apostrophe: Key.QUOTE,
    KeyEvent.KEYCODE_ENTER: Key.ENTER,
    # TODO Create handling for num row special keys
    # KeyEvent.KEY_colon: Key.COLON,
    # KeyEvent.KEY_quotedbl: Key.DOUBLE_QUOTE,
    # KeyEvent.KEY_comma: Key.COMMA,
    # KeyEvent.KEY_period: Key.FULL_STOP,
    # KeyEvent.KEY_slash: Key.SLASH,
    # KeyEvent.KEY_less: Key.LESS_THAN,
    # KeyEvent.KEY_greater: Key.GREATER_THAN,
    # KeyEvent.KEY_question: Key.QUESTION,
    KeyEvent.KEYCODE_FORWARD_DEL: Key.DELETE,
    KeyEvent.KEYCODE_MOVE_HOME: Key.HOME,
    KeyEvent.KEYCODE_MOVE_END: Key.END,
    KeyEvent.KEYCODE_PAGE_UP: Key.PAGE_UP,
    KeyEvent.KEYCODE_PAGE_DOWN: Key.PAGE_DOWN,
    KeyEvent.KEYCODE_DPAD_LEFT: Key.LEFT,
    KeyEvent.KEYCODE_DPAD_RIGHT: Key.RIGHT,
    KeyEvent.KEYCODE_DPAD_UP: Key.UP,
    KeyEvent.KEYCODE_DPAD_DOWN: Key.DOWN,
    KeyEvent.KEYCODE_NUMPAD_ENTER: Key.NUMPAD_ENTER,
}

# # TODO: Confirm these codes are all correct - especially the special keys.
KEYEVENT_KEY_CODES = {
    Key.A: "A",
    Key.B: "B",
    Key.C: "C",
    Key.D: "D",
    Key.E: "E",
    Key.F: "F",
    Key.G: "G",
    Key.H: "H",
    Key.I: "I",
    Key.J: "J",
    Key.K: "K",
    Key.L: "L",
    Key.M: "M",
    Key.N: "N",
    Key.O: "O",
    Key.P: "P",
    Key.Q: "Q",
    Key.R: "R",
    Key.S: "S",
    Key.T: "T",
    Key.U: "U",
    Key.V: "V",
    Key.W: "W",
    Key.X: "X",
    Key.Y: "Y",
    Key.Z: "Z",
    Key.ESCAPE: "Escape",
    Key.TAB: "Tab",
    Key.BACKSPACE: "Backspace",
    Key.ENTER: "Enter",
    Key.F1: "F1",
    Key.F2: "F2",
    Key.F3: "F3",
    Key.F4: "F4",
    Key.F5: "F5",
    Key.F6: "F6",
    Key.F7: "F7",
    Key.F8: "F8",
    Key.F9: "F9",
    Key.F10: "F10",
    Key.F11: "F11",
    Key.F12: "F12",
    Key.F13: "F13",
    Key.F14: "F14",
    Key.F15: "F15",
    Key.F16: "F16",
    Key.F17: "F17",
    Key.F18: "F18",
    Key.F19: "F19",
    # Key.EJECT: '',
    Key.HOME: "Home",
    Key.END: "End",
    Key.DELETE: "Del",
    Key.PAGE_UP: "PgUp",
    Key.PAGE_DOWN: "PgDn",
    Key.UP: "Up",
    Key.DOWN: "Down",
    Key.LEFT: "Left",
    Key.RIGHT: "Right",
    Key.NUMPAD_0: "0",
    Key.NUMPAD_1: "1",
    Key.NUMPAD_2: "2",
    Key.NUMPAD_3: "3",
    Key.NUMPAD_4: "4",
    Key.NUMPAD_5: "5",
    Key.NUMPAD_6: "6",
    Key.NUMPAD_7: "7",
    Key.NUMPAD_8: "8",
    Key.NUMPAD_9: "9",
    # Key.NUMPAD_CLEAR: '',
    Key.NUMPAD_DECIMAL_POINT: ".",
    Key.NUMPAD_DIVIDE: "/",
    Key.NUMPAD_ENTER: "",
    Key.NUMPAD_EQUAL: "=",
    Key.NUMPAD_MINUS: "-",
    Key.NUMPAD_MULTIPLY: "*",
    Key.NUMPAD_PLUS: "+",
}
#
KEYEVENT_MODIFIER_CODES = {
    Key.CAPSLOCK: "<CapsLock>",
    Key.SHIFT: "<Shift>",
    # TODO: Confirm the mapping of Control, Meta and Hyper are correct.
    Key.MOD_1: "<Ctrl>",
    Key.MOD_2: "<Alt>",
}


def toga_key(event):
    """Convert a android Key Event into a Toga key."""
    try:
        key = KEYEVENT_KEYS[event.getKeyCode()]

        modifiers = set()

        # TODO: Confirm the mapping of Control, Meta and Hyper are correct.
        if event.isCapsLockOn():
            modifiers.add(Key.CAPSLOCK)  # pragma: no cover
        if event.isShiftPressed():
            modifiers.add(Key.SHIFT)  # pragma: no cover
        if event.isCtrlPressed():
            modifiers.add(Key.MOD_1)  # pragma: no cover
        if event.isAltPressed():
            modifiers.add(Key.MOD_2)  # pragma: no cover

        return {"key": key, "modifiers": modifiers}
    except KeyError:  # pragma: nocover
        return None
