# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc
import warnings

from . import commit_pb2 as commit__pb2

GRPC_GENERATED_VERSION = '1.63.2'
GRPC_VERSION = grpc.__version__
EXPECTED_ERROR_RELEASE = '1.65.0'
SCHEDULED_RELEASE_DATE = 'June 25, 2024'
_version_not_supported = False

try:
    from grpc._utilities import first_version_is_lower
    _version_not_supported = first_version_is_lower(GRPC_VERSION, GRPC_GENERATED_VERSION)
except ImportError:
    _version_not_supported = True

if _version_not_supported:
    warnings.warn(
        f'The grpc package installed is at version {GRPC_VERSION},'
        + f' but the generated code in commit_pb2_grpc.py depends on'
        + f' grpcio>={GRPC_GENERATED_VERSION}.'
        + f' Please upgrade your grpc module to grpcio>={GRPC_GENERATED_VERSION}'
        + f' or downgrade your generated code using grpcio-tools<={GRPC_VERSION}.'
        + f' This warning will become an error in {EXPECTED_ERROR_RELEASE},'
        + f' scheduled for release on {SCHEDULED_RELEASE_DATE}.',
        RuntimeWarning
    )


class CommitServiceStub(object):
    """CommitService is a service which provides RPCs that interact with Git
    commits.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.ListCommits = channel.unary_stream(
                '/gitaly.CommitService/ListCommits',
                request_serializer=commit__pb2.ListCommitsRequest.SerializeToString,
                response_deserializer=commit__pb2.ListCommitsResponse.FromString,
                _registered_method=True)
        self.ListAllCommits = channel.unary_stream(
                '/gitaly.CommitService/ListAllCommits',
                request_serializer=commit__pb2.ListAllCommitsRequest.SerializeToString,
                response_deserializer=commit__pb2.ListAllCommitsResponse.FromString,
                _registered_method=True)
        self.CommitIsAncestor = channel.unary_unary(
                '/gitaly.CommitService/CommitIsAncestor',
                request_serializer=commit__pb2.CommitIsAncestorRequest.SerializeToString,
                response_deserializer=commit__pb2.CommitIsAncestorResponse.FromString,
                _registered_method=True)
        self.TreeEntry = channel.unary_stream(
                '/gitaly.CommitService/TreeEntry',
                request_serializer=commit__pb2.TreeEntryRequest.SerializeToString,
                response_deserializer=commit__pb2.TreeEntryResponse.FromString,
                _registered_method=True)
        self.CountCommits = channel.unary_unary(
                '/gitaly.CommitService/CountCommits',
                request_serializer=commit__pb2.CountCommitsRequest.SerializeToString,
                response_deserializer=commit__pb2.CountCommitsResponse.FromString,
                _registered_method=True)
        self.CountDivergingCommits = channel.unary_unary(
                '/gitaly.CommitService/CountDivergingCommits',
                request_serializer=commit__pb2.CountDivergingCommitsRequest.SerializeToString,
                response_deserializer=commit__pb2.CountDivergingCommitsResponse.FromString,
                _registered_method=True)
        self.GetTreeEntries = channel.unary_stream(
                '/gitaly.CommitService/GetTreeEntries',
                request_serializer=commit__pb2.GetTreeEntriesRequest.SerializeToString,
                response_deserializer=commit__pb2.GetTreeEntriesResponse.FromString,
                _registered_method=True)
        self.ListFiles = channel.unary_stream(
                '/gitaly.CommitService/ListFiles',
                request_serializer=commit__pb2.ListFilesRequest.SerializeToString,
                response_deserializer=commit__pb2.ListFilesResponse.FromString,
                _registered_method=True)
        self.FindCommit = channel.unary_unary(
                '/gitaly.CommitService/FindCommit',
                request_serializer=commit__pb2.FindCommitRequest.SerializeToString,
                response_deserializer=commit__pb2.FindCommitResponse.FromString,
                _registered_method=True)
        self.CommitStats = channel.unary_unary(
                '/gitaly.CommitService/CommitStats',
                request_serializer=commit__pb2.CommitStatsRequest.SerializeToString,
                response_deserializer=commit__pb2.CommitStatsResponse.FromString,
                _registered_method=True)
        self.FindAllCommits = channel.unary_stream(
                '/gitaly.CommitService/FindAllCommits',
                request_serializer=commit__pb2.FindAllCommitsRequest.SerializeToString,
                response_deserializer=commit__pb2.FindAllCommitsResponse.FromString,
                _registered_method=True)
        self.FindCommits = channel.unary_stream(
                '/gitaly.CommitService/FindCommits',
                request_serializer=commit__pb2.FindCommitsRequest.SerializeToString,
                response_deserializer=commit__pb2.FindCommitsResponse.FromString,
                _registered_method=True)
        self.CommitLanguages = channel.unary_unary(
                '/gitaly.CommitService/CommitLanguages',
                request_serializer=commit__pb2.CommitLanguagesRequest.SerializeToString,
                response_deserializer=commit__pb2.CommitLanguagesResponse.FromString,
                _registered_method=True)
        self.RawBlame = channel.unary_stream(
                '/gitaly.CommitService/RawBlame',
                request_serializer=commit__pb2.RawBlameRequest.SerializeToString,
                response_deserializer=commit__pb2.RawBlameResponse.FromString,
                _registered_method=True)
        self.LastCommitForPath = channel.unary_unary(
                '/gitaly.CommitService/LastCommitForPath',
                request_serializer=commit__pb2.LastCommitForPathRequest.SerializeToString,
                response_deserializer=commit__pb2.LastCommitForPathResponse.FromString,
                _registered_method=True)
        self.ListLastCommitsForTree = channel.unary_stream(
                '/gitaly.CommitService/ListLastCommitsForTree',
                request_serializer=commit__pb2.ListLastCommitsForTreeRequest.SerializeToString,
                response_deserializer=commit__pb2.ListLastCommitsForTreeResponse.FromString,
                _registered_method=True)
        self.CommitsByMessage = channel.unary_stream(
                '/gitaly.CommitService/CommitsByMessage',
                request_serializer=commit__pb2.CommitsByMessageRequest.SerializeToString,
                response_deserializer=commit__pb2.CommitsByMessageResponse.FromString,
                _registered_method=True)
        self.ListCommitsByOid = channel.unary_stream(
                '/gitaly.CommitService/ListCommitsByOid',
                request_serializer=commit__pb2.ListCommitsByOidRequest.SerializeToString,
                response_deserializer=commit__pb2.ListCommitsByOidResponse.FromString,
                _registered_method=True)
        self.ListCommitsByRefName = channel.unary_stream(
                '/gitaly.CommitService/ListCommitsByRefName',
                request_serializer=commit__pb2.ListCommitsByRefNameRequest.SerializeToString,
                response_deserializer=commit__pb2.ListCommitsByRefNameResponse.FromString,
                _registered_method=True)
        self.FilterShasWithSignatures = channel.stream_stream(
                '/gitaly.CommitService/FilterShasWithSignatures',
                request_serializer=commit__pb2.FilterShasWithSignaturesRequest.SerializeToString,
                response_deserializer=commit__pb2.FilterShasWithSignaturesResponse.FromString,
                _registered_method=True)
        self.GetCommitSignatures = channel.unary_stream(
                '/gitaly.CommitService/GetCommitSignatures',
                request_serializer=commit__pb2.GetCommitSignaturesRequest.SerializeToString,
                response_deserializer=commit__pb2.GetCommitSignaturesResponse.FromString,
                _registered_method=True)
        self.GetCommitMessages = channel.unary_stream(
                '/gitaly.CommitService/GetCommitMessages',
                request_serializer=commit__pb2.GetCommitMessagesRequest.SerializeToString,
                response_deserializer=commit__pb2.GetCommitMessagesResponse.FromString,
                _registered_method=True)
        self.CheckObjectsExist = channel.stream_stream(
                '/gitaly.CommitService/CheckObjectsExist',
                request_serializer=commit__pb2.CheckObjectsExistRequest.SerializeToString,
                response_deserializer=commit__pb2.CheckObjectsExistResponse.FromString,
                _registered_method=True)


class CommitServiceServicer(object):
    """CommitService is a service which provides RPCs that interact with Git
    commits.
    """

    def ListCommits(self, request, context):
        """ListCommits lists all commits reachable via a set of references by doing a
        graph walk. This deprecates FindAllCommits and FindCommits (except Follow
        is not yet supported). Any unknown revisions will cause the RPC to fail.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListAllCommits(self, request, context):
        """ListAllCommits lists all commits present in the repository, including
        those not reachable by any reference.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CommitIsAncestor(self, request, context):
        """CommitIsAncestor checks whether a provided commit is the ancestor of
        another commit.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def TreeEntry(self, request, context):
        """TreeEntry provides the tree entry for the provided path and revision. The data
        is broken into chunks and streamed.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CountCommits(self, request, context):
        """CountCommits provides the number of commits which adhere to the given filters.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CountDivergingCommits(self, request, context):
        """CountDivergingCommits provides the number of diverging commits between two revisions.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetTreeEntries(self, request, context):
        """GetTreeEntries provides the tree entries for the provided path and revision. This includes
        subtrees present under the tree with the option of recursive fetching.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListFiles(self, request, context):
        """ListFiles lists all the files (including files in sub-dirs) present in the working tree
        of a given treeish.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FindCommit(self, request, context):
        """FindCommit finds a commit for a given commitish. Returns nil if the commit is not found.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CommitStats(self, request, context):
        """CommitStats provides the stats for a given commitish.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FindAllCommits(self, request, context):
        """FindAllCommits lists all the commits which can be traversed from the
        provided commitish.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FindCommits(self, request, context):
        """FindCommits lists all the commits which are associated with the provided revision
        and paths.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CommitLanguages(self, request, context):
        """CommitLanguages detects the source code languages of the whole tree for a
        given commit. Returns an error in case no languages could be detected.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RawBlame(self, request, context):
        """RawBlame blames lines in a blob to when they have last been changed. Returns the raw output of the git-blame(1)
        command.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def LastCommitForPath(self, request, context):
        """LastCommitForPath returns the last commit that has changed a given path.

        The following special cases apply and have grown historically:

        - Absolute paths that or relative paths that escape the repository root will cause an error.
        - A nonexistent path inside the repository leads to a successful but empty response.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListLastCommitsForTree(self, request, context):
        """ListLastCommitsForTree lists the last commits for a given tree.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CommitsByMessage(self, request, context):
        """CommitsByMessage list commits which match the provided query.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListCommitsByOid(self, request, context):
        """ListCommitsByOid lists the commits for the provided commitish object IDs.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListCommitsByRefName(self, request, context):
        """ListCommitsByRefName lists the commits for the provided references.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FilterShasWithSignatures(self, request_iterator, context):
        """FilterShasWithSignatures filters out signed commits.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetCommitSignatures(self, request, context):
        """GetCommitSignatures parses the commit signature information for the provided commitish object IDs.
        The RPC doesn't use 'mailmap' to ensure that signature verification is done against the original
        information which contains the non-mapped commit author.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetCommitMessages(self, request, context):
        """GetCommitMessages returns the commits messages for the provided commitish object IDs.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CheckObjectsExist(self, request_iterator, context):
        """CheckObjectsExist will check for the existence of revisions against a
        repository. It returns two sets of data. An array containing the revisions
        from the input that it found on the repository, and an array that contains all
        revisions from the input it did not find on the repository.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_CommitServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'ListCommits': grpc.unary_stream_rpc_method_handler(
                    servicer.ListCommits,
                    request_deserializer=commit__pb2.ListCommitsRequest.FromString,
                    response_serializer=commit__pb2.ListCommitsResponse.SerializeToString,
            ),
            'ListAllCommits': grpc.unary_stream_rpc_method_handler(
                    servicer.ListAllCommits,
                    request_deserializer=commit__pb2.ListAllCommitsRequest.FromString,
                    response_serializer=commit__pb2.ListAllCommitsResponse.SerializeToString,
            ),
            'CommitIsAncestor': grpc.unary_unary_rpc_method_handler(
                    servicer.CommitIsAncestor,
                    request_deserializer=commit__pb2.CommitIsAncestorRequest.FromString,
                    response_serializer=commit__pb2.CommitIsAncestorResponse.SerializeToString,
            ),
            'TreeEntry': grpc.unary_stream_rpc_method_handler(
                    servicer.TreeEntry,
                    request_deserializer=commit__pb2.TreeEntryRequest.FromString,
                    response_serializer=commit__pb2.TreeEntryResponse.SerializeToString,
            ),
            'CountCommits': grpc.unary_unary_rpc_method_handler(
                    servicer.CountCommits,
                    request_deserializer=commit__pb2.CountCommitsRequest.FromString,
                    response_serializer=commit__pb2.CountCommitsResponse.SerializeToString,
            ),
            'CountDivergingCommits': grpc.unary_unary_rpc_method_handler(
                    servicer.CountDivergingCommits,
                    request_deserializer=commit__pb2.CountDivergingCommitsRequest.FromString,
                    response_serializer=commit__pb2.CountDivergingCommitsResponse.SerializeToString,
            ),
            'GetTreeEntries': grpc.unary_stream_rpc_method_handler(
                    servicer.GetTreeEntries,
                    request_deserializer=commit__pb2.GetTreeEntriesRequest.FromString,
                    response_serializer=commit__pb2.GetTreeEntriesResponse.SerializeToString,
            ),
            'ListFiles': grpc.unary_stream_rpc_method_handler(
                    servicer.ListFiles,
                    request_deserializer=commit__pb2.ListFilesRequest.FromString,
                    response_serializer=commit__pb2.ListFilesResponse.SerializeToString,
            ),
            'FindCommit': grpc.unary_unary_rpc_method_handler(
                    servicer.FindCommit,
                    request_deserializer=commit__pb2.FindCommitRequest.FromString,
                    response_serializer=commit__pb2.FindCommitResponse.SerializeToString,
            ),
            'CommitStats': grpc.unary_unary_rpc_method_handler(
                    servicer.CommitStats,
                    request_deserializer=commit__pb2.CommitStatsRequest.FromString,
                    response_serializer=commit__pb2.CommitStatsResponse.SerializeToString,
            ),
            'FindAllCommits': grpc.unary_stream_rpc_method_handler(
                    servicer.FindAllCommits,
                    request_deserializer=commit__pb2.FindAllCommitsRequest.FromString,
                    response_serializer=commit__pb2.FindAllCommitsResponse.SerializeToString,
            ),
            'FindCommits': grpc.unary_stream_rpc_method_handler(
                    servicer.FindCommits,
                    request_deserializer=commit__pb2.FindCommitsRequest.FromString,
                    response_serializer=commit__pb2.FindCommitsResponse.SerializeToString,
            ),
            'CommitLanguages': grpc.unary_unary_rpc_method_handler(
                    servicer.CommitLanguages,
                    request_deserializer=commit__pb2.CommitLanguagesRequest.FromString,
                    response_serializer=commit__pb2.CommitLanguagesResponse.SerializeToString,
            ),
            'RawBlame': grpc.unary_stream_rpc_method_handler(
                    servicer.RawBlame,
                    request_deserializer=commit__pb2.RawBlameRequest.FromString,
                    response_serializer=commit__pb2.RawBlameResponse.SerializeToString,
            ),
            'LastCommitForPath': grpc.unary_unary_rpc_method_handler(
                    servicer.LastCommitForPath,
                    request_deserializer=commit__pb2.LastCommitForPathRequest.FromString,
                    response_serializer=commit__pb2.LastCommitForPathResponse.SerializeToString,
            ),
            'ListLastCommitsForTree': grpc.unary_stream_rpc_method_handler(
                    servicer.ListLastCommitsForTree,
                    request_deserializer=commit__pb2.ListLastCommitsForTreeRequest.FromString,
                    response_serializer=commit__pb2.ListLastCommitsForTreeResponse.SerializeToString,
            ),
            'CommitsByMessage': grpc.unary_stream_rpc_method_handler(
                    servicer.CommitsByMessage,
                    request_deserializer=commit__pb2.CommitsByMessageRequest.FromString,
                    response_serializer=commit__pb2.CommitsByMessageResponse.SerializeToString,
            ),
            'ListCommitsByOid': grpc.unary_stream_rpc_method_handler(
                    servicer.ListCommitsByOid,
                    request_deserializer=commit__pb2.ListCommitsByOidRequest.FromString,
                    response_serializer=commit__pb2.ListCommitsByOidResponse.SerializeToString,
            ),
            'ListCommitsByRefName': grpc.unary_stream_rpc_method_handler(
                    servicer.ListCommitsByRefName,
                    request_deserializer=commit__pb2.ListCommitsByRefNameRequest.FromString,
                    response_serializer=commit__pb2.ListCommitsByRefNameResponse.SerializeToString,
            ),
            'FilterShasWithSignatures': grpc.stream_stream_rpc_method_handler(
                    servicer.FilterShasWithSignatures,
                    request_deserializer=commit__pb2.FilterShasWithSignaturesRequest.FromString,
                    response_serializer=commit__pb2.FilterShasWithSignaturesResponse.SerializeToString,
            ),
            'GetCommitSignatures': grpc.unary_stream_rpc_method_handler(
                    servicer.GetCommitSignatures,
                    request_deserializer=commit__pb2.GetCommitSignaturesRequest.FromString,
                    response_serializer=commit__pb2.GetCommitSignaturesResponse.SerializeToString,
            ),
            'GetCommitMessages': grpc.unary_stream_rpc_method_handler(
                    servicer.GetCommitMessages,
                    request_deserializer=commit__pb2.GetCommitMessagesRequest.FromString,
                    response_serializer=commit__pb2.GetCommitMessagesResponse.SerializeToString,
            ),
            'CheckObjectsExist': grpc.stream_stream_rpc_method_handler(
                    servicer.CheckObjectsExist,
                    request_deserializer=commit__pb2.CheckObjectsExistRequest.FromString,
                    response_serializer=commit__pb2.CheckObjectsExistResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'gitaly.CommitService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class CommitService(object):
    """CommitService is a service which provides RPCs that interact with Git
    commits.
    """

    @staticmethod
    def ListCommits(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.CommitService/ListCommits',
            commit__pb2.ListCommitsRequest.SerializeToString,
            commit__pb2.ListCommitsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListAllCommits(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.CommitService/ListAllCommits',
            commit__pb2.ListAllCommitsRequest.SerializeToString,
            commit__pb2.ListAllCommitsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CommitIsAncestor(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.CommitService/CommitIsAncestor',
            commit__pb2.CommitIsAncestorRequest.SerializeToString,
            commit__pb2.CommitIsAncestorResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def TreeEntry(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.CommitService/TreeEntry',
            commit__pb2.TreeEntryRequest.SerializeToString,
            commit__pb2.TreeEntryResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CountCommits(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.CommitService/CountCommits',
            commit__pb2.CountCommitsRequest.SerializeToString,
            commit__pb2.CountCommitsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CountDivergingCommits(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.CommitService/CountDivergingCommits',
            commit__pb2.CountDivergingCommitsRequest.SerializeToString,
            commit__pb2.CountDivergingCommitsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetTreeEntries(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.CommitService/GetTreeEntries',
            commit__pb2.GetTreeEntriesRequest.SerializeToString,
            commit__pb2.GetTreeEntriesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListFiles(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.CommitService/ListFiles',
            commit__pb2.ListFilesRequest.SerializeToString,
            commit__pb2.ListFilesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FindCommit(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.CommitService/FindCommit',
            commit__pb2.FindCommitRequest.SerializeToString,
            commit__pb2.FindCommitResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CommitStats(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.CommitService/CommitStats',
            commit__pb2.CommitStatsRequest.SerializeToString,
            commit__pb2.CommitStatsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FindAllCommits(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.CommitService/FindAllCommits',
            commit__pb2.FindAllCommitsRequest.SerializeToString,
            commit__pb2.FindAllCommitsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FindCommits(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.CommitService/FindCommits',
            commit__pb2.FindCommitsRequest.SerializeToString,
            commit__pb2.FindCommitsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CommitLanguages(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.CommitService/CommitLanguages',
            commit__pb2.CommitLanguagesRequest.SerializeToString,
            commit__pb2.CommitLanguagesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def RawBlame(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.CommitService/RawBlame',
            commit__pb2.RawBlameRequest.SerializeToString,
            commit__pb2.RawBlameResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def LastCommitForPath(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.CommitService/LastCommitForPath',
            commit__pb2.LastCommitForPathRequest.SerializeToString,
            commit__pb2.LastCommitForPathResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListLastCommitsForTree(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.CommitService/ListLastCommitsForTree',
            commit__pb2.ListLastCommitsForTreeRequest.SerializeToString,
            commit__pb2.ListLastCommitsForTreeResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CommitsByMessage(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.CommitService/CommitsByMessage',
            commit__pb2.CommitsByMessageRequest.SerializeToString,
            commit__pb2.CommitsByMessageResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListCommitsByOid(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.CommitService/ListCommitsByOid',
            commit__pb2.ListCommitsByOidRequest.SerializeToString,
            commit__pb2.ListCommitsByOidResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListCommitsByRefName(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.CommitService/ListCommitsByRefName',
            commit__pb2.ListCommitsByRefNameRequest.SerializeToString,
            commit__pb2.ListCommitsByRefNameResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FilterShasWithSignatures(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_stream(
            request_iterator,
            target,
            '/gitaly.CommitService/FilterShasWithSignatures',
            commit__pb2.FilterShasWithSignaturesRequest.SerializeToString,
            commit__pb2.FilterShasWithSignaturesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetCommitSignatures(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.CommitService/GetCommitSignatures',
            commit__pb2.GetCommitSignaturesRequest.SerializeToString,
            commit__pb2.GetCommitSignaturesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetCommitMessages(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.CommitService/GetCommitMessages',
            commit__pb2.GetCommitMessagesRequest.SerializeToString,
            commit__pb2.GetCommitMessagesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CheckObjectsExist(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_stream(
            request_iterator,
            target,
            '/gitaly.CommitService/CheckObjectsExist',
            commit__pb2.CheckObjectsExistRequest.SerializeToString,
            commit__pb2.CheckObjectsExistResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
