# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FlinkStatementArgs', 'FlinkStatement']

@pulumi.input_type
class FlinkStatementArgs:
    def __init__(__self__, *,
                 statement: pulumi.Input[_builtins.str],
                 compute_pool: Optional[pulumi.Input['FlinkStatementComputePoolArgs']] = None,
                 credentials: Optional[pulumi.Input['FlinkStatementCredentialsArgs']] = None,
                 environment: Optional[pulumi.Input['FlinkStatementEnvironmentArgs']] = None,
                 organization: Optional[pulumi.Input['FlinkStatementOrganizationArgs']] = None,
                 principal: Optional[pulumi.Input['FlinkStatementPrincipalArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 properties_sensitive: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 statement_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stopped: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a FlinkStatement resource.
        :param pulumi.Input[_builtins.str] statement: The raw SQL text statement, for example, `SELECT CURRENT_TIMESTAMP;`.
        :param pulumi.Input['FlinkStatementCredentialsArgs'] credentials: The Cluster API Credentials.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: The custom topic settings to set:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties_sensitive: Block for sensitive statement properties:
        :param pulumi.Input[_builtins.str] rest_endpoint: The REST endpoint of the Flink region. For example, for public networking: `https://flink.us-east-1.aws.confluent.cloud`. In the case of private networking, the endpoint might look like `https://flink.pr1jy6.us-east-2.aws.confluent.cloud`. You can construct it using either:
               - `data.confluent_flink_region.main.private_rest_endpoint`, or
               - `https://flink${data.confluent_network.main.endpoint_suffix}`
        :param pulumi.Input[_builtins.str] statement_name: The ID of the Flink Statement, for example, `cfeab4fe-b62c-49bd-9e99-51cc98c77a67`.
        :param pulumi.Input[_builtins.bool] stopped: Indicates whether the statement should be stopped.
        """
        pulumi.set(__self__, "statement", statement)
        if compute_pool is not None:
            pulumi.set(__self__, "compute_pool", compute_pool)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if properties_sensitive is not None:
            pulumi.set(__self__, "properties_sensitive", properties_sensitive)
        if rest_endpoint is not None:
            pulumi.set(__self__, "rest_endpoint", rest_endpoint)
        if statement_name is not None:
            pulumi.set(__self__, "statement_name", statement_name)
        if stopped is not None:
            pulumi.set(__self__, "stopped", stopped)

    @_builtins.property
    @pulumi.getter
    def statement(self) -> pulumi.Input[_builtins.str]:
        """
        The raw SQL text statement, for example, `SELECT CURRENT_TIMESTAMP;`.
        """
        return pulumi.get(self, "statement")

    @statement.setter
    def statement(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "statement", value)

    @_builtins.property
    @pulumi.getter(name="computePool")
    def compute_pool(self) -> Optional[pulumi.Input['FlinkStatementComputePoolArgs']]:
        return pulumi.get(self, "compute_pool")

    @compute_pool.setter
    def compute_pool(self, value: Optional[pulumi.Input['FlinkStatementComputePoolArgs']]):
        pulumi.set(self, "compute_pool", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['FlinkStatementCredentialsArgs']]:
        """
        The Cluster API Credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['FlinkStatementCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['FlinkStatementEnvironmentArgs']]:
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['FlinkStatementEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input['FlinkStatementOrganizationArgs']]:
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input['FlinkStatementOrganizationArgs']]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input['FlinkStatementPrincipalArgs']]:
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input['FlinkStatementPrincipalArgs']]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The custom topic settings to set:
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="propertiesSensitive")
    def properties_sensitive(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Block for sensitive statement properties:
        """
        return pulumi.get(self, "properties_sensitive")

    @properties_sensitive.setter
    def properties_sensitive(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties_sensitive", value)

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The REST endpoint of the Flink region. For example, for public networking: `https://flink.us-east-1.aws.confluent.cloud`. In the case of private networking, the endpoint might look like `https://flink.pr1jy6.us-east-2.aws.confluent.cloud`. You can construct it using either:
        - `data.confluent_flink_region.main.private_rest_endpoint`, or
        - `https://flink${data.confluent_network.main.endpoint_suffix}`
        """
        return pulumi.get(self, "rest_endpoint")

    @rest_endpoint.setter
    def rest_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rest_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="statementName")
    def statement_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Flink Statement, for example, `cfeab4fe-b62c-49bd-9e99-51cc98c77a67`.
        """
        return pulumi.get(self, "statement_name")

    @statement_name.setter
    def statement_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "statement_name", value)

    @_builtins.property
    @pulumi.getter
    def stopped(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the statement should be stopped.
        """
        return pulumi.get(self, "stopped")

    @stopped.setter
    def stopped(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stopped", value)


@pulumi.input_type
class _FlinkStatementState:
    def __init__(__self__, *,
                 compute_pool: Optional[pulumi.Input['FlinkStatementComputePoolArgs']] = None,
                 credentials: Optional[pulumi.Input['FlinkStatementCredentialsArgs']] = None,
                 environment: Optional[pulumi.Input['FlinkStatementEnvironmentArgs']] = None,
                 latest_offsets: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 latest_offsets_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input['FlinkStatementOrganizationArgs']] = None,
                 principal: Optional[pulumi.Input['FlinkStatementPrincipalArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 properties_sensitive: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 statement: Optional[pulumi.Input[_builtins.str]] = None,
                 statement_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stopped: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering FlinkStatement resources.
        :param pulumi.Input['FlinkStatementCredentialsArgs'] credentials: The Cluster API Credentials.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] latest_offsets: (Optional String) The last Kafka offsets that a statement has processed. Represented by a mapping from Kafka topic to a string representation of partitions mapped to offsets. For example,
               ```bash
               "latest_offsets": {
               "topic-1": "partition:0,offset:100;partition:1,offset:200",
               "topic-2": "partition:0,offset:50"
               }
               ```
        :param pulumi.Input[_builtins.str] latest_offsets_timestamp: (Optional String) The date and time at which the Kafka topic offsets were added to the statement status. It is represented in RFC3339 format and is in UTC. For example, `2023-03-31T00:00:00-00:00`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: The custom topic settings to set:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties_sensitive: Block for sensitive statement properties:
        :param pulumi.Input[_builtins.str] rest_endpoint: The REST endpoint of the Flink region. For example, for public networking: `https://flink.us-east-1.aws.confluent.cloud`. In the case of private networking, the endpoint might look like `https://flink.pr1jy6.us-east-2.aws.confluent.cloud`. You can construct it using either:
               - `data.confluent_flink_region.main.private_rest_endpoint`, or
               - `https://flink${data.confluent_network.main.endpoint_suffix}`
        :param pulumi.Input[_builtins.str] statement: The raw SQL text statement, for example, `SELECT CURRENT_TIMESTAMP;`.
        :param pulumi.Input[_builtins.str] statement_name: The ID of the Flink Statement, for example, `cfeab4fe-b62c-49bd-9e99-51cc98c77a67`.
        :param pulumi.Input[_builtins.bool] stopped: Indicates whether the statement should be stopped.
        """
        if compute_pool is not None:
            pulumi.set(__self__, "compute_pool", compute_pool)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if latest_offsets is not None:
            pulumi.set(__self__, "latest_offsets", latest_offsets)
        if latest_offsets_timestamp is not None:
            pulumi.set(__self__, "latest_offsets_timestamp", latest_offsets_timestamp)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if properties_sensitive is not None:
            pulumi.set(__self__, "properties_sensitive", properties_sensitive)
        if rest_endpoint is not None:
            pulumi.set(__self__, "rest_endpoint", rest_endpoint)
        if statement is not None:
            pulumi.set(__self__, "statement", statement)
        if statement_name is not None:
            pulumi.set(__self__, "statement_name", statement_name)
        if stopped is not None:
            pulumi.set(__self__, "stopped", stopped)

    @_builtins.property
    @pulumi.getter(name="computePool")
    def compute_pool(self) -> Optional[pulumi.Input['FlinkStatementComputePoolArgs']]:
        return pulumi.get(self, "compute_pool")

    @compute_pool.setter
    def compute_pool(self, value: Optional[pulumi.Input['FlinkStatementComputePoolArgs']]):
        pulumi.set(self, "compute_pool", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['FlinkStatementCredentialsArgs']]:
        """
        The Cluster API Credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['FlinkStatementCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['FlinkStatementEnvironmentArgs']]:
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['FlinkStatementEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="latestOffsets")
    def latest_offsets(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Optional String) The last Kafka offsets that a statement has processed. Represented by a mapping from Kafka topic to a string representation of partitions mapped to offsets. For example,
        ```bash
        "latest_offsets": {
        "topic-1": "partition:0,offset:100;partition:1,offset:200",
        "topic-2": "partition:0,offset:50"
        }
        ```
        """
        return pulumi.get(self, "latest_offsets")

    @latest_offsets.setter
    def latest_offsets(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "latest_offsets", value)

    @_builtins.property
    @pulumi.getter(name="latestOffsetsTimestamp")
    def latest_offsets_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional String) The date and time at which the Kafka topic offsets were added to the statement status. It is represented in RFC3339 format and is in UTC. For example, `2023-03-31T00:00:00-00:00`.
        """
        return pulumi.get(self, "latest_offsets_timestamp")

    @latest_offsets_timestamp.setter
    def latest_offsets_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "latest_offsets_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input['FlinkStatementOrganizationArgs']]:
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input['FlinkStatementOrganizationArgs']]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input['FlinkStatementPrincipalArgs']]:
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input['FlinkStatementPrincipalArgs']]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The custom topic settings to set:
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="propertiesSensitive")
    def properties_sensitive(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Block for sensitive statement properties:
        """
        return pulumi.get(self, "properties_sensitive")

    @properties_sensitive.setter
    def properties_sensitive(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties_sensitive", value)

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The REST endpoint of the Flink region. For example, for public networking: `https://flink.us-east-1.aws.confluent.cloud`. In the case of private networking, the endpoint might look like `https://flink.pr1jy6.us-east-2.aws.confluent.cloud`. You can construct it using either:
        - `data.confluent_flink_region.main.private_rest_endpoint`, or
        - `https://flink${data.confluent_network.main.endpoint_suffix}`
        """
        return pulumi.get(self, "rest_endpoint")

    @rest_endpoint.setter
    def rest_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rest_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def statement(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The raw SQL text statement, for example, `SELECT CURRENT_TIMESTAMP;`.
        """
        return pulumi.get(self, "statement")

    @statement.setter
    def statement(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "statement", value)

    @_builtins.property
    @pulumi.getter(name="statementName")
    def statement_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Flink Statement, for example, `cfeab4fe-b62c-49bd-9e99-51cc98c77a67`.
        """
        return pulumi.get(self, "statement_name")

    @statement_name.setter
    def statement_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "statement_name", value)

    @_builtins.property
    @pulumi.getter
    def stopped(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the statement should be stopped.
        """
        return pulumi.get(self, "stopped")

    @stopped.setter
    def stopped(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stopped", value)


@pulumi.type_token("confluentcloud:index/flinkStatement:FlinkStatement")
class FlinkStatement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_pool: Optional[pulumi.Input[Union['FlinkStatementComputePoolArgs', 'FlinkStatementComputePoolArgsDict']]] = None,
                 credentials: Optional[pulumi.Input[Union['FlinkStatementCredentialsArgs', 'FlinkStatementCredentialsArgsDict']]] = None,
                 environment: Optional[pulumi.Input[Union['FlinkStatementEnvironmentArgs', 'FlinkStatementEnvironmentArgsDict']]] = None,
                 organization: Optional[pulumi.Input[Union['FlinkStatementOrganizationArgs', 'FlinkStatementOrganizationArgsDict']]] = None,
                 principal: Optional[pulumi.Input[Union['FlinkStatementPrincipalArgs', 'FlinkStatementPrincipalArgsDict']]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 properties_sensitive: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 statement: Optional[pulumi.Input[_builtins.str]] = None,
                 statement_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stopped: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Option #1: Manage multiple Flink Compute Pools in the same Pulumi Stack

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        random_int_table = confluentcloud.FlinkStatement("random_int_table",
            organization={
                "id": main["id"],
            },
            environment={
                "id": staging["id"],
            },
            compute_pool={
                "id": example["id"],
            },
            principal={
                "id": app_manager_flink["id"],
            },
            statement="CREATE TABLE random_int_table(ts TIMESTAMP_LTZ(3), random_value INT);",
            properties={
                "sql.current-catalog": example_confluent_environment["displayName"],
                "sql.current-database": example_confluent_kafka_cluster["displayName"],
            },
            rest_endpoint=main_confluent_flink_region["restEndpoint"],
            credentials={
                "key": env_admin_flink_api_key["id"],
                "secret": env_admin_flink_api_key["secret"],
            })
        ```

        ### Option #2: Manage a single Flink Compute Pool in the same Pulumi Stack

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        example = confluentcloud.FlinkStatement("example",
            statement="CREATE TABLE random_int_table(ts TIMESTAMP_LTZ(3), random_value INT);",
            properties={
                "sql.current-catalog": confluent_environment_display_name,
                "sql.current-database": confluent_kafka_cluster_display_name,
            })
        ```

        Example of `FlinkStatement` that creates a model:
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        example = confluentcloud.FlinkStatement("example",
            statement="CREATE MODEL `vector_encoding` INPUT (input STRING) OUTPUT (vector ARRAY<FLOAT>) WITH( 'TASK' = 'classification','PROVIDER' = 'OPENAI','OPENAI.ENDPOINT' = 'https://api.openai.com/v1/embeddings','OPENAI.API_KEY' = '{{sessionconfig/sql.secrets.openaikey}}');",
            properties={
                "sql.current-catalog": confluent_environment_display_name,
                "sql.current-database": confluent_kafka_cluster_display_name,
            },
            properties_sensitive={
                "sql.secrets.openaikey": "***REDACTED***",
            })
        ```

        ## Getting Started

        The following end-to-end example might help to get started with [Flink Statements](https://docs.confluent.io/cloud/current/flink/get-started/overview.html):
          * flink-quickstart
          * flink-carry-over-offset-between-statements

        ## Import

        You can import a Flink statement by using the Flink Statement name, for example:

        Option #1: Manage multiple Flink Compute Pools in the same Pulumi Stack

        $ export IMPORT_CONFLUENT_ORGANIZATION_ID="<organization_id>"

        $ export IMPORT_CONFLUENT_ENVIRONMENT_ID="<environment_id>"

        $ export IMPORT_FLINK_COMPUTE_POOL_ID="<flink_compute_pool_id>"

        $ export IMPORT_FLINK_API_KEY="<flink_api_key>"

        $ export IMPORT_FLINK_API_SECRET="<flink_api_secret>"

        $ export IMPORT_FLINK_REST_ENDPOINT="<flink_rest_endpoint>"

        $ export IMPORT_FLINK_PRINCIPAL_ID="<flink_rest_endpoint>"

        ```sh
        $ pulumi import confluentcloud:index/flinkStatement:FlinkStatement example cfeab4fe-b62c-49bd-9e99-51cc98c77a67
        ```

        Option #2: Manage a single Flink Compute Pool in the same Pulumi Stack

        ```sh
        $ pulumi import confluentcloud:index/flinkStatement:FlinkStatement example cfeab4fe-b62c-49bd-9e99-51cc98c77a67
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FlinkStatementCredentialsArgs', 'FlinkStatementCredentialsArgsDict']] credentials: The Cluster API Credentials.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: The custom topic settings to set:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties_sensitive: Block for sensitive statement properties:
        :param pulumi.Input[_builtins.str] rest_endpoint: The REST endpoint of the Flink region. For example, for public networking: `https://flink.us-east-1.aws.confluent.cloud`. In the case of private networking, the endpoint might look like `https://flink.pr1jy6.us-east-2.aws.confluent.cloud`. You can construct it using either:
               - `data.confluent_flink_region.main.private_rest_endpoint`, or
               - `https://flink${data.confluent_network.main.endpoint_suffix}`
        :param pulumi.Input[_builtins.str] statement: The raw SQL text statement, for example, `SELECT CURRENT_TIMESTAMP;`.
        :param pulumi.Input[_builtins.str] statement_name: The ID of the Flink Statement, for example, `cfeab4fe-b62c-49bd-9e99-51cc98c77a67`.
        :param pulumi.Input[_builtins.bool] stopped: Indicates whether the statement should be stopped.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlinkStatementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Option #1: Manage multiple Flink Compute Pools in the same Pulumi Stack

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        random_int_table = confluentcloud.FlinkStatement("random_int_table",
            organization={
                "id": main["id"],
            },
            environment={
                "id": staging["id"],
            },
            compute_pool={
                "id": example["id"],
            },
            principal={
                "id": app_manager_flink["id"],
            },
            statement="CREATE TABLE random_int_table(ts TIMESTAMP_LTZ(3), random_value INT);",
            properties={
                "sql.current-catalog": example_confluent_environment["displayName"],
                "sql.current-database": example_confluent_kafka_cluster["displayName"],
            },
            rest_endpoint=main_confluent_flink_region["restEndpoint"],
            credentials={
                "key": env_admin_flink_api_key["id"],
                "secret": env_admin_flink_api_key["secret"],
            })
        ```

        ### Option #2: Manage a single Flink Compute Pool in the same Pulumi Stack

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        example = confluentcloud.FlinkStatement("example",
            statement="CREATE TABLE random_int_table(ts TIMESTAMP_LTZ(3), random_value INT);",
            properties={
                "sql.current-catalog": confluent_environment_display_name,
                "sql.current-database": confluent_kafka_cluster_display_name,
            })
        ```

        Example of `FlinkStatement` that creates a model:
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        example = confluentcloud.FlinkStatement("example",
            statement="CREATE MODEL `vector_encoding` INPUT (input STRING) OUTPUT (vector ARRAY<FLOAT>) WITH( 'TASK' = 'classification','PROVIDER' = 'OPENAI','OPENAI.ENDPOINT' = 'https://api.openai.com/v1/embeddings','OPENAI.API_KEY' = '{{sessionconfig/sql.secrets.openaikey}}');",
            properties={
                "sql.current-catalog": confluent_environment_display_name,
                "sql.current-database": confluent_kafka_cluster_display_name,
            },
            properties_sensitive={
                "sql.secrets.openaikey": "***REDACTED***",
            })
        ```

        ## Getting Started

        The following end-to-end example might help to get started with [Flink Statements](https://docs.confluent.io/cloud/current/flink/get-started/overview.html):
          * flink-quickstart
          * flink-carry-over-offset-between-statements

        ## Import

        You can import a Flink statement by using the Flink Statement name, for example:

        Option #1: Manage multiple Flink Compute Pools in the same Pulumi Stack

        $ export IMPORT_CONFLUENT_ORGANIZATION_ID="<organization_id>"

        $ export IMPORT_CONFLUENT_ENVIRONMENT_ID="<environment_id>"

        $ export IMPORT_FLINK_COMPUTE_POOL_ID="<flink_compute_pool_id>"

        $ export IMPORT_FLINK_API_KEY="<flink_api_key>"

        $ export IMPORT_FLINK_API_SECRET="<flink_api_secret>"

        $ export IMPORT_FLINK_REST_ENDPOINT="<flink_rest_endpoint>"

        $ export IMPORT_FLINK_PRINCIPAL_ID="<flink_rest_endpoint>"

        ```sh
        $ pulumi import confluentcloud:index/flinkStatement:FlinkStatement example cfeab4fe-b62c-49bd-9e99-51cc98c77a67
        ```

        Option #2: Manage a single Flink Compute Pool in the same Pulumi Stack

        ```sh
        $ pulumi import confluentcloud:index/flinkStatement:FlinkStatement example cfeab4fe-b62c-49bd-9e99-51cc98c77a67
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param FlinkStatementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlinkStatementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_pool: Optional[pulumi.Input[Union['FlinkStatementComputePoolArgs', 'FlinkStatementComputePoolArgsDict']]] = None,
                 credentials: Optional[pulumi.Input[Union['FlinkStatementCredentialsArgs', 'FlinkStatementCredentialsArgsDict']]] = None,
                 environment: Optional[pulumi.Input[Union['FlinkStatementEnvironmentArgs', 'FlinkStatementEnvironmentArgsDict']]] = None,
                 organization: Optional[pulumi.Input[Union['FlinkStatementOrganizationArgs', 'FlinkStatementOrganizationArgsDict']]] = None,
                 principal: Optional[pulumi.Input[Union['FlinkStatementPrincipalArgs', 'FlinkStatementPrincipalArgsDict']]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 properties_sensitive: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 statement: Optional[pulumi.Input[_builtins.str]] = None,
                 statement_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stopped: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlinkStatementArgs.__new__(FlinkStatementArgs)

            __props__.__dict__["compute_pool"] = compute_pool
            __props__.__dict__["credentials"] = None if credentials is None else pulumi.Output.secret(credentials)
            __props__.__dict__["environment"] = environment
            __props__.__dict__["organization"] = organization
            __props__.__dict__["principal"] = principal
            __props__.__dict__["properties"] = properties
            __props__.__dict__["properties_sensitive"] = None if properties_sensitive is None else pulumi.Output.secret(properties_sensitive)
            __props__.__dict__["rest_endpoint"] = rest_endpoint
            if statement is None and not opts.urn:
                raise TypeError("Missing required property 'statement'")
            __props__.__dict__["statement"] = statement
            __props__.__dict__["statement_name"] = statement_name
            __props__.__dict__["stopped"] = stopped
            __props__.__dict__["latest_offsets"] = None
            __props__.__dict__["latest_offsets_timestamp"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["credentials", "propertiesSensitive"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(FlinkStatement, __self__).__init__(
            'confluentcloud:index/flinkStatement:FlinkStatement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compute_pool: Optional[pulumi.Input[Union['FlinkStatementComputePoolArgs', 'FlinkStatementComputePoolArgsDict']]] = None,
            credentials: Optional[pulumi.Input[Union['FlinkStatementCredentialsArgs', 'FlinkStatementCredentialsArgsDict']]] = None,
            environment: Optional[pulumi.Input[Union['FlinkStatementEnvironmentArgs', 'FlinkStatementEnvironmentArgsDict']]] = None,
            latest_offsets: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            latest_offsets_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            organization: Optional[pulumi.Input[Union['FlinkStatementOrganizationArgs', 'FlinkStatementOrganizationArgsDict']]] = None,
            principal: Optional[pulumi.Input[Union['FlinkStatementPrincipalArgs', 'FlinkStatementPrincipalArgsDict']]] = None,
            properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            properties_sensitive: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            statement: Optional[pulumi.Input[_builtins.str]] = None,
            statement_name: Optional[pulumi.Input[_builtins.str]] = None,
            stopped: Optional[pulumi.Input[_builtins.bool]] = None) -> 'FlinkStatement':
        """
        Get an existing FlinkStatement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FlinkStatementCredentialsArgs', 'FlinkStatementCredentialsArgsDict']] credentials: The Cluster API Credentials.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] latest_offsets: (Optional String) The last Kafka offsets that a statement has processed. Represented by a mapping from Kafka topic to a string representation of partitions mapped to offsets. For example,
               ```bash
               "latest_offsets": {
               "topic-1": "partition:0,offset:100;partition:1,offset:200",
               "topic-2": "partition:0,offset:50"
               }
               ```
        :param pulumi.Input[_builtins.str] latest_offsets_timestamp: (Optional String) The date and time at which the Kafka topic offsets were added to the statement status. It is represented in RFC3339 format and is in UTC. For example, `2023-03-31T00:00:00-00:00`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: The custom topic settings to set:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties_sensitive: Block for sensitive statement properties:
        :param pulumi.Input[_builtins.str] rest_endpoint: The REST endpoint of the Flink region. For example, for public networking: `https://flink.us-east-1.aws.confluent.cloud`. In the case of private networking, the endpoint might look like `https://flink.pr1jy6.us-east-2.aws.confluent.cloud`. You can construct it using either:
               - `data.confluent_flink_region.main.private_rest_endpoint`, or
               - `https://flink${data.confluent_network.main.endpoint_suffix}`
        :param pulumi.Input[_builtins.str] statement: The raw SQL text statement, for example, `SELECT CURRENT_TIMESTAMP;`.
        :param pulumi.Input[_builtins.str] statement_name: The ID of the Flink Statement, for example, `cfeab4fe-b62c-49bd-9e99-51cc98c77a67`.
        :param pulumi.Input[_builtins.bool] stopped: Indicates whether the statement should be stopped.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlinkStatementState.__new__(_FlinkStatementState)

        __props__.__dict__["compute_pool"] = compute_pool
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["environment"] = environment
        __props__.__dict__["latest_offsets"] = latest_offsets
        __props__.__dict__["latest_offsets_timestamp"] = latest_offsets_timestamp
        __props__.__dict__["organization"] = organization
        __props__.__dict__["principal"] = principal
        __props__.__dict__["properties"] = properties
        __props__.__dict__["properties_sensitive"] = properties_sensitive
        __props__.__dict__["rest_endpoint"] = rest_endpoint
        __props__.__dict__["statement"] = statement
        __props__.__dict__["statement_name"] = statement_name
        __props__.__dict__["stopped"] = stopped
        return FlinkStatement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="computePool")
    def compute_pool(self) -> pulumi.Output['outputs.FlinkStatementComputePool']:
        return pulumi.get(self, "compute_pool")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional['outputs.FlinkStatementCredentials']]:
        """
        The Cluster API Credentials.
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.FlinkStatementEnvironment']:
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="latestOffsets")
    def latest_offsets(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Optional String) The last Kafka offsets that a statement has processed. Represented by a mapping from Kafka topic to a string representation of partitions mapped to offsets. For example,
        ```bash
        "latest_offsets": {
        "topic-1": "partition:0,offset:100;partition:1,offset:200",
        "topic-2": "partition:0,offset:50"
        }
        ```
        """
        return pulumi.get(self, "latest_offsets")

    @_builtins.property
    @pulumi.getter(name="latestOffsetsTimestamp")
    def latest_offsets_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        (Optional String) The date and time at which the Kafka topic offsets were added to the statement status. It is represented in RFC3339 format and is in UTC. For example, `2023-03-31T00:00:00-00:00`.
        """
        return pulumi.get(self, "latest_offsets_timestamp")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output['outputs.FlinkStatementOrganization']:
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter
    def principal(self) -> pulumi.Output['outputs.FlinkStatementPrincipal']:
        return pulumi.get(self, "principal")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The custom topic settings to set:
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="propertiesSensitive")
    def properties_sensitive(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Block for sensitive statement properties:
        """
        return pulumi.get(self, "properties_sensitive")

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The REST endpoint of the Flink region. For example, for public networking: `https://flink.us-east-1.aws.confluent.cloud`. In the case of private networking, the endpoint might look like `https://flink.pr1jy6.us-east-2.aws.confluent.cloud`. You can construct it using either:
        - `data.confluent_flink_region.main.private_rest_endpoint`, or
        - `https://flink${data.confluent_network.main.endpoint_suffix}`
        """
        return pulumi.get(self, "rest_endpoint")

    @_builtins.property
    @pulumi.getter
    def statement(self) -> pulumi.Output[_builtins.str]:
        """
        The raw SQL text statement, for example, `SELECT CURRENT_TIMESTAMP;`.
        """
        return pulumi.get(self, "statement")

    @_builtins.property
    @pulumi.getter(name="statementName")
    def statement_name(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Flink Statement, for example, `cfeab4fe-b62c-49bd-9e99-51cc98c77a67`.
        """
        return pulumi.get(self, "statement_name")

    @_builtins.property
    @pulumi.getter
    def stopped(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the statement should be stopped.
        """
        return pulumi.get(self, "stopped")

