# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProviderIntegrationAuthorizationArgs', 'ProviderIntegrationAuthorization']

@pulumi.input_type
class ProviderIntegrationAuthorizationArgs:
    def __init__(__self__, *,
                 environment: pulumi.Input['ProviderIntegrationAuthorizationEnvironmentArgs'],
                 provider_integration_id: pulumi.Input[_builtins.str],
                 azure: Optional[pulumi.Input['ProviderIntegrationAuthorizationAzureArgs']] = None,
                 gcp: Optional[pulumi.Input['ProviderIntegrationAuthorizationGcpArgs']] = None):
        """
        The set of arguments for constructing a ProviderIntegrationAuthorization resource.
        :param pulumi.Input['ProviderIntegrationAuthorizationEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[_builtins.str] provider_integration_id: The ID of the provider integration to authorize.
        :param pulumi.Input['ProviderIntegrationAuthorizationAzureArgs'] azure: (Optional Configuration Block) Azure-specific configuration details. It supports the following:
        :param pulumi.Input['ProviderIntegrationAuthorizationGcpArgs'] gcp: (Optional Configuration Block) GCP-specific configuration details. It supports the following:
        """
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "provider_integration_id", provider_integration_id)
        if azure is not None:
            pulumi.set(__self__, "azure", azure)
        if gcp is not None:
            pulumi.set(__self__, "gcp", gcp)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input['ProviderIntegrationAuthorizationEnvironmentArgs']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input['ProviderIntegrationAuthorizationEnvironmentArgs']):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="providerIntegrationId")
    def provider_integration_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the provider integration to authorize.
        """
        return pulumi.get(self, "provider_integration_id")

    @provider_integration_id.setter
    def provider_integration_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provider_integration_id", value)

    @_builtins.property
    @pulumi.getter
    def azure(self) -> Optional[pulumi.Input['ProviderIntegrationAuthorizationAzureArgs']]:
        """
        (Optional Configuration Block) Azure-specific configuration details. It supports the following:
        """
        return pulumi.get(self, "azure")

    @azure.setter
    def azure(self, value: Optional[pulumi.Input['ProviderIntegrationAuthorizationAzureArgs']]):
        pulumi.set(self, "azure", value)

    @_builtins.property
    @pulumi.getter
    def gcp(self) -> Optional[pulumi.Input['ProviderIntegrationAuthorizationGcpArgs']]:
        """
        (Optional Configuration Block) GCP-specific configuration details. It supports the following:
        """
        return pulumi.get(self, "gcp")

    @gcp.setter
    def gcp(self, value: Optional[pulumi.Input['ProviderIntegrationAuthorizationGcpArgs']]):
        pulumi.set(self, "gcp", value)


@pulumi.input_type
class _ProviderIntegrationAuthorizationState:
    def __init__(__self__, *,
                 azure: Optional[pulumi.Input['ProviderIntegrationAuthorizationAzureArgs']] = None,
                 environment: Optional[pulumi.Input['ProviderIntegrationAuthorizationEnvironmentArgs']] = None,
                 gcp: Optional[pulumi.Input['ProviderIntegrationAuthorizationGcpArgs']] = None,
                 provider_integration_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProviderIntegrationAuthorization resources.
        :param pulumi.Input['ProviderIntegrationAuthorizationAzureArgs'] azure: (Optional Configuration Block) Azure-specific configuration details. It supports the following:
        :param pulumi.Input['ProviderIntegrationAuthorizationEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input['ProviderIntegrationAuthorizationGcpArgs'] gcp: (Optional Configuration Block) GCP-specific configuration details. It supports the following:
        :param pulumi.Input[_builtins.str] provider_integration_id: The ID of the provider integration to authorize.
        """
        if azure is not None:
            pulumi.set(__self__, "azure", azure)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if gcp is not None:
            pulumi.set(__self__, "gcp", gcp)
        if provider_integration_id is not None:
            pulumi.set(__self__, "provider_integration_id", provider_integration_id)

    @_builtins.property
    @pulumi.getter
    def azure(self) -> Optional[pulumi.Input['ProviderIntegrationAuthorizationAzureArgs']]:
        """
        (Optional Configuration Block) Azure-specific configuration details. It supports the following:
        """
        return pulumi.get(self, "azure")

    @azure.setter
    def azure(self, value: Optional[pulumi.Input['ProviderIntegrationAuthorizationAzureArgs']]):
        pulumi.set(self, "azure", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['ProviderIntegrationAuthorizationEnvironmentArgs']]:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['ProviderIntegrationAuthorizationEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def gcp(self) -> Optional[pulumi.Input['ProviderIntegrationAuthorizationGcpArgs']]:
        """
        (Optional Configuration Block) GCP-specific configuration details. It supports the following:
        """
        return pulumi.get(self, "gcp")

    @gcp.setter
    def gcp(self, value: Optional[pulumi.Input['ProviderIntegrationAuthorizationGcpArgs']]):
        pulumi.set(self, "gcp", value)

    @_builtins.property
    @pulumi.getter(name="providerIntegrationId")
    def provider_integration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the provider integration to authorize.
        """
        return pulumi.get(self, "provider_integration_id")

    @provider_integration_id.setter
    def provider_integration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_integration_id", value)


@pulumi.type_token("confluentcloud:index/providerIntegrationAuthorization:ProviderIntegrationAuthorization")
class ProviderIntegrationAuthorization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure: Optional[pulumi.Input[Union['ProviderIntegrationAuthorizationAzureArgs', 'ProviderIntegrationAuthorizationAzureArgsDict']]] = None,
                 environment: Optional[pulumi.Input[Union['ProviderIntegrationAuthorizationEnvironmentArgs', 'ProviderIntegrationAuthorizationEnvironmentArgsDict']]] = None,
                 gcp: Optional[pulumi.Input[Union['ProviderIntegrationAuthorizationGcpArgs', 'ProviderIntegrationAuthorizationGcpArgsDict']]] = None,
                 provider_integration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        You can import a Provider Integration Authorization by using Environment ID and Provider Integration ID, in the format `<Environment ID>/<Provider Integration ID>`. The following example shows how to import a Provider Integration Authorization:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/providerIntegrationAuthorization:ProviderIntegrationAuthorization main env-abc123/cspi-4xg0q
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ProviderIntegrationAuthorizationAzureArgs', 'ProviderIntegrationAuthorizationAzureArgsDict']] azure: (Optional Configuration Block) Azure-specific configuration details. It supports the following:
        :param pulumi.Input[Union['ProviderIntegrationAuthorizationEnvironmentArgs', 'ProviderIntegrationAuthorizationEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[Union['ProviderIntegrationAuthorizationGcpArgs', 'ProviderIntegrationAuthorizationGcpArgsDict']] gcp: (Optional Configuration Block) GCP-specific configuration details. It supports the following:
        :param pulumi.Input[_builtins.str] provider_integration_id: The ID of the provider integration to authorize.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProviderIntegrationAuthorizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        You can import a Provider Integration Authorization by using Environment ID and Provider Integration ID, in the format `<Environment ID>/<Provider Integration ID>`. The following example shows how to import a Provider Integration Authorization:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/providerIntegrationAuthorization:ProviderIntegrationAuthorization main env-abc123/cspi-4xg0q
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param ProviderIntegrationAuthorizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderIntegrationAuthorizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure: Optional[pulumi.Input[Union['ProviderIntegrationAuthorizationAzureArgs', 'ProviderIntegrationAuthorizationAzureArgsDict']]] = None,
                 environment: Optional[pulumi.Input[Union['ProviderIntegrationAuthorizationEnvironmentArgs', 'ProviderIntegrationAuthorizationEnvironmentArgsDict']]] = None,
                 gcp: Optional[pulumi.Input[Union['ProviderIntegrationAuthorizationGcpArgs', 'ProviderIntegrationAuthorizationGcpArgsDict']]] = None,
                 provider_integration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderIntegrationAuthorizationArgs.__new__(ProviderIntegrationAuthorizationArgs)

            __props__.__dict__["azure"] = azure
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["gcp"] = gcp
            if provider_integration_id is None and not opts.urn:
                raise TypeError("Missing required property 'provider_integration_id'")
            __props__.__dict__["provider_integration_id"] = provider_integration_id
        super(ProviderIntegrationAuthorization, __self__).__init__(
            'confluentcloud:index/providerIntegrationAuthorization:ProviderIntegrationAuthorization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure: Optional[pulumi.Input[Union['ProviderIntegrationAuthorizationAzureArgs', 'ProviderIntegrationAuthorizationAzureArgsDict']]] = None,
            environment: Optional[pulumi.Input[Union['ProviderIntegrationAuthorizationEnvironmentArgs', 'ProviderIntegrationAuthorizationEnvironmentArgsDict']]] = None,
            gcp: Optional[pulumi.Input[Union['ProviderIntegrationAuthorizationGcpArgs', 'ProviderIntegrationAuthorizationGcpArgsDict']]] = None,
            provider_integration_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProviderIntegrationAuthorization':
        """
        Get an existing ProviderIntegrationAuthorization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ProviderIntegrationAuthorizationAzureArgs', 'ProviderIntegrationAuthorizationAzureArgsDict']] azure: (Optional Configuration Block) Azure-specific configuration details. It supports the following:
        :param pulumi.Input[Union['ProviderIntegrationAuthorizationEnvironmentArgs', 'ProviderIntegrationAuthorizationEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[Union['ProviderIntegrationAuthorizationGcpArgs', 'ProviderIntegrationAuthorizationGcpArgsDict']] gcp: (Optional Configuration Block) GCP-specific configuration details. It supports the following:
        :param pulumi.Input[_builtins.str] provider_integration_id: The ID of the provider integration to authorize.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProviderIntegrationAuthorizationState.__new__(_ProviderIntegrationAuthorizationState)

        __props__.__dict__["azure"] = azure
        __props__.__dict__["environment"] = environment
        __props__.__dict__["gcp"] = gcp
        __props__.__dict__["provider_integration_id"] = provider_integration_id
        return ProviderIntegrationAuthorization(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def azure(self) -> pulumi.Output[Optional['outputs.ProviderIntegrationAuthorizationAzure']]:
        """
        (Optional Configuration Block) Azure-specific configuration details. It supports the following:
        """
        return pulumi.get(self, "azure")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.ProviderIntegrationAuthorizationEnvironment']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def gcp(self) -> pulumi.Output[Optional['outputs.ProviderIntegrationAuthorizationGcp']]:
        """
        (Optional Configuration Block) GCP-specific configuration details. It supports the following:
        """
        return pulumi.get(self, "gcp")

    @_builtins.property
    @pulumi.getter(name="providerIntegrationId")
    def provider_integration_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the provider integration to authorize.
        """
        return pulumi.get(self, "provider_integration_id")

