# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProviderIntegrationSetupArgs', 'ProviderIntegrationSetup']

@pulumi.input_type
class ProviderIntegrationSetupArgs:
    def __init__(__self__, *,
                 cloud: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 environment: pulumi.Input['ProviderIntegrationSetupEnvironmentArgs']):
        """
        The set of arguments for constructing a ProviderIntegrationSetup resource.
        :param pulumi.Input[_builtins.str] cloud: The cloud service provider. Supported values are `AZURE` and `GCP`.
        :param pulumi.Input[_builtins.str] display_name: The name of the Provider Integration.
        :param pulumi.Input['ProviderIntegrationSetupEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        pulumi.set(__self__, "cloud", cloud)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "environment", environment)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> pulumi.Input[_builtins.str]:
        """
        The cloud service provider. Supported values are `AZURE` and `GCP`.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Provider Integration.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input['ProviderIntegrationSetupEnvironmentArgs']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input['ProviderIntegrationSetupEnvironmentArgs']):
        pulumi.set(self, "environment", value)


@pulumi.input_type
class _ProviderIntegrationSetupState:
    def __init__(__self__, *,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input['ProviderIntegrationSetupEnvironmentArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 usages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ProviderIntegrationSetup resources.
        :param pulumi.Input[_builtins.str] cloud: The cloud service provider. Supported values are `AZURE` and `GCP`.
        :param pulumi.Input[_builtins.str] display_name: The name of the Provider Integration.
        :param pulumi.Input['ProviderIntegrationSetupEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[_builtins.str] status: (Required String) The status of the Provider Integration. Values are `DRAFT` and `CREATED`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] usages: (Required List of Strings) List of resource CRNs where this provider integration is being used.
        """
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if usages is not None:
            pulumi.set(__self__, "usages", usages)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cloud service provider. Supported values are `AZURE` and `GCP`.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Provider Integration.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['ProviderIntegrationSetupEnvironmentArgs']]:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['ProviderIntegrationSetupEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Required String) The status of the Provider Integration. Values are `DRAFT` and `CREATED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def usages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Required List of Strings) List of resource CRNs where this provider integration is being used.
        """
        return pulumi.get(self, "usages")

    @usages.setter
    def usages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "usages", value)


@pulumi.type_token("confluentcloud:index/providerIntegrationSetup:ProviderIntegrationSetup")
class ProviderIntegrationSetup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['ProviderIntegrationSetupEnvironmentArgs', 'ProviderIntegrationSetupEnvironmentArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Azure Provider Integration

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        staging = confluentcloud.Environment("staging",
            display_name="Staging",
            stream_governance={
                "package": "ESSENTIALS",
            })
        azure = confluentcloud.ProviderIntegrationSetup("azure",
            environment={
                "id": staging.id,
            },
            display_name="azure-integration",
            cloud="AZURE")
        # Configure and validate the Azure integration
        azure_provider_integration_authorization = confluentcloud.ProviderIntegrationAuthorization("azure",
            provider_integration_id=azure.id,
            environment={
                "id": staging.id,
            },
            azure={
                "customer_azure_tenant_id": "12345678-1234-1234-1234-123456789abc",
            })
        ```

        ### GCP Provider Integration

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        gcp = confluentcloud.ProviderIntegrationSetup("gcp",
            environment={
                "id": staging["id"],
            },
            display_name="gcp-integration",
            cloud="GCP")
        # Configure and validate the GCP integration
        gcp_provider_integration_authorization = confluentcloud.ProviderIntegrationAuthorization("gcp",
            provider_integration_id=gcp.id,
            environment={
                "id": staging["id"],
            },
            gcp={
                "customer_google_service_account": "my-sa@my-project.iam.gserviceaccount.com",
            })
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `ProviderIntegrationSetup` resource:
        * provider-integration-azure: Complete Azure Provider Integration setup
        * provider-integration-gcp: Complete GCP Provider Integration setup

        ## Import

        You can import a Provider Integration by using Environment ID and Provider Integration ID, in the format `<Environment ID>/<Provider Integration ID>`. The following example shows how to import a Provider Integration:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/providerIntegrationSetup:ProviderIntegrationSetup main env-abc123/cspi-4xg0q
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud: The cloud service provider. Supported values are `AZURE` and `GCP`.
        :param pulumi.Input[_builtins.str] display_name: The name of the Provider Integration.
        :param pulumi.Input[Union['ProviderIntegrationSetupEnvironmentArgs', 'ProviderIntegrationSetupEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProviderIntegrationSetupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Azure Provider Integration

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        staging = confluentcloud.Environment("staging",
            display_name="Staging",
            stream_governance={
                "package": "ESSENTIALS",
            })
        azure = confluentcloud.ProviderIntegrationSetup("azure",
            environment={
                "id": staging.id,
            },
            display_name="azure-integration",
            cloud="AZURE")
        # Configure and validate the Azure integration
        azure_provider_integration_authorization = confluentcloud.ProviderIntegrationAuthorization("azure",
            provider_integration_id=azure.id,
            environment={
                "id": staging.id,
            },
            azure={
                "customer_azure_tenant_id": "12345678-1234-1234-1234-123456789abc",
            })
        ```

        ### GCP Provider Integration

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        gcp = confluentcloud.ProviderIntegrationSetup("gcp",
            environment={
                "id": staging["id"],
            },
            display_name="gcp-integration",
            cloud="GCP")
        # Configure and validate the GCP integration
        gcp_provider_integration_authorization = confluentcloud.ProviderIntegrationAuthorization("gcp",
            provider_integration_id=gcp.id,
            environment={
                "id": staging["id"],
            },
            gcp={
                "customer_google_service_account": "my-sa@my-project.iam.gserviceaccount.com",
            })
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `ProviderIntegrationSetup` resource:
        * provider-integration-azure: Complete Azure Provider Integration setup
        * provider-integration-gcp: Complete GCP Provider Integration setup

        ## Import

        You can import a Provider Integration by using Environment ID and Provider Integration ID, in the format `<Environment ID>/<Provider Integration ID>`. The following example shows how to import a Provider Integration:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/providerIntegrationSetup:ProviderIntegrationSetup main env-abc123/cspi-4xg0q
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param ProviderIntegrationSetupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderIntegrationSetupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['ProviderIntegrationSetupEnvironmentArgs', 'ProviderIntegrationSetupEnvironmentArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderIntegrationSetupArgs.__new__(ProviderIntegrationSetupArgs)

            if cloud is None and not opts.urn:
                raise TypeError("Missing required property 'cloud'")
            __props__.__dict__["cloud"] = cloud
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["status"] = None
            __props__.__dict__["usages"] = None
        super(ProviderIntegrationSetup, __self__).__init__(
            'confluentcloud:index/providerIntegrationSetup:ProviderIntegrationSetup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            environment: Optional[pulumi.Input[Union['ProviderIntegrationSetupEnvironmentArgs', 'ProviderIntegrationSetupEnvironmentArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            usages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ProviderIntegrationSetup':
        """
        Get an existing ProviderIntegrationSetup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud: The cloud service provider. Supported values are `AZURE` and `GCP`.
        :param pulumi.Input[_builtins.str] display_name: The name of the Provider Integration.
        :param pulumi.Input[Union['ProviderIntegrationSetupEnvironmentArgs', 'ProviderIntegrationSetupEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[_builtins.str] status: (Required String) The status of the Provider Integration. Values are `DRAFT` and `CREATED`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] usages: (Required List of Strings) List of resource CRNs where this provider integration is being used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProviderIntegrationSetupState.__new__(_ProviderIntegrationSetupState)

        __props__.__dict__["cloud"] = cloud
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["environment"] = environment
        __props__.__dict__["status"] = status
        __props__.__dict__["usages"] = usages
        return ProviderIntegrationSetup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> pulumi.Output[_builtins.str]:
        """
        The cloud service provider. Supported values are `AZURE` and `GCP`.
        """
        return pulumi.get(self, "cloud")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Provider Integration.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.ProviderIntegrationSetupEnvironment']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        (Required String) The status of the Provider Integration. Values are `DRAFT` and `CREATED`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def usages(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Required List of Strings) List of resource CRNs where this provider integration is being used.
        """
        return pulumi.get(self, "usages")

