# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'OAuthGroupsClaimArgs',
    'OAuthGroupsClaimArgsDict',
    'OAuthJwkArgs',
    'OAuthJwkArgsDict',
    'SamlAcsEndpointsIndexArgs',
    'SamlAcsEndpointsIndexArgsDict',
    'SamlAttributeStatementArgs',
    'SamlAttributeStatementArgsDict',
    'SamlKeyArgs',
    'SamlKeyArgsDict',
]

MYPY = False

if not MYPY:
    class OAuthGroupsClaimArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Name of the claim that will be used in the token.
        """
        type: pulumi.Input[_builtins.str]
        """
        Groups claim type.
        """
        value: pulumi.Input[_builtins.str]
        """
        Value of the claim. Can be an Okta Expression Language statement that evaluates at the time the token is minted.
        """
        filter_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Groups claim filter. Can only be set if type is FILTER.
        """
        issuer_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        Issuer mode inherited from OAuth App
        """
elif False:
    OAuthGroupsClaimArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OAuthGroupsClaimArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str],
                 filter_type: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: Name of the claim that will be used in the token.
        :param pulumi.Input[_builtins.str] type: Groups claim type.
        :param pulumi.Input[_builtins.str] value: Value of the claim. Can be an Okta Expression Language statement that evaluates at the time the token is minted.
        :param pulumi.Input[_builtins.str] filter_type: Groups claim filter. Can only be set if type is FILTER.
        :param pulumi.Input[_builtins.str] issuer_mode: Issuer mode inherited from OAuth App
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if issuer_mode is not None:
            pulumi.set(__self__, "issuer_mode", issuer_mode)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the claim that will be used in the token.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Groups claim type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        Value of the claim. Can be an Okta Expression Language statement that evaluates at the time the token is minted.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Groups claim filter. Can only be set if type is FILTER.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_type", value)

    @_builtins.property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Issuer mode inherited from OAuth App
        """
        return pulumi.get(self, "issuer_mode")

    @issuer_mode.setter
    def issuer_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_mode", value)


if not MYPY:
    class OAuthJwkArgsDict(TypedDict):
        kid: pulumi.Input[_builtins.str]
        """
        Key ID
        """
        kty: pulumi.Input[_builtins.str]
        """
        Key type
        """
        e: NotRequired[pulumi.Input[_builtins.str]]
        """
        RSA Exponent
        """
        n: NotRequired[pulumi.Input[_builtins.str]]
        """
        RSA Modulus
        """
        x: NotRequired[pulumi.Input[_builtins.str]]
        """
        X coordinate of the elliptic curve point
        """
        y: NotRequired[pulumi.Input[_builtins.str]]
        """
        Y coordinate of the elliptic curve point
        """
elif False:
    OAuthJwkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OAuthJwkArgs:
    def __init__(__self__, *,
                 kid: pulumi.Input[_builtins.str],
                 kty: pulumi.Input[_builtins.str],
                 e: Optional[pulumi.Input[_builtins.str]] = None,
                 n: Optional[pulumi.Input[_builtins.str]] = None,
                 x: Optional[pulumi.Input[_builtins.str]] = None,
                 y: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] kid: Key ID
        :param pulumi.Input[_builtins.str] kty: Key type
        :param pulumi.Input[_builtins.str] e: RSA Exponent
        :param pulumi.Input[_builtins.str] n: RSA Modulus
        :param pulumi.Input[_builtins.str] x: X coordinate of the elliptic curve point
        :param pulumi.Input[_builtins.str] y: Y coordinate of the elliptic curve point
        """
        pulumi.set(__self__, "kid", kid)
        pulumi.set(__self__, "kty", kty)
        if e is not None:
            pulumi.set(__self__, "e", e)
        if n is not None:
            pulumi.set(__self__, "n", n)
        if x is not None:
            pulumi.set(__self__, "x", x)
        if y is not None:
            pulumi.set(__self__, "y", y)

    @_builtins.property
    @pulumi.getter
    def kid(self) -> pulumi.Input[_builtins.str]:
        """
        Key ID
        """
        return pulumi.get(self, "kid")

    @kid.setter
    def kid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kid", value)

    @_builtins.property
    @pulumi.getter
    def kty(self) -> pulumi.Input[_builtins.str]:
        """
        Key type
        """
        return pulumi.get(self, "kty")

    @kty.setter
    def kty(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kty", value)

    @_builtins.property
    @pulumi.getter
    def e(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RSA Exponent
        """
        return pulumi.get(self, "e")

    @e.setter
    def e(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "e", value)

    @_builtins.property
    @pulumi.getter
    def n(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RSA Modulus
        """
        return pulumi.get(self, "n")

    @n.setter
    def n(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "n", value)

    @_builtins.property
    @pulumi.getter
    def x(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        X coordinate of the elliptic curve point
        """
        return pulumi.get(self, "x")

    @x.setter
    def x(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "x", value)

    @_builtins.property
    @pulumi.getter
    def y(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Y coordinate of the elliptic curve point
        """
        return pulumi.get(self, "y")

    @y.setter
    def y(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "y", value)


if not MYPY:
    class SamlAcsEndpointsIndexArgsDict(TypedDict):
        index: pulumi.Input[_builtins.int]
        url: pulumi.Input[_builtins.str]
elif False:
    SamlAcsEndpointsIndexArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SamlAcsEndpointsIndexArgs:
    def __init__(__self__, *,
                 index: pulumi.Input[_builtins.int],
                 url: pulumi.Input[_builtins.str]):
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def index(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "index", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)


if not MYPY:
    class SamlAttributeStatementArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The reference name of the attribute statement
        """
        filter_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Type of group attribute filter. Valid values are: `STARTS_WITH`, `EQUALS`, `CONTAINS`, or `REGEX`
        """
        filter_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        Filter value to use
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The attribute namespace. It can be set to `urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified`, `urn:oasis:names:tc:SAML:2.0:attrname-format:uri`, or `urn:oasis:names:tc:SAML:2.0:attrname-format:basic`
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of attribute statements object
        """
        values: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
elif False:
    SamlAttributeStatementArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SamlAttributeStatementArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 filter_type: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_value: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The reference name of the attribute statement
        :param pulumi.Input[_builtins.str] filter_type: Type of group attribute filter. Valid values are: `STARTS_WITH`, `EQUALS`, `CONTAINS`, or `REGEX`
        :param pulumi.Input[_builtins.str] filter_value: Filter value to use
        :param pulumi.Input[_builtins.str] namespace: The attribute namespace. It can be set to `urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified`, `urn:oasis:names:tc:SAML:2.0:attrname-format:uri`, or `urn:oasis:names:tc:SAML:2.0:attrname-format:basic`
        :param pulumi.Input[_builtins.str] type: The type of attribute statements object
        """
        pulumi.set(__self__, "name", name)
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if filter_value is not None:
            pulumi.set(__self__, "filter_value", filter_value)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The reference name of the attribute statement
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of group attribute filter. Valid values are: `STARTS_WITH`, `EQUALS`, `CONTAINS`, or `REGEX`
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_type", value)

    @_builtins.property
    @pulumi.getter(name="filterValue")
    def filter_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Filter value to use
        """
        return pulumi.get(self, "filter_value")

    @filter_value.setter
    def filter_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_value", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attribute namespace. It can be set to `urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified`, `urn:oasis:names:tc:SAML:2.0:attrname-format:uri`, or `urn:oasis:names:tc:SAML:2.0:attrname-format:basic`
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of attribute statements object
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class SamlKeyArgsDict(TypedDict):
        created: NotRequired[pulumi.Input[_builtins.str]]
        """
        Created date
        """
        e: NotRequired[pulumi.Input[_builtins.str]]
        """
        RSA exponent
        """
        expires_at: NotRequired[pulumi.Input[_builtins.str]]
        """
        Expiration date
        """
        kid: NotRequired[pulumi.Input[_builtins.str]]
        """
        Key ID
        """
        kty: NotRequired[pulumi.Input[_builtins.str]]
        """
        Key type. Identifies the cryptographic algorithm family used with the key.
        """
        last_updated: NotRequired[pulumi.Input[_builtins.str]]
        """
        Last updated date
        """
        n: NotRequired[pulumi.Input[_builtins.str]]
        """
        RSA modulus
        """
        use: NotRequired[pulumi.Input[_builtins.str]]
        """
        Intended use of the public key.
        """
        x5cs: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        X.509 Certificate Chain
        """
        x5t_s256: NotRequired[pulumi.Input[_builtins.str]]
        """
        X.509 certificate SHA-256 thumbprint
        """
elif False:
    SamlKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SamlKeyArgs:
    def __init__(__self__, *,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 e: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 kid: Optional[pulumi.Input[_builtins.str]] = None,
                 kty: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 n: Optional[pulumi.Input[_builtins.str]] = None,
                 use: Optional[pulumi.Input[_builtins.str]] = None,
                 x5cs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 x5t_s256: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] created: Created date
        :param pulumi.Input[_builtins.str] e: RSA exponent
        :param pulumi.Input[_builtins.str] expires_at: Expiration date
        :param pulumi.Input[_builtins.str] kid: Key ID
        :param pulumi.Input[_builtins.str] kty: Key type. Identifies the cryptographic algorithm family used with the key.
        :param pulumi.Input[_builtins.str] last_updated: Last updated date
        :param pulumi.Input[_builtins.str] n: RSA modulus
        :param pulumi.Input[_builtins.str] use: Intended use of the public key.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] x5cs: X.509 Certificate Chain
        :param pulumi.Input[_builtins.str] x5t_s256: X.509 certificate SHA-256 thumbprint
        """
        if created is not None:
            pulumi.set(__self__, "created", created)
        if e is not None:
            pulumi.set(__self__, "e", e)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if kid is not None:
            pulumi.set(__self__, "kid", kid)
        if kty is not None:
            pulumi.set(__self__, "kty", kty)
        if last_updated is not None:
            pulumi.set(__self__, "last_updated", last_updated)
        if n is not None:
            pulumi.set(__self__, "n", n)
        if use is not None:
            pulumi.set(__self__, "use", use)
        if x5cs is not None:
            pulumi.set(__self__, "x5cs", x5cs)
        if x5t_s256 is not None:
            pulumi.set(__self__, "x5t_s256", x5t_s256)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Created date
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def e(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RSA exponent
        """
        return pulumi.get(self, "e")

    @e.setter
    def e(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "e", value)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Expiration date
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @_builtins.property
    @pulumi.getter
    def kid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key ID
        """
        return pulumi.get(self, "kid")

    @kid.setter
    def kid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kid", value)

    @_builtins.property
    @pulumi.getter
    def kty(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key type. Identifies the cryptographic algorithm family used with the key.
        """
        return pulumi.get(self, "kty")

    @kty.setter
    def kty(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kty", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last updated date
        """
        return pulumi.get(self, "last_updated")

    @last_updated.setter
    def last_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated", value)

    @_builtins.property
    @pulumi.getter
    def n(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RSA modulus
        """
        return pulumi.get(self, "n")

    @n.setter
    def n(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "n", value)

    @_builtins.property
    @pulumi.getter
    def use(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Intended use of the public key.
        """
        return pulumi.get(self, "use")

    @use.setter
    def use(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "use", value)

    @_builtins.property
    @pulumi.getter
    def x5cs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        X.509 Certificate Chain
        """
        return pulumi.get(self, "x5cs")

    @x5cs.setter
    def x5cs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "x5cs", value)

    @_builtins.property
    @pulumi.getter(name="x5tS256")
    def x5t_s256(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        X.509 certificate SHA-256 thumbprint
        """
        return pulumi.get(self, "x5t_s256")

    @x5t_s256.setter
    def x5t_s256(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "x5t_s256", value)


