# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'OAuthGroupsClaim',
    'OAuthJwk',
    'SamlAcsEndpointsIndex',
    'SamlAttributeStatement',
    'SamlKey',
    'GetSamlAttributeStatementResult',
]

@pulumi.output_type
class OAuthGroupsClaim(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterType":
            suggest = "filter_type"
        elif key == "issuerMode":
            suggest = "issuer_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OAuthGroupsClaim. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OAuthGroupsClaim.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OAuthGroupsClaim.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str,
                 value: _builtins.str,
                 filter_type: Optional[_builtins.str] = None,
                 issuer_mode: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the claim that will be used in the token.
        :param _builtins.str type: Groups claim type.
        :param _builtins.str value: Value of the claim. Can be an Okta Expression Language statement that evaluates at the time the token is minted.
        :param _builtins.str filter_type: Groups claim filter. Can only be set if type is FILTER.
        :param _builtins.str issuer_mode: Issuer mode inherited from OAuth App
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if issuer_mode is not None:
            pulumi.set(__self__, "issuer_mode", issuer_mode)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the claim that will be used in the token.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Groups claim type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the claim. Can be an Okta Expression Language statement that evaluates at the time the token is minted.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[_builtins.str]:
        """
        Groups claim filter. Can only be set if type is FILTER.
        """
        return pulumi.get(self, "filter_type")

    @_builtins.property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> Optional[_builtins.str]:
        """
        Issuer mode inherited from OAuth App
        """
        return pulumi.get(self, "issuer_mode")


@pulumi.output_type
class OAuthJwk(dict):
    def __init__(__self__, *,
                 kid: _builtins.str,
                 kty: _builtins.str,
                 e: Optional[_builtins.str] = None,
                 n: Optional[_builtins.str] = None,
                 x: Optional[_builtins.str] = None,
                 y: Optional[_builtins.str] = None):
        """
        :param _builtins.str kid: Key ID
        :param _builtins.str kty: Key type
        :param _builtins.str e: RSA Exponent
        :param _builtins.str n: RSA Modulus
        :param _builtins.str x: X coordinate of the elliptic curve point
        :param _builtins.str y: Y coordinate of the elliptic curve point
        """
        pulumi.set(__self__, "kid", kid)
        pulumi.set(__self__, "kty", kty)
        if e is not None:
            pulumi.set(__self__, "e", e)
        if n is not None:
            pulumi.set(__self__, "n", n)
        if x is not None:
            pulumi.set(__self__, "x", x)
        if y is not None:
            pulumi.set(__self__, "y", y)

    @_builtins.property
    @pulumi.getter
    def kid(self) -> _builtins.str:
        """
        Key ID
        """
        return pulumi.get(self, "kid")

    @_builtins.property
    @pulumi.getter
    def kty(self) -> _builtins.str:
        """
        Key type
        """
        return pulumi.get(self, "kty")

    @_builtins.property
    @pulumi.getter
    def e(self) -> Optional[_builtins.str]:
        """
        RSA Exponent
        """
        return pulumi.get(self, "e")

    @_builtins.property
    @pulumi.getter
    def n(self) -> Optional[_builtins.str]:
        """
        RSA Modulus
        """
        return pulumi.get(self, "n")

    @_builtins.property
    @pulumi.getter
    def x(self) -> Optional[_builtins.str]:
        """
        X coordinate of the elliptic curve point
        """
        return pulumi.get(self, "x")

    @_builtins.property
    @pulumi.getter
    def y(self) -> Optional[_builtins.str]:
        """
        Y coordinate of the elliptic curve point
        """
        return pulumi.get(self, "y")


@pulumi.output_type
class SamlAcsEndpointsIndex(dict):
    def __init__(__self__, *,
                 index: _builtins.int,
                 url: _builtins.str):
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def index(self) -> _builtins.int:
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        return pulumi.get(self, "url")


@pulumi.output_type
class SamlAttributeStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterType":
            suggest = "filter_type"
        elif key == "filterValue":
            suggest = "filter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SamlAttributeStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SamlAttributeStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SamlAttributeStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 filter_type: Optional[_builtins.str] = None,
                 filter_value: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 values: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str name: The reference name of the attribute statement
        :param _builtins.str filter_type: Type of group attribute filter. Valid values are: `STARTS_WITH`, `EQUALS`, `CONTAINS`, or `REGEX`
        :param _builtins.str filter_value: Filter value to use
        :param _builtins.str namespace: The attribute namespace. It can be set to `urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified`, `urn:oasis:names:tc:SAML:2.0:attrname-format:uri`, or `urn:oasis:names:tc:SAML:2.0:attrname-format:basic`
        :param _builtins.str type: The type of attribute statements object
        """
        pulumi.set(__self__, "name", name)
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if filter_value is not None:
            pulumi.set(__self__, "filter_value", filter_value)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The reference name of the attribute statement
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[_builtins.str]:
        """
        Type of group attribute filter. Valid values are: `STARTS_WITH`, `EQUALS`, `CONTAINS`, or `REGEX`
        """
        return pulumi.get(self, "filter_type")

    @_builtins.property
    @pulumi.getter(name="filterValue")
    def filter_value(self) -> Optional[_builtins.str]:
        """
        Filter value to use
        """
        return pulumi.get(self, "filter_value")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The attribute namespace. It can be set to `urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified`, `urn:oasis:names:tc:SAML:2.0:attrname-format:uri`, or `urn:oasis:names:tc:SAML:2.0:attrname-format:basic`
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of attribute statements object
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "values")


@pulumi.output_type
class SamlKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiresAt":
            suggest = "expires_at"
        elif key == "lastUpdated":
            suggest = "last_updated"
        elif key == "x5tS256":
            suggest = "x5t_s256"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SamlKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SamlKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SamlKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created: Optional[_builtins.str] = None,
                 e: Optional[_builtins.str] = None,
                 expires_at: Optional[_builtins.str] = None,
                 kid: Optional[_builtins.str] = None,
                 kty: Optional[_builtins.str] = None,
                 last_updated: Optional[_builtins.str] = None,
                 n: Optional[_builtins.str] = None,
                 use: Optional[_builtins.str] = None,
                 x5cs: Optional[Sequence[_builtins.str]] = None,
                 x5t_s256: Optional[_builtins.str] = None):
        """
        :param _builtins.str created: Created date
        :param _builtins.str e: RSA exponent
        :param _builtins.str expires_at: Expiration date
        :param _builtins.str kid: Key ID
        :param _builtins.str kty: Key type. Identifies the cryptographic algorithm family used with the key.
        :param _builtins.str last_updated: Last updated date
        :param _builtins.str n: RSA modulus
        :param _builtins.str use: Intended use of the public key.
        :param Sequence[_builtins.str] x5cs: X.509 Certificate Chain
        :param _builtins.str x5t_s256: X.509 certificate SHA-256 thumbprint
        """
        if created is not None:
            pulumi.set(__self__, "created", created)
        if e is not None:
            pulumi.set(__self__, "e", e)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if kid is not None:
            pulumi.set(__self__, "kid", kid)
        if kty is not None:
            pulumi.set(__self__, "kty", kty)
        if last_updated is not None:
            pulumi.set(__self__, "last_updated", last_updated)
        if n is not None:
            pulumi.set(__self__, "n", n)
        if use is not None:
            pulumi.set(__self__, "use", use)
        if x5cs is not None:
            pulumi.set(__self__, "x5cs", x5cs)
        if x5t_s256 is not None:
            pulumi.set(__self__, "x5t_s256", x5t_s256)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[_builtins.str]:
        """
        Created date
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def e(self) -> Optional[_builtins.str]:
        """
        RSA exponent
        """
        return pulumi.get(self, "e")

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[_builtins.str]:
        """
        Expiration date
        """
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter
    def kid(self) -> Optional[_builtins.str]:
        """
        Key ID
        """
        return pulumi.get(self, "kid")

    @_builtins.property
    @pulumi.getter
    def kty(self) -> Optional[_builtins.str]:
        """
        Key type. Identifies the cryptographic algorithm family used with the key.
        """
        return pulumi.get(self, "kty")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> Optional[_builtins.str]:
        """
        Last updated date
        """
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter
    def n(self) -> Optional[_builtins.str]:
        """
        RSA modulus
        """
        return pulumi.get(self, "n")

    @_builtins.property
    @pulumi.getter
    def use(self) -> Optional[_builtins.str]:
        """
        Intended use of the public key.
        """
        return pulumi.get(self, "use")

    @_builtins.property
    @pulumi.getter
    def x5cs(self) -> Optional[Sequence[_builtins.str]]:
        """
        X.509 Certificate Chain
        """
        return pulumi.get(self, "x5cs")

    @_builtins.property
    @pulumi.getter(name="x5tS256")
    def x5t_s256(self) -> Optional[_builtins.str]:
        """
        X.509 certificate SHA-256 thumbprint
        """
        return pulumi.get(self, "x5t_s256")


@pulumi.output_type
class GetSamlAttributeStatementResult(dict):
    def __init__(__self__, *,
                 filter_type: _builtins.str,
                 filter_value: _builtins.str,
                 name: _builtins.str,
                 namespace: _builtins.str,
                 type: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str filter_type: Type of group attribute filter
        :param _builtins.str filter_value: Filter value to use
        :param _builtins.str name: The reference name of the attribute statement
        :param _builtins.str namespace: The name format of the attribute
        :param _builtins.str type: The type of attribute statements object
        """
        pulumi.set(__self__, "filter_type", filter_type)
        pulumi.set(__self__, "filter_value", filter_value)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> _builtins.str:
        """
        Type of group attribute filter
        """
        return pulumi.get(self, "filter_type")

    @_builtins.property
    @pulumi.getter(name="filterValue")
    def filter_value(self) -> _builtins.str:
        """
        Filter value to use
        """
        return pulumi.get(self, "filter_value")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The reference name of the attribute statement
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The name format of the attribute
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of attribute statements object
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")


