# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CampaignArgs', 'Campaign']

@pulumi.input_type
class CampaignArgs:
    def __init__(__self__, *,
                 campaign_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 campaign_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_settings: Optional[pulumi.Input['CampaignNotificationSettingsArgs']] = None,
                 principal_scope_settings: Optional[pulumi.Input['CampaignPrincipalScopeSettingsArgs']] = None,
                 remediation_settings: Optional[pulumi.Input['CampaignRemediationSettingsArgs']] = None,
                 resource_settings: Optional[pulumi.Input['CampaignResourceSettingsArgs']] = None,
                 reviewer_settings: Optional[pulumi.Input['CampaignReviewerSettingsArgs']] = None,
                 schedule_settings: Optional[pulumi.Input['CampaignScheduleSettingsArgs']] = None,
                 skip_remediation: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Campaign resource.
        :param pulumi.Input[_builtins.str] campaign_tier: Indicates the minimum required SKU to manage the campaign. Enum: "BASIC", "PREMIUM".
        :param pulumi.Input[_builtins.str] campaign_type: Identifies if it is a resource campaign or a user campaign. By default, it is "RESOURCE". Enum: "RESOURCE", "USER".
        :param pulumi.Input[_builtins.str] description: Human readable description.
        :param pulumi.Input[_builtins.str] name: Name of the campaign
        :param pulumi.Input['CampaignPrincipalScopeSettingsArgs'] principal_scope_settings: User scope specific settings
        :param pulumi.Input['CampaignRemediationSettingsArgs'] remediation_settings: Specify the action to be taken after a reviewer makes a decision to APPROVE or REVOKE the access, or if the campaign was CLOSED and there was no response from the reviewer.
        :param pulumi.Input['CampaignResourceSettingsArgs'] resource_settings: Resource specific properties.
        :param pulumi.Input['CampaignReviewerSettingsArgs'] reviewer_settings: Identifies the kind of reviewer for Access Certification.
        :param pulumi.Input['CampaignScheduleSettingsArgs'] schedule_settings: Scheduler specific settings.
        :param pulumi.Input[_builtins.bool] skip_remediation: If true, skip remediation when ending the campaign (only applicable if remediationSetting.noResponse=DENY).
        """
        if campaign_tier is not None:
            pulumi.set(__self__, "campaign_tier", campaign_tier)
        if campaign_type is not None:
            pulumi.set(__self__, "campaign_type", campaign_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_settings is not None:
            pulumi.set(__self__, "notification_settings", notification_settings)
        if principal_scope_settings is not None:
            pulumi.set(__self__, "principal_scope_settings", principal_scope_settings)
        if remediation_settings is not None:
            pulumi.set(__self__, "remediation_settings", remediation_settings)
        if resource_settings is not None:
            pulumi.set(__self__, "resource_settings", resource_settings)
        if reviewer_settings is not None:
            pulumi.set(__self__, "reviewer_settings", reviewer_settings)
        if schedule_settings is not None:
            pulumi.set(__self__, "schedule_settings", schedule_settings)
        if skip_remediation is not None:
            pulumi.set(__self__, "skip_remediation", skip_remediation)

    @_builtins.property
    @pulumi.getter(name="campaignTier")
    def campaign_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the minimum required SKU to manage the campaign. Enum: "BASIC", "PREMIUM".
        """
        return pulumi.get(self, "campaign_tier")

    @campaign_tier.setter
    def campaign_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "campaign_tier", value)

    @_builtins.property
    @pulumi.getter(name="campaignType")
    def campaign_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies if it is a resource campaign or a user campaign. By default, it is "RESOURCE". Enum: "RESOURCE", "USER".
        """
        return pulumi.get(self, "campaign_type")

    @campaign_type.setter
    def campaign_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "campaign_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human readable description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the campaign
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> Optional[pulumi.Input['CampaignNotificationSettingsArgs']]:
        return pulumi.get(self, "notification_settings")

    @notification_settings.setter
    def notification_settings(self, value: Optional[pulumi.Input['CampaignNotificationSettingsArgs']]):
        pulumi.set(self, "notification_settings", value)

    @_builtins.property
    @pulumi.getter(name="principalScopeSettings")
    def principal_scope_settings(self) -> Optional[pulumi.Input['CampaignPrincipalScopeSettingsArgs']]:
        """
        User scope specific settings
        """
        return pulumi.get(self, "principal_scope_settings")

    @principal_scope_settings.setter
    def principal_scope_settings(self, value: Optional[pulumi.Input['CampaignPrincipalScopeSettingsArgs']]):
        pulumi.set(self, "principal_scope_settings", value)

    @_builtins.property
    @pulumi.getter(name="remediationSettings")
    def remediation_settings(self) -> Optional[pulumi.Input['CampaignRemediationSettingsArgs']]:
        """
        Specify the action to be taken after a reviewer makes a decision to APPROVE or REVOKE the access, or if the campaign was CLOSED and there was no response from the reviewer.
        """
        return pulumi.get(self, "remediation_settings")

    @remediation_settings.setter
    def remediation_settings(self, value: Optional[pulumi.Input['CampaignRemediationSettingsArgs']]):
        pulumi.set(self, "remediation_settings", value)

    @_builtins.property
    @pulumi.getter(name="resourceSettings")
    def resource_settings(self) -> Optional[pulumi.Input['CampaignResourceSettingsArgs']]:
        """
        Resource specific properties.
        """
        return pulumi.get(self, "resource_settings")

    @resource_settings.setter
    def resource_settings(self, value: Optional[pulumi.Input['CampaignResourceSettingsArgs']]):
        pulumi.set(self, "resource_settings", value)

    @_builtins.property
    @pulumi.getter(name="reviewerSettings")
    def reviewer_settings(self) -> Optional[pulumi.Input['CampaignReviewerSettingsArgs']]:
        """
        Identifies the kind of reviewer for Access Certification.
        """
        return pulumi.get(self, "reviewer_settings")

    @reviewer_settings.setter
    def reviewer_settings(self, value: Optional[pulumi.Input['CampaignReviewerSettingsArgs']]):
        pulumi.set(self, "reviewer_settings", value)

    @_builtins.property
    @pulumi.getter(name="scheduleSettings")
    def schedule_settings(self) -> Optional[pulumi.Input['CampaignScheduleSettingsArgs']]:
        """
        Scheduler specific settings.
        """
        return pulumi.get(self, "schedule_settings")

    @schedule_settings.setter
    def schedule_settings(self, value: Optional[pulumi.Input['CampaignScheduleSettingsArgs']]):
        pulumi.set(self, "schedule_settings", value)

    @_builtins.property
    @pulumi.getter(name="skipRemediation")
    def skip_remediation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, skip remediation when ending the campaign (only applicable if remediationSetting.noResponse=DENY).
        """
        return pulumi.get(self, "skip_remediation")

    @skip_remediation.setter
    def skip_remediation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_remediation", value)


@pulumi.input_type
class _CampaignState:
    def __init__(__self__, *,
                 campaign_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 campaign_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_settings: Optional[pulumi.Input['CampaignNotificationSettingsArgs']] = None,
                 principal_scope_settings: Optional[pulumi.Input['CampaignPrincipalScopeSettingsArgs']] = None,
                 remediation_settings: Optional[pulumi.Input['CampaignRemediationSettingsArgs']] = None,
                 resource_settings: Optional[pulumi.Input['CampaignResourceSettingsArgs']] = None,
                 reviewer_settings: Optional[pulumi.Input['CampaignReviewerSettingsArgs']] = None,
                 schedule_settings: Optional[pulumi.Input['CampaignScheduleSettingsArgs']] = None,
                 skip_remediation: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Campaign resources.
        :param pulumi.Input[_builtins.str] campaign_tier: Indicates the minimum required SKU to manage the campaign. Enum: "BASIC", "PREMIUM".
        :param pulumi.Input[_builtins.str] campaign_type: Identifies if it is a resource campaign or a user campaign. By default, it is "RESOURCE". Enum: "RESOURCE", "USER".
        :param pulumi.Input[_builtins.str] description: Human readable description.
        :param pulumi.Input[_builtins.str] name: Name of the campaign
        :param pulumi.Input['CampaignPrincipalScopeSettingsArgs'] principal_scope_settings: User scope specific settings
        :param pulumi.Input['CampaignRemediationSettingsArgs'] remediation_settings: Specify the action to be taken after a reviewer makes a decision to APPROVE or REVOKE the access, or if the campaign was CLOSED and there was no response from the reviewer.
        :param pulumi.Input['CampaignResourceSettingsArgs'] resource_settings: Resource specific properties.
        :param pulumi.Input['CampaignReviewerSettingsArgs'] reviewer_settings: Identifies the kind of reviewer for Access Certification.
        :param pulumi.Input['CampaignScheduleSettingsArgs'] schedule_settings: Scheduler specific settings.
        :param pulumi.Input[_builtins.bool] skip_remediation: If true, skip remediation when ending the campaign (only applicable if remediationSetting.noResponse=DENY).
        """
        if campaign_tier is not None:
            pulumi.set(__self__, "campaign_tier", campaign_tier)
        if campaign_type is not None:
            pulumi.set(__self__, "campaign_type", campaign_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_settings is not None:
            pulumi.set(__self__, "notification_settings", notification_settings)
        if principal_scope_settings is not None:
            pulumi.set(__self__, "principal_scope_settings", principal_scope_settings)
        if remediation_settings is not None:
            pulumi.set(__self__, "remediation_settings", remediation_settings)
        if resource_settings is not None:
            pulumi.set(__self__, "resource_settings", resource_settings)
        if reviewer_settings is not None:
            pulumi.set(__self__, "reviewer_settings", reviewer_settings)
        if schedule_settings is not None:
            pulumi.set(__self__, "schedule_settings", schedule_settings)
        if skip_remediation is not None:
            pulumi.set(__self__, "skip_remediation", skip_remediation)

    @_builtins.property
    @pulumi.getter(name="campaignTier")
    def campaign_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the minimum required SKU to manage the campaign. Enum: "BASIC", "PREMIUM".
        """
        return pulumi.get(self, "campaign_tier")

    @campaign_tier.setter
    def campaign_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "campaign_tier", value)

    @_builtins.property
    @pulumi.getter(name="campaignType")
    def campaign_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies if it is a resource campaign or a user campaign. By default, it is "RESOURCE". Enum: "RESOURCE", "USER".
        """
        return pulumi.get(self, "campaign_type")

    @campaign_type.setter
    def campaign_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "campaign_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human readable description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the campaign
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> Optional[pulumi.Input['CampaignNotificationSettingsArgs']]:
        return pulumi.get(self, "notification_settings")

    @notification_settings.setter
    def notification_settings(self, value: Optional[pulumi.Input['CampaignNotificationSettingsArgs']]):
        pulumi.set(self, "notification_settings", value)

    @_builtins.property
    @pulumi.getter(name="principalScopeSettings")
    def principal_scope_settings(self) -> Optional[pulumi.Input['CampaignPrincipalScopeSettingsArgs']]:
        """
        User scope specific settings
        """
        return pulumi.get(self, "principal_scope_settings")

    @principal_scope_settings.setter
    def principal_scope_settings(self, value: Optional[pulumi.Input['CampaignPrincipalScopeSettingsArgs']]):
        pulumi.set(self, "principal_scope_settings", value)

    @_builtins.property
    @pulumi.getter(name="remediationSettings")
    def remediation_settings(self) -> Optional[pulumi.Input['CampaignRemediationSettingsArgs']]:
        """
        Specify the action to be taken after a reviewer makes a decision to APPROVE or REVOKE the access, or if the campaign was CLOSED and there was no response from the reviewer.
        """
        return pulumi.get(self, "remediation_settings")

    @remediation_settings.setter
    def remediation_settings(self, value: Optional[pulumi.Input['CampaignRemediationSettingsArgs']]):
        pulumi.set(self, "remediation_settings", value)

    @_builtins.property
    @pulumi.getter(name="resourceSettings")
    def resource_settings(self) -> Optional[pulumi.Input['CampaignResourceSettingsArgs']]:
        """
        Resource specific properties.
        """
        return pulumi.get(self, "resource_settings")

    @resource_settings.setter
    def resource_settings(self, value: Optional[pulumi.Input['CampaignResourceSettingsArgs']]):
        pulumi.set(self, "resource_settings", value)

    @_builtins.property
    @pulumi.getter(name="reviewerSettings")
    def reviewer_settings(self) -> Optional[pulumi.Input['CampaignReviewerSettingsArgs']]:
        """
        Identifies the kind of reviewer for Access Certification.
        """
        return pulumi.get(self, "reviewer_settings")

    @reviewer_settings.setter
    def reviewer_settings(self, value: Optional[pulumi.Input['CampaignReviewerSettingsArgs']]):
        pulumi.set(self, "reviewer_settings", value)

    @_builtins.property
    @pulumi.getter(name="scheduleSettings")
    def schedule_settings(self) -> Optional[pulumi.Input['CampaignScheduleSettingsArgs']]:
        """
        Scheduler specific settings.
        """
        return pulumi.get(self, "schedule_settings")

    @schedule_settings.setter
    def schedule_settings(self, value: Optional[pulumi.Input['CampaignScheduleSettingsArgs']]):
        pulumi.set(self, "schedule_settings", value)

    @_builtins.property
    @pulumi.getter(name="skipRemediation")
    def skip_remediation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, skip remediation when ending the campaign (only applicable if remediationSetting.noResponse=DENY).
        """
        return pulumi.get(self, "skip_remediation")

    @skip_remediation.setter
    def skip_remediation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_remediation", value)


@pulumi.type_token("okta:index/campaign:Campaign")
class Campaign(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 campaign_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 campaign_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_settings: Optional[pulumi.Input[Union['CampaignNotificationSettingsArgs', 'CampaignNotificationSettingsArgsDict']]] = None,
                 principal_scope_settings: Optional[pulumi.Input[Union['CampaignPrincipalScopeSettingsArgs', 'CampaignPrincipalScopeSettingsArgsDict']]] = None,
                 remediation_settings: Optional[pulumi.Input[Union['CampaignRemediationSettingsArgs', 'CampaignRemediationSettingsArgsDict']]] = None,
                 resource_settings: Optional[pulumi.Input[Union['CampaignResourceSettingsArgs', 'CampaignResourceSettingsArgsDict']]] = None,
                 reviewer_settings: Optional[pulumi.Input[Union['CampaignReviewerSettingsArgs', 'CampaignReviewerSettingsArgsDict']]] = None,
                 schedule_settings: Optional[pulumi.Input[Union['CampaignScheduleSettingsArgs', 'CampaignScheduleSettingsArgsDict']]] = None,
                 skip_remediation: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages Campaign. This resource allows you to create and configure an Okta [Campaign](https://developer.okta.com/docs/api/iga/openapi/governance.api/tag/Campaigns/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.Campaign("example", name="example")
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/campaign:Campaign example <campaign_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] campaign_tier: Indicates the minimum required SKU to manage the campaign. Enum: "BASIC", "PREMIUM".
        :param pulumi.Input[_builtins.str] campaign_type: Identifies if it is a resource campaign or a user campaign. By default, it is "RESOURCE". Enum: "RESOURCE", "USER".
        :param pulumi.Input[_builtins.str] description: Human readable description.
        :param pulumi.Input[_builtins.str] name: Name of the campaign
        :param pulumi.Input[Union['CampaignPrincipalScopeSettingsArgs', 'CampaignPrincipalScopeSettingsArgsDict']] principal_scope_settings: User scope specific settings
        :param pulumi.Input[Union['CampaignRemediationSettingsArgs', 'CampaignRemediationSettingsArgsDict']] remediation_settings: Specify the action to be taken after a reviewer makes a decision to APPROVE or REVOKE the access, or if the campaign was CLOSED and there was no response from the reviewer.
        :param pulumi.Input[Union['CampaignResourceSettingsArgs', 'CampaignResourceSettingsArgsDict']] resource_settings: Resource specific properties.
        :param pulumi.Input[Union['CampaignReviewerSettingsArgs', 'CampaignReviewerSettingsArgsDict']] reviewer_settings: Identifies the kind of reviewer for Access Certification.
        :param pulumi.Input[Union['CampaignScheduleSettingsArgs', 'CampaignScheduleSettingsArgsDict']] schedule_settings: Scheduler specific settings.
        :param pulumi.Input[_builtins.bool] skip_remediation: If true, skip remediation when ending the campaign (only applicable if remediationSetting.noResponse=DENY).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CampaignArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Campaign. This resource allows you to create and configure an Okta [Campaign](https://developer.okta.com/docs/api/iga/openapi/governance.api/tag/Campaigns/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.Campaign("example", name="example")
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/campaign:Campaign example <campaign_id>
        ```

        :param str resource_name: The name of the resource.
        :param CampaignArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CampaignArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 campaign_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 campaign_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_settings: Optional[pulumi.Input[Union['CampaignNotificationSettingsArgs', 'CampaignNotificationSettingsArgsDict']]] = None,
                 principal_scope_settings: Optional[pulumi.Input[Union['CampaignPrincipalScopeSettingsArgs', 'CampaignPrincipalScopeSettingsArgsDict']]] = None,
                 remediation_settings: Optional[pulumi.Input[Union['CampaignRemediationSettingsArgs', 'CampaignRemediationSettingsArgsDict']]] = None,
                 resource_settings: Optional[pulumi.Input[Union['CampaignResourceSettingsArgs', 'CampaignResourceSettingsArgsDict']]] = None,
                 reviewer_settings: Optional[pulumi.Input[Union['CampaignReviewerSettingsArgs', 'CampaignReviewerSettingsArgsDict']]] = None,
                 schedule_settings: Optional[pulumi.Input[Union['CampaignScheduleSettingsArgs', 'CampaignScheduleSettingsArgsDict']]] = None,
                 skip_remediation: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CampaignArgs.__new__(CampaignArgs)

            __props__.__dict__["campaign_tier"] = campaign_tier
            __props__.__dict__["campaign_type"] = campaign_type
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_settings"] = notification_settings
            __props__.__dict__["principal_scope_settings"] = principal_scope_settings
            __props__.__dict__["remediation_settings"] = remediation_settings
            __props__.__dict__["resource_settings"] = resource_settings
            __props__.__dict__["reviewer_settings"] = reviewer_settings
            __props__.__dict__["schedule_settings"] = schedule_settings
            __props__.__dict__["skip_remediation"] = skip_remediation
        super(Campaign, __self__).__init__(
            'okta:index/campaign:Campaign',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            campaign_tier: Optional[pulumi.Input[_builtins.str]] = None,
            campaign_type: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notification_settings: Optional[pulumi.Input[Union['CampaignNotificationSettingsArgs', 'CampaignNotificationSettingsArgsDict']]] = None,
            principal_scope_settings: Optional[pulumi.Input[Union['CampaignPrincipalScopeSettingsArgs', 'CampaignPrincipalScopeSettingsArgsDict']]] = None,
            remediation_settings: Optional[pulumi.Input[Union['CampaignRemediationSettingsArgs', 'CampaignRemediationSettingsArgsDict']]] = None,
            resource_settings: Optional[pulumi.Input[Union['CampaignResourceSettingsArgs', 'CampaignResourceSettingsArgsDict']]] = None,
            reviewer_settings: Optional[pulumi.Input[Union['CampaignReviewerSettingsArgs', 'CampaignReviewerSettingsArgsDict']]] = None,
            schedule_settings: Optional[pulumi.Input[Union['CampaignScheduleSettingsArgs', 'CampaignScheduleSettingsArgsDict']]] = None,
            skip_remediation: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Campaign':
        """
        Get an existing Campaign resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] campaign_tier: Indicates the minimum required SKU to manage the campaign. Enum: "BASIC", "PREMIUM".
        :param pulumi.Input[_builtins.str] campaign_type: Identifies if it is a resource campaign or a user campaign. By default, it is "RESOURCE". Enum: "RESOURCE", "USER".
        :param pulumi.Input[_builtins.str] description: Human readable description.
        :param pulumi.Input[_builtins.str] name: Name of the campaign
        :param pulumi.Input[Union['CampaignPrincipalScopeSettingsArgs', 'CampaignPrincipalScopeSettingsArgsDict']] principal_scope_settings: User scope specific settings
        :param pulumi.Input[Union['CampaignRemediationSettingsArgs', 'CampaignRemediationSettingsArgsDict']] remediation_settings: Specify the action to be taken after a reviewer makes a decision to APPROVE or REVOKE the access, or if the campaign was CLOSED and there was no response from the reviewer.
        :param pulumi.Input[Union['CampaignResourceSettingsArgs', 'CampaignResourceSettingsArgsDict']] resource_settings: Resource specific properties.
        :param pulumi.Input[Union['CampaignReviewerSettingsArgs', 'CampaignReviewerSettingsArgsDict']] reviewer_settings: Identifies the kind of reviewer for Access Certification.
        :param pulumi.Input[Union['CampaignScheduleSettingsArgs', 'CampaignScheduleSettingsArgsDict']] schedule_settings: Scheduler specific settings.
        :param pulumi.Input[_builtins.bool] skip_remediation: If true, skip remediation when ending the campaign (only applicable if remediationSetting.noResponse=DENY).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CampaignState.__new__(_CampaignState)

        __props__.__dict__["campaign_tier"] = campaign_tier
        __props__.__dict__["campaign_type"] = campaign_type
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_settings"] = notification_settings
        __props__.__dict__["principal_scope_settings"] = principal_scope_settings
        __props__.__dict__["remediation_settings"] = remediation_settings
        __props__.__dict__["resource_settings"] = resource_settings
        __props__.__dict__["reviewer_settings"] = reviewer_settings
        __props__.__dict__["schedule_settings"] = schedule_settings
        __props__.__dict__["skip_remediation"] = skip_remediation
        return Campaign(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="campaignTier")
    def campaign_tier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates the minimum required SKU to manage the campaign. Enum: "BASIC", "PREMIUM".
        """
        return pulumi.get(self, "campaign_tier")

    @_builtins.property
    @pulumi.getter(name="campaignType")
    def campaign_type(self) -> pulumi.Output[_builtins.str]:
        """
        Identifies if it is a resource campaign or a user campaign. By default, it is "RESOURCE". Enum: "RESOURCE", "USER".
        """
        return pulumi.get(self, "campaign_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human readable description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the campaign
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> pulumi.Output[Optional['outputs.CampaignNotificationSettings']]:
        return pulumi.get(self, "notification_settings")

    @_builtins.property
    @pulumi.getter(name="principalScopeSettings")
    def principal_scope_settings(self) -> pulumi.Output[Optional['outputs.CampaignPrincipalScopeSettings']]:
        """
        User scope specific settings
        """
        return pulumi.get(self, "principal_scope_settings")

    @_builtins.property
    @pulumi.getter(name="remediationSettings")
    def remediation_settings(self) -> pulumi.Output[Optional['outputs.CampaignRemediationSettings']]:
        """
        Specify the action to be taken after a reviewer makes a decision to APPROVE or REVOKE the access, or if the campaign was CLOSED and there was no response from the reviewer.
        """
        return pulumi.get(self, "remediation_settings")

    @_builtins.property
    @pulumi.getter(name="resourceSettings")
    def resource_settings(self) -> pulumi.Output[Optional['outputs.CampaignResourceSettings']]:
        """
        Resource specific properties.
        """
        return pulumi.get(self, "resource_settings")

    @_builtins.property
    @pulumi.getter(name="reviewerSettings")
    def reviewer_settings(self) -> pulumi.Output[Optional['outputs.CampaignReviewerSettings']]:
        """
        Identifies the kind of reviewer for Access Certification.
        """
        return pulumi.get(self, "reviewer_settings")

    @_builtins.property
    @pulumi.getter(name="scheduleSettings")
    def schedule_settings(self) -> pulumi.Output[Optional['outputs.CampaignScheduleSettings']]:
        """
        Scheduler specific settings.
        """
        return pulumi.get(self, "schedule_settings")

    @_builtins.property
    @pulumi.getter(name="skipRemediation")
    def skip_remediation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, skip remediation when ending the campaign (only applicable if remediationSetting.noResponse=DENY).
        """
        return pulumi.get(self, "skip_remediation")

